/*
 * Decompiled with CFR 0.152.
 */
package ketai.sensors;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KetaiSensor
implements SensorEventListener {
    private SensorManager sensorManager = null;
    private boolean isRegistered = false;
    private PApplet parent;
    private Method onSensorEventMethod;
    float[] accelerometerData;
    float[] magnetometerData;
    private Method onAccelerometerEventMethod;
    private Method onAccelerometerEventMethodSimple;
    private Method onOrientationSensorEventMethod;
    private Method onOrientationSensorEventMethodSimple;
    private Method onGyroscopeSensorEventMethod;
    private Method onGyroscopeSensorEventMethodSimple;
    private Method onMagneticFieldSensorEventMethod;
    private Method onMagneticFieldSensorEventMethodSimple;
    private Method onLightSensorEventMethod;
    private Method onLightSensorEventMethodSimple;
    private Method onProximitySensorEventMethod;
    private Method onProximitySensorEventMethodSimple;
    private Method onPressureSensorEventMethod;
    private Method onPressureSensorEventMethodSimple;
    private Method onTemperatureSensorEventMethod;
    private Method onTemperatureSensorEventMethodSimple;
    private Method onRotationVectorSensorEventMethod;
    private Method onRotationVectorSensorEventMethodSimple;
    private Method onGravitySensorEventMethod;
    private Method onGravitySensorEventMethodSimple;
    private Method onLinearAccelerationSensorEventMethod;
    private Method onLinearAccelerationSensorEventMethodSimple;
    private Method onAmbientTemperatureEventMethod;
    private Method onRelativeHumidityEventMethod;
    private boolean accelerometerSensorEnabled;
    private boolean magneticFieldSensorEnabled;
    private boolean orientationSensorEnabled;
    private boolean proximitySensorEnabled;
    private boolean useSimulator;
    private boolean lightSensorEnabled;
    private boolean pressureSensorEnabled;
    private boolean temperatureSensorEnabled;
    private boolean gyroscopeSensorEnabled;
    private boolean rotationVectorSensorEnabled;
    private boolean linearAccelerationSensorEnabled;
    private boolean gravitySensorEnabled;
    private boolean ambientTemperatureSensorEnabled;
    private boolean relativeHumiditySensorEnabled;
    private long delayInterval;
    private long timeOfLastUpdate;
    static final String SERVICE_DESCRIPTION = "Android Sensors.";

    public KetaiSensor(PApplet pParent) {
        this.parent = pParent;
        this.findParentIntentions();
        this.useSimulator = false;
        this.sensorManager = (SensorManager)this.parent.getApplicationContext().getSystemService("sensor");
        this.timeOfLastUpdate = 0L;
        this.delayInterval = 0L;
    }

    public void useSimulator(boolean flag) {
        this.useSimulator = flag;
    }

    public boolean usingSimulator() {
        return this.useSimulator;
    }

    public void setDelayInterval(long pDelayInterval) {
        this.delayInterval = pDelayInterval;
    }

    public void enableAccelerometer() {
        this.accelerometerSensorEnabled = true;
    }

    public void enableRotationVector() {
        this.rotationVectorSensorEnabled = true;
    }

    public void enableLinearAcceleration() {
        this.linearAccelerationSensorEnabled = true;
    }

    public void disableAccelerometer() {
        this.accelerometerSensorEnabled = true;
    }

    public void enableMagenticField() {
        this.magneticFieldSensorEnabled = true;
    }

    public void disableMagneticField() {
        this.magneticFieldSensorEnabled = true;
    }

    public void enableOrientation() {
        this.orientationSensorEnabled = true;
    }

    public void disableOrientation() {
        this.orientationSensorEnabled = false;
    }

    public void enableProximity() {
        this.proximitySensorEnabled = true;
    }

    public void disableProximity() {
        this.proximitySensorEnabled = false;
    }

    public void disablelinearAcceleration() {
        this.linearAccelerationSensorEnabled = false;
    }

    public void disableRotationVector() {
        this.rotationVectorSensorEnabled = false;
    }

    public void enableLight() {
        this.lightSensorEnabled = true;
    }

    public void disableLight() {
        this.lightSensorEnabled = true;
    }

    public void enablePressure() {
        this.pressureSensorEnabled = true;
    }

    public void disablePressure() {
        this.pressureSensorEnabled = true;
    }

    public void enableTemperature() {
        this.temperatureSensorEnabled = true;
    }

    public void disableTemperature() {
        this.temperatureSensorEnabled = false;
    }

    public void enableGyroscope() {
        this.gyroscopeSensorEnabled = true;
    }

    public void disableGyroscope() {
        this.gyroscopeSensorEnabled = false;
    }

    public void disableAmibentTemperature() {
        this.ambientTemperatureSensorEnabled = false;
    }

    public void disableRelativeHumiditySensor() {
        this.relativeHumiditySensorEnabled = false;
    }

    public void enableAmibentTemperature() {
        this.ambientTemperatureSensorEnabled = true;
    }

    public void enableRelativeHumiditySensor() {
        this.relativeHumiditySensorEnabled = true;
    }

    public void enableAllSensors() {
        this.relativeHumiditySensorEnabled = true;
        this.ambientTemperatureSensorEnabled = true;
        this.rotationVectorSensorEnabled = true;
        this.linearAccelerationSensorEnabled = true;
        this.gyroscopeSensorEnabled = true;
        this.temperatureSensorEnabled = true;
        this.pressureSensorEnabled = true;
        this.lightSensorEnabled = true;
        this.proximitySensorEnabled = true;
        this.orientationSensorEnabled = true;
        this.magneticFieldSensorEnabled = true;
        this.accelerometerSensorEnabled = true;
    }

    public boolean isAccelerometerAvailable() {
        return this.isSensorSupported(1);
    }

    public boolean isLinearAccelerationAvailable() {
        return this.isSensorSupported(10);
    }

    public boolean isRotationVectorAvailable() {
        return this.isSensorSupported(11);
    }

    public boolean isMagenticFieldAvailable() {
        return this.isSensorSupported(2);
    }

    public boolean isOrientationAvailable() {
        return this.isSensorSupported(3);
    }

    public boolean isProximityAvailable() {
        return this.isSensorSupported(8);
    }

    public boolean isLightAvailable() {
        return this.isSensorSupported(5);
    }

    public boolean isPressureAvailable() {
        return this.isSensorSupported(6);
    }

    public boolean isTemperatureAvailable() {
        return this.isSensorSupported(7);
    }

    public boolean isGyroscopeAvailable() {
        return this.isSensorSupported(4);
    }

    public boolean isAmbientTemperatureAvailable() {
        return this.isSensorSupported(13);
    }

    public boolean isRelativeHumidityAvailable() {
        return this.isSensorSupported(12);
    }

    public Collection<? extends String> list() {
        Vector<String> list = new Vector<String>();
        List foo = this.sensorManager.getSensorList(-1);
        for (Sensor s : foo) {
            list.add(s.getName());
            PApplet.println((String)("\tKetaiSensor sensor: " + s.getName() + ":" + s.getType()));
        }
        return list;
    }

    public boolean isStarted() {
        return this.isRegistered;
    }

    public void start() {
        Sensor s;
        PApplet.println((String)"KetaiSensor: start()...");
        this.findParentIntentions();
        if (this.accelerometerSensorEnabled && (s = this.sensorManager.getDefaultSensor(1)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.magneticFieldSensorEnabled && (s = this.sensorManager.getDefaultSensor(2)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.pressureSensorEnabled && (s = this.sensorManager.getDefaultSensor(6)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.orientationSensorEnabled && (s = this.sensorManager.getDefaultSensor(3)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.proximitySensorEnabled && (s = this.sensorManager.getDefaultSensor(8)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.temperatureSensorEnabled && (s = this.sensorManager.getDefaultSensor(7)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.gyroscopeSensorEnabled && (s = this.sensorManager.getDefaultSensor(4)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.rotationVectorSensorEnabled && (s = this.sensorManager.getDefaultSensor(11)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.linearAccelerationSensorEnabled && (s = this.sensorManager.getDefaultSensor(10)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.lightSensorEnabled && (s = this.sensorManager.getDefaultSensor(5)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.gravitySensorEnabled && (s = this.sensorManager.getDefaultSensor(9)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.ambientTemperatureSensorEnabled && (s = this.sensorManager.getDefaultSensor(13)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        if (this.relativeHumiditySensorEnabled && (s = this.sensorManager.getDefaultSensor(12)) != null) {
            this.sensorManager.registerListener((SensorEventListener)this, s, 2);
        }
        this.isRegistered = true;
    }

    public void stop() {
        PApplet.println((String)"KetaiSensor: Stop()....");
        this.sensorManager.unregisterListener((SensorEventListener)this);
        this.isRegistered = false;
    }

    public void onSensorChanged(SensorEvent arg0) {
        Date date = new Date();
        long now = date.getTime();
        if (now < this.timeOfLastUpdate + this.delayInterval) {
            return;
        }
        this.timeOfLastUpdate = now;
        if (this.onSensorEventMethod != null) {
            try {
                this.onSensorEventMethod.invoke((Object)this.parent, arg0);
                return;
            }
            catch (Exception e) {
                PApplet.println((String)("Disabling onSensorEvent() because of an error:" + e.getMessage()));
                e.printStackTrace();
                this.onSensorEventMethod = null;
            }
        }
        if (arg0.sensor.getType() == 1 && this.accelerometerSensorEnabled) {
            if (this.onAccelerometerEventMethod != null) {
                try {
                    this.accelerometerData = (float[])arg0.values.clone();
                    this.onAccelerometerEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onAccelerometerEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onAccelerometerEventMethodSimple != null) {
                try {
                    this.accelerometerData = (float[])arg0.values.clone();
                    this.onAccelerometerEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onAccelerometerEvent() [simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 9 && this.gravitySensorEnabled) {
            if (this.onGravitySensorEventMethod != null) {
                try {
                    this.onGravitySensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onGravityEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onGravitySensorEventMethodSimple != null) {
                try {
                    this.onGravitySensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onGravityEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 3 && this.orientationSensorEnabled) {
            if (this.onOrientationSensorEventMethod != null) {
                try {
                    this.onOrientationSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onOrientationEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onOrientationSensorEventMethodSimple != null) {
                try {
                    this.onOrientationSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onOrientationEvent()[simple] :" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 2 && this.magneticFieldSensorEnabled) {
            if (this.onMagneticFieldSensorEventMethod != null) {
                try {
                    this.magnetometerData = (float[])arg0.values.clone();
                    this.onMagneticFieldSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onMagneticFieldEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onMagneticFieldSensorEventMethodSimple != null) {
                try {
                    this.magnetometerData = (float[])arg0.values.clone();
                    this.onMagneticFieldSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onMagneticFieldEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 4 && this.gyroscopeSensorEnabled) {
            if (this.onGyroscopeSensorEventMethod != null) {
                try {
                    this.onGyroscopeSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onGyroscopeEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onGyroscopeSensorEventMethodSimple != null) {
                try {
                    this.onGyroscopeSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onGyroscopeEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 5 && this.lightSensorEnabled) {
            if (this.onLightSensorEventMethod != null) {
                try {
                    this.onLightSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onLightEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onLightSensorEventMethodSimple != null) {
                try {
                    this.onLightSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onLightEvent()[simple]r:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 8 && this.proximitySensorEnabled) {
            if (this.onProximitySensorEventMethod != null) {
                try {
                    this.onProximitySensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onProximityEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onProximitySensorEventMethodSimple != null) {
                try {
                    this.onProximitySensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onProximityEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 6 && this.pressureSensorEnabled) {
            if (this.onPressureSensorEventMethod != null) {
                try {
                    this.onPressureSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onPressureEvent()r:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onPressureSensorEventMethodSimple != null) {
                try {
                    this.onPressureSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onPressureEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 7 && this.temperatureSensorEnabled) {
            if (this.onTemperatureSensorEventMethod != null) {
                try {
                    this.onTemperatureSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onTemperatureEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onTemperatureSensorEventMethodSimple != null) {
                try {
                    this.onTemperatureSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onTemperatureEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 10 && this.linearAccelerationSensorEnabled) {
            if (this.onLinearAccelerationSensorEventMethod != null) {
                try {
                    this.onLinearAccelerationSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onLinearAccelerationEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onLinearAccelerationSensorEventMethodSimple != null) {
                try {
                    this.onLinearAccelerationSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onLinearAccelerationEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 11 && this.rotationVectorSensorEnabled) {
            if (this.onRotationVectorSensorEventMethod != null) {
                try {
                    this.onRotationVectorSensorEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]), arg0.timestamp, arg0.accuracy);
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onRotationVectorEvent():" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.onRotationVectorSensorEventMethodSimple != null) {
                try {
                    this.onRotationVectorSensorEventMethodSimple.invoke((Object)this.parent, Float.valueOf(arg0.values[0]), Float.valueOf(arg0.values[1]), Float.valueOf(arg0.values[2]));
                    this.timeOfLastUpdate = now;
                    return;
                }
                catch (Exception e) {
                    PApplet.println((String)("Error onRotationVectorEvent()[simple]:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (arg0.sensor.getType() == 13 && this.ambientTemperatureSensorEnabled && this.onAmbientTemperatureEventMethod != null) {
            try {
                this.onAmbientTemperatureEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]));
                this.timeOfLastUpdate = now;
                return;
            }
            catch (Exception e) {
                PApplet.println((String)("Error onAmbientTemperatureEvent():" + e.getMessage()));
                e.printStackTrace();
            }
        }
        if (arg0.sensor.getType() == 12 && this.relativeHumiditySensorEnabled && this.onRelativeHumidityEventMethod != null) {
            try {
                this.onRelativeHumidityEventMethod.invoke((Object)this.parent, Float.valueOf(arg0.values[0]));
                this.timeOfLastUpdate = now;
                return;
            }
            catch (Exception e) {
                PApplet.println((String)("Error onRelativeHumidityEventMethod():" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private boolean isSensorSupported(int type) {
        List foo = this.sensorManager.getSensorList(-1);
        for (Sensor s : foo) {
            if (type != s.getType()) continue;
            return true;
        }
        return false;
    }

    private void findParentIntentions() {
        try {
            this.onSensorEventMethod = this.parent.getClass().getMethod("onSensorEvent", SensorEvent.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onAccelerometerEventMethod = this.parent.getClass().getMethod("onAccelerometerEvent", Float.TYPE, Float.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE);
            this.accelerometerSensorEnabled = true;
            PApplet.println((String)"Found onAccelerometerEvent\tMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onAccelerometerEventMethodSimple = this.parent.getClass().getMethod("onAccelerometerEvent", Float.TYPE, Float.TYPE, Float.TYPE);
            this.accelerometerSensorEnabled = true;
            PApplet.println((String)"Found onAccelerometerEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onOrientationSensorEventMethod = this.parent.getClass().getMethod("onOrientationEvent", Float.TYPE, Float.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE);
            this.orientationSensorEnabled = true;
            PApplet.println((String)"Found onOrientationEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onOrientationSensorEventMethodSimple = this.parent.getClass().getMethod("onOrientationEvent", Float.TYPE, Float.TYPE, Float.TYPE);
            this.orientationSensorEnabled = true;
            PApplet.println((String)"Found onOrientationEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onMagneticFieldSensorEventMethod = this.parent.getClass().getMethod("onMagneticFieldEvent", Float.TYPE, Float.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE);
            this.magneticFieldSensorEnabled = true;
            PApplet.println((String)"Found onMagneticFieldEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onMagneticFieldSensorEventMethodSimple = this.parent.getClass().getMethod("onMagneticFieldEvent", Float.TYPE, Float.TYPE, Float.TYPE);
            this.magneticFieldSensorEnabled = true;
            PApplet.println((String)"Found onMagneticFieldEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onGyroscopeSensorEventMethod = this.parent.getClass().getMethod("onGyroscopeEvent", Float.TYPE, Float.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE);
            this.gyroscopeSensorEnabled = true;
            PApplet.println((String)"Found onGyroscopeEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onGyroscopeSensorEventMethodSimple = this.parent.getClass().getMethod("onGyroscopeEvent", Float.TYPE, Float.TYPE, Float.TYPE);
            this.gyroscopeSensorEnabled = true;
            PApplet.println((String)"Found onGyroscopeEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onGravitySensorEventMethod = this.parent.getClass().getMethod("onGravityEvent", Float.TYPE, Float.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE);
            this.gravitySensorEnabled = true;
            PApplet.println((String)"Found onGravityEvenMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onGravitySensorEventMethodSimple = this.parent.getClass().getMethod("onGravityEvent", Float.TYPE, Float.TYPE, Float.TYPE);
            this.gravitySensorEnabled = true;
            PApplet.println((String)"Found onGravityEvenMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onProximitySensorEventMethod = this.parent.getClass().getMethod("onProximityEvent", Float.TYPE, Long.TYPE, Integer.TYPE);
            this.proximitySensorEnabled = true;
            PApplet.println((String)"Found onLightEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onProximitySensorEventMethodSimple = this.parent.getClass().getMethod("onProximityEvent", Float.TYPE);
            this.proximitySensorEnabled = true;
            PApplet.println((String)"Found onProximityEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onLightSensorEventMethod = this.parent.getClass().getMethod("onLightEvent", Float.TYPE, Long.TYPE, Integer.TYPE);
            this.lightSensorEnabled = true;
            PApplet.println((String)"Found onLightEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onLightSensorEventMethodSimple = this.parent.getClass().getMethod("onLightEvent", Float.TYPE);
            this.lightSensorEnabled = true;
            PApplet.println((String)"Found onLightEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onPressureSensorEventMethod = this.parent.getClass().getMethod("onPressureEvent", Float.TYPE, Long.TYPE, Integer.TYPE);
            this.pressureSensorEnabled = true;
            PApplet.println((String)"Found onPressureEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onPressureSensorEventMethodSimple = this.parent.getClass().getMethod("onPressureEvent", Float.TYPE);
            this.pressureSensorEnabled = true;
            PApplet.println((String)"Found onPressureEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onTemperatureSensorEventMethod = this.parent.getClass().getMethod("onTemperatureEvent", Float.TYPE, Long.TYPE, Integer.TYPE);
            this.temperatureSensorEnabled = true;
            PApplet.println((String)"Found onTemperatureEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onTemperatureSensorEventMethodSimple = this.parent.getClass().getMethod("onTemperatureEvent", Float.TYPE);
            this.temperatureSensorEnabled = true;
            PApplet.println((String)"Found onTemperatureEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onLinearAccelerationSensorEventMethod = this.parent.getClass().getMethod("onLinearAccelerationEvent", Float.TYPE, Float.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE);
            this.linearAccelerationSensorEnabled = true;
            PApplet.println((String)"Found onLinearAccelerationEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onLinearAccelerationSensorEventMethodSimple = this.parent.getClass().getMethod("onLinearAccelerationEvent", Float.TYPE, Float.TYPE, Float.TYPE);
            this.linearAccelerationSensorEnabled = true;
            PApplet.println((String)"Found onLinearAccelerationEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onRotationVectorSensorEventMethod = this.parent.getClass().getMethod("onRotationVectorEvent", Float.TYPE, Float.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE);
            this.rotationVectorSensorEnabled = true;
            PApplet.println((String)"Found onRotationVectorEvenMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onRotationVectorSensorEventMethodSimple = this.parent.getClass().getMethod("onRotationVectorEvent", Float.TYPE, Float.TYPE, Float.TYPE);
            this.rotationVectorSensorEnabled = true;
            PApplet.println((String)"Found onRotationVectorEventMethod(simple)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onAmbientTemperatureEventMethod = this.parent.getClass().getMethod("onAmibentTemperatureEvent", Float.TYPE);
            this.ambientTemperatureSensorEnabled = true;
            PApplet.println((String)"Found onAmbientTemperatureEvent callback...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onRelativeHumidityEventMethod = this.parent.getClass().getMethod("onRelativeHumidityEvent", Float.TYPE);
            this.relativeHumiditySensorEnabled = true;
            PApplet.println((String)"Found onRelativeHumidityEventMethod...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void startService() {
        this.start();
    }

    public int getStatus() {
        return 0;
    }

    public void stopService() {
        this.stop();
    }

    public String getServiceDescription() {
        return SERVICE_DESCRIPTION;
    }

    public void getRotationMatrixFromVector(float[] R, float[] rotationVector) {
        SensorManager.getRotationMatrixFromVector((float[])R, (float[])rotationVector);
    }

    public void getQuaternionFromVector(float[] Q, float[] rv) {
        SensorManager.getQuaternionFromVector((float[])Q, (float[])rv);
    }

    public float[] getOrientation() {
        float[] values = new float[3];
        float[] R = new float[16];
        float[] I = new float[9];
        if (!(this.isStarted() || this.accelerometerSensorEnabled || this.magneticFieldSensorEnabled)) {
            PApplet.println((String)"Cannot compute orientation until sensor service is started and accelerometer and magnetometer must also be enabled.");
            values = new float[3];
            return values;
        }
        if (SensorManager.getRotationMatrix((float[])R, (float[])I, (float[])this.accelerometerData, (float[])this.magnetometerData)) {
            values = SensorManager.getOrientation(null, (float[])values);
        }
        return values;
    }
}

