/*
 * Decompiled with CFR 0.152.
 */
package ketai.net.nfc.record;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import ketai.net.nfc.NdefMessageParser;
import ketai.net.nfc.record.ParsedNdefRecord;
import ketai.net.nfc.record.TextRecord;
import ketai.net.nfc.record.UriRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartPoster
implements ParsedNdefRecord {
    private final TextRecord mTitleRecord;
    private final UriRecord mUriRecord;
    private static final byte[] ACTION_RECORD_TYPE = new byte[]{97, 99, 116};
    private static final byte[] TYPE_TYPE = new byte[]{116};

    private SmartPoster(UriRecord uri, TextRecord title, RecommendedAction action, String type) {
        this.mUriRecord = uri;
        this.mTitleRecord = title;
    }

    public UriRecord getUriRecord() {
        return this.mUriRecord;
    }

    public TextRecord getTitle() {
        return this.mTitleRecord;
    }

    public static SmartPoster parse(NdefRecord record) {
        try {
            NdefMessage subRecords = new NdefMessage(record.getPayload());
            return SmartPoster.parse(subRecords.getRecords());
        }
        catch (FormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static SmartPoster parse(NdefRecord[] recordsRaw) {
        try {
            List<ParsedNdefRecord> records = NdefMessageParser.getRecords(recordsRaw);
            TextRecord title = SmartPoster.getFirstIfExists(records, TextRecord.class);
            RecommendedAction action = SmartPoster.parseRecommendedAction(recordsRaw);
            String type = SmartPoster.parseType(recordsRaw);
            return new SmartPoster(null, title, action, type);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isPoster(NdefRecord record) {
        try {
            SmartPoster.parse(record);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static <T> T getFirstIfExists(Iterable<?> elements, Class<T> type) {
        return null;
    }

    private static NdefRecord getByType(byte[] type, NdefRecord[] records) {
        NdefRecord[] ndefRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            NdefRecord record = ndefRecordArray[n2];
            if (Arrays.equals(type, record.getType())) {
                return record;
            }
            ++n2;
        }
        return null;
    }

    private static RecommendedAction parseRecommendedAction(NdefRecord[] records) {
        NdefRecord record = SmartPoster.getByType(ACTION_RECORD_TYPE, records);
        if (record == null) {
            return RecommendedAction.UNKNOWN;
        }
        byte action = record.getPayload()[0];
        return RecommendedAction.UNKNOWN;
    }

    private static String parseType(NdefRecord[] records) {
        NdefRecord type = SmartPoster.getByType(TYPE_TYPE, records);
        if (type == null) {
            return null;
        }
        return null;
    }

    @Override
    public String getTag() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RecommendedAction {
        UNKNOWN(-1),
        DO_ACTION(0),
        SAVE_FOR_LATER(1),
        OPEN_FOR_EDITING(2);

        private final byte mAction;

        private RecommendedAction(byte val) {
            this.mAction = val;
        }

        private byte getByte() {
            return this.mAction;
        }
    }
}

