/*
 * Decompiled with CFR 0.152.
 */
package ketai.net.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ketai.net.bluetooth.KBluetoothConnection;
import ketai.net.bluetooth.KBluetoothListener;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KetaiBluetooth {
    protected PApplet parent;
    protected BluetoothAdapter bluetoothAdapter;
    private HashMap<String, String> pairedDevices;
    private HashMap<String, String> discoveredDevices;
    private HashMap<String, KBluetoothConnection> currentConnections;
    private KBluetoothListener btListener;
    private ConnectThread mConnectThread;
    private boolean isStarted = false;
    protected Method onBluetoothDataEventMethod;
    protected UUID MY_UUID_SECURE = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    protected UUID MY_UUID_INSECURE = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    protected String NAME_SECURE = "BluetoothSecure";
    protected String NAME_INSECURE = "BluetoothInsecure";
    static final int BLUETOOTH_ENABLE_REQUEST = 1;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device;
            String action = intent.getAction();
            if ("android.bluetooth.device.action.FOUND".equals(action) && (device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) != null) {
                KetaiBluetooth.this.discoveredDevices.put(device.getName(), device.getAddress());
                PApplet.println((String)("New Device Discovered: " + device.getName()));
            }
        }
    };

    public KetaiBluetooth(PApplet _parent) {
        this.parent = _parent;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            PApplet.println((String)"No Bluetooth Support.");
            return;
        }
        if (!this.bluetoothAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            this.parent.startActivityForResult(enableBtIntent, 1);
        }
        this.pairedDevices = new HashMap();
        this.discoveredDevices = new HashMap();
        this.currentConnections = new HashMap();
        this.findParentIntention();
    }

    public void setSLIPMode(boolean _flag) {
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public BluetoothAdapter getBluetoothAdapater() {
        return this.bluetoothAdapter;
    }

    public boolean isDiscovering() {
        return this.bluetoothAdapter.isDiscovering();
    }

    public String toString() {
        String info = "KBluetoothManager dump:\n--------------------\nPairedDevices:\n";
        for (String key : this.pairedDevices.keySet()) {
            info = String.valueOf(info) + key + "->" + this.pairedDevices.get(key) + "\n";
        }
        info = String.valueOf(info) + "\n\nDiscovered Devices\n";
        for (String key : this.discoveredDevices.keySet()) {
            info = String.valueOf(info) + key + "->" + this.discoveredDevices.get(key) + "\n";
        }
        info = String.valueOf(info) + "\n\nCurrent Connections\n";
        for (String key : this.currentConnections.keySet()) {
            info = String.valueOf(info) + key + "->" + this.currentConnections.get(key) + "\n";
        }
        info = String.valueOf(info) + "\n-------------------------------\n";
        return info;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                if (resultCode == -1) {
                    PApplet.println((String)"BT made available.");
                    break;
                }
                PApplet.println((String)"BT was not made available.");
            }
        }
    }

    public boolean isDiscoverable() {
        return this.bluetoothAdapter.getScanMode() == 23;
    }

    public boolean start() {
        if (this.btListener != null) {
            this.stop();
            this.isStarted = false;
        }
        this.btListener = new KBluetoothListener(this, true);
        this.btListener.start();
        this.isStarted = true;
        this.findParentIntention();
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.parent.registerReceiver(this.mReceiver, filter);
        this.parent.registerReceiver(this.mReceiver, new IntentFilter("android.bluetooth.adapter.action.DISCOVERY_FINISHED"));
        return this.isStarted;
    }

    public String getAddress() {
        if (this.bluetoothAdapter != null) {
            return this.bluetoothAdapter.getAddress();
        }
        return "";
    }

    public ArrayList<String> getDiscoveredDeviceNames() {
        ArrayList<String> devices = new ArrayList<String>();
        for (String key : this.discoveredDevices.keySet()) {
            if (key == null) continue;
            devices.add(key);
        }
        return devices;
    }

    public ArrayList<String> getPairedDeviceNames() {
        ArrayList<String> devices = new ArrayList<String>();
        this.pairedDevices.clear();
        Set bondedDevices = this.bluetoothAdapter.getBondedDevices();
        if (bondedDevices.size() > 0) {
            for (BluetoothDevice device : bondedDevices) {
                this.pairedDevices.put(device.getName(), device.getAddress());
                devices.add(device.getName());
            }
        }
        return devices;
    }

    public ArrayList<String> getConnectedDeviceNames() {
        ArrayList<String> devices = new ArrayList<String>();
        Set<String> connectedDevices = this.currentConnections.keySet();
        if (connectedDevices.size() > 0) {
            for (String device : connectedDevices) {
                KBluetoothConnection c = this.currentConnections.get(device);
                devices.add(String.valueOf(c.getDeviceName()) + "(" + device + ")");
            }
        }
        return devices;
    }

    public boolean connectToDeviceByName(String _name) {
        String address = "";
        if (this.pairedDevices.containsKey(_name)) {
            address = this.pairedDevices.get(_name);
        } else if (this.discoveredDevices.containsKey(_name)) {
            address = this.discoveredDevices.get(_name);
        }
        if (address.length() > 0 && this.currentConnections.containsKey(address)) {
            return true;
        }
        return this.connectDevice(address);
    }

    public boolean connectDevice(String _hwAddress) {
        if (!BluetoothAdapter.checkBluetoothAddress((String)_hwAddress)) {
            PApplet.println((String)("Bad bluetooth hardware address! : " + _hwAddress));
            return false;
        }
        BluetoothDevice device = this.bluetoothAdapter.getRemoteDevice(_hwAddress);
        if (this.mConnectThread == null) {
            this.mConnectThread = new ConnectThread(device, true);
            this.mConnectThread.start();
        } else if (this.mConnectThread.mmDevice.getAddress() != _hwAddress) {
            this.mConnectThread.cancel();
            this.mConnectThread = new ConnectThread(device, true);
            this.mConnectThread.start();
        }
        return false;
    }

    public boolean connectDeviceUsingSLIP(String _hwAddress) {
        return false;
    }

    public boolean connectDevice(BluetoothSocket _socket) {
        KBluetoothConnection tmp = new KBluetoothConnection(this, _socket);
        if (!tmp.isConnected()) {
            PApplet.println((String)("Error trying to connect to " + _socket.getRemoteDevice().getName() + " (" + _socket.getRemoteDevice().getAddress() + ")"));
            this.mConnectThread = null;
            return false;
        }
        tmp.start();
        if (tmp != null && !this.currentConnections.containsKey(_socket.getRemoteDevice().getAddress())) {
            this.currentConnections.put(_socket.getRemoteDevice().getAddress(), tmp);
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        return true;
    }

    public void discoverDevices() {
        this.discoveredDevices.clear();
        this.bluetoothAdapter.cancelDiscovery();
        if (this.bluetoothAdapter.startDiscovery()) {
            PApplet.println((String)"Starting bt discovery.");
        } else {
            PApplet.println((String)"BT discovery failed to start.");
        }
    }

    public String lookupAddressByName(String _name) {
        if (this.pairedDevices.containsKey(_name)) {
            return this.pairedDevices.get(_name);
        }
        if (this.discoveredDevices.containsKey(_name)) {
            return this.discoveredDevices.get(_name);
        }
        return "";
    }

    public void writeToDeviceName(String _name, byte[] data) {
        String address = this.lookupAddressByName(_name);
        if (address.length() > 0) {
            this.write(address, data);
        } else {
            PApplet.println((String)("Error writing to " + _name + ".  HW Address was not found."));
        }
    }

    public void write(String _deviceAddress, byte[] data) {
        this.bluetoothAdapter.cancelDiscovery();
        if (!this.currentConnections.containsKey(_deviceAddress) && !this.connectDevice(_deviceAddress)) {
            return;
        }
        if (this.currentConnections.containsKey(_deviceAddress)) {
            this.currentConnections.get(_deviceAddress).write(data);
        }
    }

    public void broadcast(byte[] data) {
        for (Map.Entry<String, KBluetoothConnection> device : this.currentConnections.entrySet()) {
            device.getValue().write(data);
        }
    }

    protected void removeConnection(KBluetoothConnection c) {
        PApplet.println((String)("KBTM removing connection for " + c.getAddress()));
        if (this.currentConnections.containsKey(c.getAddress())) {
            c.cancel();
            this.currentConnections.remove(c.getAddress());
        }
    }

    public void makeDiscoverable() {
        if (this.bluetoothAdapter.getScanMode() != 23) {
            Intent discoverableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
            discoverableIntent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", 300);
            this.parent.startActivity(discoverableIntent);
        }
    }

    private void findParentIntention() {
        try {
            this.onBluetoothDataEventMethod = this.parent.getClass().getMethod("onBluetoothDataEvent", String.class, byte[].class);
            PApplet.println((String)"Found onBluetoothDataEvent method.");
        }
        catch (NoSuchMethodException e) {
            PApplet.println((String)"Did not find onBluetoothDataEvent callback method.");
        }
    }

    public void stop() {
        if (this.btListener != null) {
            this.btListener.cancel();
        }
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
        }
        for (String key : this.currentConnections.keySet()) {
            this.currentConnections.get(key).cancel();
        }
        this.currentConnections.clear();
        this.btListener = null;
        this.mConnectThread = null;
    }

    private class ConnectThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        protected final BluetoothDevice mmDevice;
        private String mSocketType;

        public ConnectThread(BluetoothDevice device, boolean secure) {
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            this.mSocketType = secure ? "Secure" : "Insecure";
            try {
                tmp = secure ? device.createRfcommSocketToServiceRecord(KetaiBluetooth.this.MY_UUID_SECURE) : device.createInsecureRfcommSocketToServiceRecord(KetaiBluetooth.this.MY_UUID_INSECURE);
            }
            catch (IOException e) {
                PApplet.println((String)("Socket Type: " + this.mSocketType + "create() failed" + e));
            }
            this.mmSocket = tmp;
        }

        public void run() {
            while (this.mmSocket == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            PApplet.println((String)("BEGIN mConnectThread SocketType:" + this.mSocketType + ":" + this.mmSocket.getRemoteDevice().getName()));
            KetaiBluetooth.this.bluetoothAdapter.cancelDiscovery();
            try {
                if (this.mmSocket != null) {
                    this.mmSocket.connect();
                }
                PApplet.println((String)"KBTConnect thread connected!");
            }
            catch (IOException e) {
                try {
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    PApplet.println((String)("unable to close() " + this.mSocketType + " socket during connection failure" + e2));
                }
                KetaiBluetooth.this.mConnectThread = null;
                return;
            }
            KetaiBluetooth.this.connectDevice(this.mmSocket);
        }

        public void cancel() {
        }
    }
}

