/*
 * Decompiled with CFR 0.152.
 */
package ketai.camera;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.opengl.GLES20;
import android.os.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import ketai.camera.KetaiFace;
import processing.core.PApplet;
import processing.core.PImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KetaiCamera
extends PImage {
    private Camera camera;
    private int[] myPixels;
    protected Method onPreviewEventMethod;
    protected Method onPreviewEventMethodPImage;
    protected Method onSavePhotoEventMethod;
    protected Method onFaceDetectionEventMethod;
    private int frameWidth;
    private int frameHeight;
    private int cameraFPS;
    private int cameraID;
    private int photoWidth;
    private int photoHeight;
    public boolean isStarted;
    public boolean requestedStart;
    public boolean enableFlash;
    public boolean isRGBPreviewSupported;
    private String savePhotoPath = "";
    KetaiCamera self;
    String SAVE_DIR = "";
    boolean available = false;
    boolean supportsFaceDetection = false;
    SurfaceTexture mTexture;
    int lastProcessedFrame = 0;
    Camera.PreviewCallback previewcallback = new Camera.PreviewCallback(){

        public void onPreviewFrame(byte[] data, Camera camera) {
            if (KetaiCamera.this.parent.millis() - KetaiCamera.this.lastProcessedFrame < 1000 / KetaiCamera.this.cameraFPS) {
                return;
            }
            KetaiCamera.this.lastProcessedFrame = KetaiCamera.this.parent.millis();
            if (camera == null || !KetaiCamera.this.isStarted) {
                return;
            }
            if (KetaiCamera.this.myPixels == null || KetaiCamera.this.myPixels.length != KetaiCamera.this.frameWidth * KetaiCamera.this.frameHeight) {
                KetaiCamera.this.myPixels = new int[KetaiCamera.this.frameWidth * KetaiCamera.this.frameHeight];
            }
            KetaiCamera.this.decodeYUV420SP(data);
            if (KetaiCamera.this.myPixels == null) {
                return;
            }
            if (KetaiCamera.this.onPreviewEventMethod != null && KetaiCamera.this.myPixels != null) {
                try {
                    KetaiCamera.this.onPreviewEventMethod.invoke((Object)KetaiCamera.this.parent, new Object[0]);
                }
                catch (Exception e) {
                    PApplet.println((String)(" onCameraPreviewEvent() had  an error:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (KetaiCamera.this.onPreviewEventMethodPImage != null && KetaiCamera.this.myPixels != null) {
                try {
                    KetaiCamera.this.onPreviewEventMethodPImage.invoke((Object)KetaiCamera.this.parent, new Object[]{KetaiCamera.this.self});
                }
                catch (Exception e) {
                    PApplet.println((String)("Disabling onCameraPreviewEvent(KetaiCamera) because of an error:" + e.getMessage()));
                    e.printStackTrace();
                    KetaiCamera.this.onPreviewEventMethodPImage = null;
                }
            }
        }
    };
    private Camera.AutoFocusCallback autofocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean result, Camera c) {
            PApplet.println((String)("Autofocus result: " + result));
        }
    };
    private Camera.PictureCallback jpegCallback = new Camera.PictureCallback(){

        public void onPictureTaken(byte[] data, Camera camera) {
            PApplet.println((String)"pictureCallback entered...");
            if (camera == null) {
                return;
            }
            FileOutputStream outStream = null;
            try {
                PApplet.println((String)("Saving image: " + KetaiCamera.this.savePhotoPath));
                outStream = new FileOutputStream(KetaiCamera.this.savePhotoPath);
                outStream.write(data);
                outStream.close();
                if (KetaiCamera.this.onSavePhotoEventMethod != null && KetaiCamera.this.myPixels != null && KetaiCamera.this.savePhotoPath != null) {
                    try {
                        KetaiCamera.this.onSavePhotoEventMethod.invoke((Object)KetaiCamera.this.parent, KetaiCamera.this.savePhotoPath);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                camera.startPreview();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    };
    private MediaScannerConnection.OnScanCompletedListener myScannerCallback = new MediaScannerConnection.OnScanCompletedListener(){

        public void onScanCompleted(String arg0, Uri arg1) {
            PApplet.println((String)("Media Scanner returned: " + arg1.toString() + " => " + arg0));
        }
    };

    public KetaiCamera(PApplet pParent, int _width, int _height, int _framesPerSecond) {
        super(_width, _height, 2);
        ApplicationInfo ai;
        this.bitmap = Bitmap.createBitmap((int[])this.pixels, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.parent = pParent;
        this.frameWidth = _width;
        this.frameHeight = _height;
        this.photoWidth = this.frameWidth;
        this.photoHeight = this.frameHeight;
        this.cameraFPS = _framesPerSecond;
        this.isStarted = false;
        this.requestedStart = false;
        this.myPixels = new int[_width * _height];
        this.self = this;
        this.isRGBPreviewSupported = false;
        this.enableFlash = false;
        this.cameraID = 0;
        try {
            this.onPreviewEventMethod = this.parent.getClass().getMethod("onCameraPreviewEvent", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            this.onPreviewEventMethod = null;
        }
        try {
            this.onPreviewEventMethodPImage = this.parent.getClass().getMethod("onCameraPreviewEvent", KetaiCamera.class);
        }
        catch (NoSuchMethodException e) {
            this.onPreviewEventMethodPImage = null;
        }
        try {
            this.onFaceDetectionEventMethod = this.parent.getClass().getMethod("onFaceDetectionEvent", KetaiFace[].class);
        }
        catch (NoSuchMethodException e) {
            this.onFaceDetectionEventMethod = null;
        }
        try {
            this.onSavePhotoEventMethod = this.parent.getClass().getMethod("onSavePhotoEvent", String.class);
        }
        catch (NoSuchMethodException e) {
            this.onSavePhotoEventMethod = null;
        }
        PackageManager pm = this.parent.getApplicationContext().getPackageManager();
        try {
            ai = pm.getApplicationInfo(this.parent.getApplicationContext().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        this.SAVE_DIR = ai != null ? pm.getApplicationLabel(ai) : "unknownApp";
        this.parent.registerMethod("resume", (Object)this);
        this.parent.registerMethod("pause", (Object)this);
        this.parent.registerMethod("dispose", (Object)this);
    }

    public void manualSettings() {
        if (this.camera == null) {
            return;
        }
        Camera.Parameters cameraParameters = this.camera.getParameters();
        if (cameraParameters.isAutoExposureLockSupported()) {
            cameraParameters.setAutoExposureLock(true);
        }
        if (cameraParameters.isAutoWhiteBalanceLockSupported()) {
            cameraParameters.setAutoWhiteBalanceLock(true);
        } else {
            List w = cameraParameters.getSupportedWhiteBalance();
            for (String s : w) {
                if (!s.equalsIgnoreCase("cloudy-daylight")) continue;
                cameraParameters.setWhiteBalance(s);
                break;
            }
        }
        List fModes = cameraParameters.getSupportedFocusModes();
        for (String s : fModes) {
            if (!s.equalsIgnoreCase("fixed")) continue;
            cameraParameters.setFocusMode("fixed");
        }
        try {
            this.camera.setParameters(cameraParameters);
        }
        catch (RuntimeException x) {
            PApplet.println((String)("Failed to set parameters to manual." + x.getMessage()));
        }
    }

    public void setZoom(int _zoom) {
        if (this.camera == null) {
            return;
        }
        Camera.Parameters cameraParameters = this.camera.getParameters();
        if (_zoom > cameraParameters.getMaxZoom()) {
            _zoom = cameraParameters.getMaxZoom();
        } else if (_zoom < 0) {
            _zoom = 0;
        }
        cameraParameters.setZoom(_zoom);
        this.camera.setParameters(cameraParameters);
    }

    public int getZoom() {
        if (this.camera == null) {
            return 0;
        }
        Camera.Parameters p = this.camera.getParameters();
        return p.getZoom();
    }

    public void autoSettings() {
        if (this.camera == null) {
            return;
        }
        Camera.Parameters cameraParameters = this.camera.getParameters();
        if (cameraParameters.isAutoExposureLockSupported()) {
            cameraParameters.setAutoExposureLock(false);
        }
        if (cameraParameters.isAutoWhiteBalanceLockSupported()) {
            cameraParameters.setAutoWhiteBalanceLock(false);
        }
        List fModes = cameraParameters.getSupportedFocusModes();
        for (String s : fModes) {
            if (!s.equalsIgnoreCase("continuous-picture")) continue;
            cameraParameters.setFocusMode("continuous-picture");
        }
        this.camera.setParameters(cameraParameters);
        this.camera.autoFocus(this.autofocusCB);
    }

    public String dump() {
        String result = "";
        if (this.camera == null) {
            return result;
        }
        Camera.Parameters p = this.camera.getParameters();
        result = String.valueOf(result) + "Zoom: " + p.getZoom() + "\n";
        result = String.valueOf(result) + "White Balance: " + p.getWhiteBalance() + "\n";
        result = p.isAutoWhiteBalanceLockSupported() ? String.valueOf(result) + "\t Lock supported, state: " + p.getAutoWhiteBalanceLock() + "\n" : String.valueOf(result) + "\t Lock NOT supported\n";
        float[] f = new float[3];
        String fd = "";
        p.getFocusDistances(f);
        int i = 0;
        while (i < f.length) {
            fd = String.valueOf(fd) + String.valueOf(f[i]) + " ";
            ++i;
        }
        result = String.valueOf(result) + "Focal Distances: " + fd + " \n";
        result = String.valueOf(result) + "Focal Depth: " + p.getFocalLength() + "\n";
        result = String.valueOf(result) + "Focus Mode: " + p.getFocusMode() + "\n";
        result = String.valueOf(result) + "Exposure: " + p.getExposureCompensation() + "\n";
        result = p.isAutoExposureLockSupported() ? String.valueOf(result) + "\t Lock supported, state: " + p.getAutoExposureLock() + "\n" : String.valueOf(result) + "\t Lock NOT supported\n";
        result = String.valueOf(result) + "Native camera face detection support: " + this.supportsFaceDetection;
        return result;
    }

    public void setSaveDirectory(String _dirname) {
        this.SAVE_DIR = _dirname;
    }

    public int getPhotoWidth() {
        return this.photoWidth;
    }

    public int getPhotoHeight() {
        return this.photoHeight;
    }

    public void setPhotoSize(int width, int height) {
        this.photoWidth = width;
        this.photoHeight = height;
        this.determineCameraParameters();
    }

    public void enableFlash() {
        this.enableFlash = true;
        if (this.camera == null) {
            return;
        }
        Camera.Parameters cameraParameters = this.camera.getParameters();
        cameraParameters.setFlashMode("torch");
        try {
            this.camera.setParameters(cameraParameters);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void disableFlash() {
        this.enableFlash = false;
        if (this.camera == null) {
            return;
        }
        Camera.Parameters cameraParameters = this.camera.getParameters();
        cameraParameters.setFlashMode("off");
        try {
            this.camera.setParameters(cameraParameters);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void setCameraID(int _id) {
        if (_id < Camera.getNumberOfCameras()) {
            this.cameraID = _id;
        }
    }

    public int getCameraID() {
        return this.cameraID;
    }

    public boolean start() {
        block25: {
            this.requestedStart = true;
            if (this.isStarted) {
                return true;
            }
            if (this.camera != null) break block25;
            try {
                this.camera = Camera.open((int)this.cameraID);
            }
            catch (Exception x) {
                PApplet.println((String)("Failed to open camera for camera ID: " + this.cameraID + ":" + x.getMessage()));
                return false;
            }
        }
        try {
            int result;
            Camera.Parameters cameraParameters = this.camera.getParameters();
            List list = cameraParameters.getSupportedPreviewFormats();
            for (Integer i : list) {
                if (i == 4) {
                    this.isRGBPreviewSupported = true;
                }
                PApplet.println((String)("\t" + i));
            }
            if (this.isRGBPreviewSupported) {
                cameraParameters.setPreviewFormat(4);
            }
            PApplet.println((String)("default imageformat:" + cameraParameters.getPreviewFormat()));
            List flashmodes = cameraParameters.getSupportedFlashModes();
            if (flashmodes != null && flashmodes.size() > 0) {
                for (String s : flashmodes) {
                    PApplet.println((String)("supported flashmode: " + s));
                }
                if (this.enableFlash) {
                    cameraParameters.setFlashMode("torch");
                } else {
                    cameraParameters.setFlashMode("off");
                }
            } else {
                PApplet.println((String)"No flash support.");
            }
            int rotation = this.parent.getWindowManager().getDefaultDisplay().getRotation();
            int degrees = 0;
            switch (rotation) {
                case 0: {
                    degrees = 0;
                    break;
                }
                case 1: {
                    degrees = 90;
                    break;
                }
                case 2: {
                    degrees = 180;
                    break;
                }
                case 3: {
                    degrees = 270;
                }
            }
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.cameraID, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                result = (info.orientation + degrees) % 360;
                result = (360 - result) % 360;
            } else {
                result = (info.orientation - degrees + 360) % 360;
            }
            this.camera.setDisplayOrientation(result);
            this.camera.setParameters(cameraParameters);
            this.camera.setPreviewCallback(this.previewcallback);
            this.determineCameraParameters();
            try {
                this.parent.runOnUiThread(new Runnable(){

                    public void run() {
                        int[] textures = new int[1];
                        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
                        GLES20.glBindTexture((int)3553, (int)textures[0]);
                        int texture_id = textures[0];
                        KetaiCamera.this.mTexture = new SurfaceTexture(texture_id);
                        try {
                            KetaiCamera.this.camera.setPreviewTexture(KetaiCamera.this.mTexture);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                this.camera.startPreview();
            }
            catch (NoClassDefFoundError x) {
                this.camera.startPreview();
            }
            this.isStarted = true;
            PApplet.println((String)("Using preview format: " + this.camera.getParameters().getPreviewFormat()));
            PApplet.println((String)("Preview size: " + this.frameWidth + "x" + this.frameHeight + "," + this.cameraFPS));
            PApplet.println((String)("Photo size: " + this.photoWidth + "x" + this.photoHeight));
            return true;
        }
        catch (RuntimeException x) {
            x.printStackTrace();
            if (this.camera != null) {
                this.camera.release();
            }
            PApplet.println((String)"Exception caught while trying to connect to camera service.  Please check your sketch permissions or that another application is not using the camera.");
            return false;
        }
    }

    public boolean isFlashEnabled() {
        return this.enableFlash;
    }

    public boolean savePhoto() {
        if (this.camera != null && this.isStarted()) {
            this.savePhotoPath = "";
            return this.savePhoto(this.savePhotoPath);
        }
        return false;
    }

    public boolean savePhoto(String _filename) {
        String filename = "";
        if (_filename.startsWith(File.separator)) {
            this.savePhotoPath = _filename;
        } else {
            if (_filename.equalsIgnoreCase("")) {
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                filename = "IMG_" + timeStamp + ".jpg";
            } else {
                filename = _filename;
            }
            File mediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), this.SAVE_DIR);
            if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
                PApplet.println((String)("failed to create directory to save photo: " + mediaStorageDir.getAbsolutePath()));
                return false;
            }
            this.savePhotoPath = String.valueOf(mediaStorageDir.getAbsolutePath()) + File.separator + filename;
        }
        PApplet.println((String)("Calculated photo path: " + this.savePhotoPath));
        try {
            FileOutputStream outStream = new FileOutputStream(this.savePhotoPath);
            outStream.write(1);
            outStream.close();
            File f = new File(this.savePhotoPath);
            if (!f.delete()) {
                PApplet.println((String)"Failed to remove temp photoFile while testing permissions..oops");
            }
        }
        catch (FileNotFoundException x) {
            PApplet.println((String)("Failed to save photo to " + this.savePhotoPath + "\n" + x.getMessage()));
            return false;
        }
        catch (IOException e) {
            PApplet.println((String)("Failed to save photo to " + this.savePhotoPath + "\n" + e.getMessage()));
            return false;
        }
        if (this.camera != null && this.isStarted()) {
            this.camera.takePicture(null, null, this.jpegCallback);
        }
        return true;
    }

    public void resume() {
        this.camera = Camera.open((int)this.cameraID);
        if (!this.isStarted && this.requestedStart) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read() {
        if (this.pixels.length != this.frameWidth * this.frameHeight) {
            this.pixels = new int[this.frameWidth * this.frameHeight];
        }
        int[] nArray = this.pixels;
        synchronized (this.pixels) {
            System.arraycopy(this.myPixels, 0, this.pixels, 0, this.frameWidth * this.frameHeight);
            this.available = false;
            this.updatePixels();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void addToMediaLibrary(String _file) {
        String[] paths = new String[]{_file};
        MediaScannerConnection.scanFile((Context)this.parent.getApplicationContext(), (String[])paths, null, (MediaScannerConnection.OnScanCompletedListener)this.myScannerCallback);
    }

    public void pause() {
        if (this.camera != null && this.isStarted) {
            this.isStarted = false;
            this.camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.release();
            this.camera = null;
        }
        this.isStarted = false;
    }

    public void stop() {
        PApplet.println((String)"Stopping Camera...");
        this.requestedStart = false;
        if (this.camera != null && this.isStarted) {
            this.isStarted = false;
            this.camera.stopPreview();
            this.camera.setPreviewCallback(null);
            this.camera.release();
            this.camera = null;
        }
    }

    public void dispose() {
        this.stop();
    }

    public void decodeYUV420SP(byte[] yuv420sp) {
        int frameSize = this.width * this.height;
        int j = 0;
        int yp = 0;
        while (j < this.height) {
            int uvp = frameSize + (j >> 1) * this.width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < this.width) {
                int y = (0xFF & yuv420sp[yp]) - 16;
                if (y < 0) {
                    y = 0;
                }
                if ((i & 1) == 0) {
                    v = (0xFF & yuv420sp[uvp++]) - 128;
                    u = (0xFF & yuv420sp[uvp++]) - 128;
                }
                int y1192 = 1192 * y;
                int r = y1192 + 1634 * v;
                int g = y1192 - 833 * v - 400 * u;
                int b = y1192 + 2066 * u;
                if (r < 0) {
                    r = 0;
                } else if (r > 262143) {
                    r = 262143;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 262143) {
                    g = 262143;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 262143) {
                    b = 262143;
                }
                this.myPixels[yp] = 0xFF000000 | r << 6 & 0xFF0000 | g >> 2 & 0xFF00 | b >> 10 & 0xFF;
                ++i;
                ++yp;
            }
            ++j;
        }
    }

    public int getNumberOfCameras() {
        return Camera.getNumberOfCameras();
    }

    public Collection<? extends String> list() {
        Vector<String> list = new Vector<String>();
        String facing = "";
        int count = Camera.getNumberOfCameras();
        int i = 0;
        while (i < count) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            facing = info.facing == 0 ? "backfacing" : "frontfacing";
            list.add("camera id [" + i + "] facing:" + facing);
            PApplet.println((String)("camera id[" + i + "] facing:" + facing));
            ++i;
        }
        return list;
    }

    private void determineCameraParameters() {
        if (this.camera == null) {
            return;
        }
        PApplet.println((String)("Requested camera parameters as (w,h,fps):" + this.frameWidth + "," + this.frameHeight + "," + this.cameraFPS));
        Camera.Parameters cameraParameters = this.camera.getParameters();
        List supportedSizes = cameraParameters.getSupportedPreviewSizes();
        boolean foundSupportedSize = false;
        Camera.Size nearestRequestedSize = null;
        for (Camera.Size s : supportedSizes) {
            PApplet.println((String)("Checking supported preview size:" + s.width + "," + s.height));
            if (nearestRequestedSize == null) {
                nearestRequestedSize = s;
            }
            if (foundSupportedSize) continue;
            if (s.width == this.frameWidth && s.height == this.frameHeight) {
                PApplet.println((String)"Found matching camera size");
                nearestRequestedSize = s;
                foundSupportedSize = true;
                continue;
            }
            int delta = this.frameWidth * this.frameHeight - nearestRequestedSize.height * nearestRequestedSize.width;
            int current = this.frameWidth * this.frameHeight - s.height * s.width;
            delta = Math.abs(delta);
            if ((current = Math.abs(current)) >= delta) continue;
            nearestRequestedSize = s;
        }
        if (nearestRequestedSize != null) {
            this.frameWidth = nearestRequestedSize.width;
            this.frameHeight = nearestRequestedSize.height;
        }
        cameraParameters.setPreviewSize(this.frameWidth, this.frameHeight);
        supportedSizes = cameraParameters.getSupportedPictureSizes();
        foundSupportedSize = false;
        nearestRequestedSize = null;
        for (Camera.Size s : supportedSizes) {
            if (foundSupportedSize) continue;
            if (s.width == this.photoWidth && s.height == this.photoHeight) {
                nearestRequestedSize = s;
                foundSupportedSize = true;
                continue;
            }
            if (this.photoWidth > s.width) continue;
            nearestRequestedSize = s;
        }
        if (nearestRequestedSize != null) {
            this.photoWidth = nearestRequestedSize.width;
            this.photoHeight = nearestRequestedSize.height;
        }
        cameraParameters.setPictureSize(this.photoWidth, this.photoHeight);
        List supportedFPS = cameraParameters.getSupportedPreviewFrameRates();
        int nearestFPS = 0;
        Iterator iterator = supportedFPS.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)iterator.next();
            PApplet.println((String)("Supported preview FPS: " + r));
            if (nearestFPS == 0) {
                nearestFPS = r;
            }
            if (Math.abs(this.cameraFPS - r) <= Math.abs(this.cameraFPS - nearestFPS)) continue;
            nearestFPS = r;
        }
        PApplet.println((String)("calculated preview FPS: " + nearestFPS));
        cameraParameters.setPreviewFrameRate(nearestFPS);
        this.camera.setParameters(cameraParameters);
        cameraParameters = this.camera.getParameters();
        this.frameHeight = cameraParameters.getPreviewSize().height;
        this.frameWidth = cameraParameters.getPreviewSize().width;
        if (this.cameraFPS == cameraParameters.getPreviewFrameRate()) {
            this.cameraFPS = cameraParameters.getPreviewFrameRate();
        }
        PApplet.println((String)("Calculated camera parameters as (w,h,fps):" + this.frameWidth + "," + this.frameHeight + "," + this.cameraFPS));
        if (cameraParameters.getMaxNumDetectedFaces() > 0) {
            PApplet.println((String)"Face detection supported!");
            this.supportsFaceDetection = true;
        }
        this.loadPixels();
        this.resize(this.frameWidth, this.frameHeight);
    }

    public void onFrameAvailable(SurfaceTexture arg0) {
        PApplet.print((String)".");
    }
}

