/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ConfigurationInfo;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.os.Handler;
import android.text.format.Time;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphicsAndroid2D;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PStyle;
import processing.data.Table;
import processing.data.XML;
import processing.event.Event;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.event.TouchEvent;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShader;

public class PApplet
extends Activity
implements PConstants,
Runnable {
    public PGraphics g;
    public static final boolean DEBUG = false;
    public int displayWidth;
    public int displayHeight;
    public String sketchPath;
    protected boolean surfaceReady;
    protected boolean surfaceChanged;
    public int[] pixels;
    public int width;
    public int height;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    protected int dmouseX;
    protected int dmouseY;
    protected int emouseX;
    protected int emouseY;
    public boolean mousePressed;
    Handler handler;
    public char key;
    public int keyCode;
    public boolean keyPressed;
    public boolean focused = false;
    protected boolean windowFocused = false;
    protected boolean viewFocused = false;
    long millisOffset = System.currentTimeMillis();
    public float frameRate = 10.0f;
    protected long frameRateLastNanos = 0L;
    protected float frameRateTarget = 60.0f;
    protected long frameRatePeriod = 16666666L;
    protected boolean looping;
    protected boolean redraw;
    public int frameCount;
    public boolean finished;
    protected boolean paused;
    protected SurfaceView surfaceView;
    protected boolean exitCalled;
    Thread thread;
    public static final String ARGS_EDITOR_LOCATION = "--editor-location";
    public static final String ARGS_EXTERNAL = "--external";
    public static final String ARGS_LOCATION = "--location";
    public static final String ARGS_DISPLAY = "--display";
    public static final String ARGS_BGCOLOR = "--bgcolor";
    public static final String ARGS_PRESENT = "--present";
    public static final String ARGS_EXCLUSIVE = "--exclusive";
    public static final String ARGS_STOP_COLOR = "--stop-color";
    public static final String ARGS_HIDE_STOP = "--hide-stop";
    public static final String ARGS_SKETCH_FOLDER = "--sketch-path";
    public static final String EXTERNAL_STOP = "__STOP__";
    public static final String EXTERNAL_MOVE = "__MOVE__";
    boolean external = false;
    static final String ERROR_MIN_MAX = "Cannot use min() or max() on an empty array.";
    HashMap<String, RegisteredMethods> registerMap = new HashMap();
    InternalEventQueue eventQueue = new InternalEventQueue();
    static final int META_CTRL_ON = 4096;
    static final int META_META_ON = 65536;
    int motionPointerId;
    protected static Time time = new Time();
    Random internalRandom;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    int perlin_octaves = 4;
    float perlin_amp_falloff = 0.5f;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;
    public int requestImageMax = 4;
    volatile int requestImageCount;
    protected static HashMap<String, Pattern> matchPatterns;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static boolean float_nf_commas;
    public static final byte[] ICON_IMAGE;

    public void onCreate(Bundle bundle) {
        RelativeLayout relativeLayout;
        super.onCreate(bundle);
        Window window = this.getWindow();
        this.requestWindowFeature(1);
        window.setFlags(256, 256);
        window.setFlags(1024, 1024);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        this.displayWidth = displayMetrics.widthPixels;
        this.displayHeight = displayMetrics.heightPixels;
        int n = this.sketchWidth();
        int n2 = this.sketchHeight();
        if (this.sketchRenderer().equals("processing.core.PGraphicsAndroid2D")) {
            this.surfaceView = new SketchSurfaceView((Context)this, n, n2);
        } else if (this.sketchRenderer().equals("processing.opengl.PGraphics2D") || this.sketchRenderer().equals("processing.opengl.PGraphics3D")) {
            this.surfaceView = new SketchSurfaceViewGL((Context)this, n, n2, this.sketchRenderer().equals("processing.opengl.PGraphics3D"));
        }
        if (n == this.displayWidth && n2 == this.displayHeight) {
            window.setContentView((View)this.surfaceView);
        } else {
            relativeLayout = new RelativeLayout((Context)this);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            LinearLayout linearLayout = new LinearLayout((Context)this);
            linearLayout.addView((View)this.surfaceView, this.sketchWidth(), this.sketchHeight());
            relativeLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
            window.setContentView((View)relativeLayout);
        }
        this.finished = false;
        this.looping = true;
        this.redraw = true;
        relativeLayout = this.getApplicationContext();
        this.sketchPath = relativeLayout.getFilesDir().getAbsolutePath();
        this.handler = new Handler();
        this.start();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    protected void onResume() {
        super.onResume();
        this.paused = false;
        this.handleMethods("resume");
        this.resume();
    }

    protected void onPause() {
        super.onPause();
        this.paused = true;
        this.handleMethods("pause");
        this.pause();
    }

    public void pause() {
    }

    public void resume() {
    }

    public void onDestroy() {
        this.dispose();
        super.onDestroy();
    }

    public SurfaceHolder getSurfaceHolder() {
        return this.surfaceView.getHolder();
    }

    public SurfaceView getSurfaceView() {
        return this.surfaceView;
    }

    public void surfaceWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        this.focused = bl;
        if (this.focused) {
            this.focusGained();
        } else {
            this.focusLost();
        }
    }

    public boolean surfaceTouchEvent(MotionEvent motionEvent) {
        this.nativeMotionEvent(motionEvent);
        return true;
    }

    public boolean surfaceKeyDown(int n, android.view.KeyEvent keyEvent) {
        this.nativeKeyEvent(keyEvent);
        return super.onKeyDown(n, keyEvent);
    }

    public boolean surfaceKeyUp(int n, android.view.KeyEvent keyEvent) {
        this.nativeKeyEvent(keyEvent);
        return super.onKeyUp(n, keyEvent);
    }

    public int sketchQuality() {
        return 1;
    }

    public int sketchWidth() {
        return this.displayWidth;
    }

    public int sketchHeight() {
        return this.displayHeight;
    }

    public String sketchRenderer() {
        return "processing.core.PGraphicsAndroid2D";
    }

    public void orientation(int n) {
        if (n == 1) {
            this.setRequestedOrientation(1);
        } else if (n == 2) {
            this.setRequestedOrientation(0);
        }
    }

    public void start() {
        this.finished = false;
        this.paused = false;
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Animation Thread");
            this.thread.start();
        }
    }

    public void stop() {
        this.paused = true;
    }

    public void destroy() {
        this.exit();
    }

    public void registerMethod(String string, Object object) {
        if (string.equals("mouseEvent")) {
            this.registerWithArgs("mouseEvent", object, new Class[]{MouseEvent.class});
        } else if (string.equals("keyEvent")) {
            this.registerWithArgs("keyEvent", object, new Class[]{KeyEvent.class});
        } else if (string.equals("touchEvent")) {
            this.registerWithArgs("touchEvent", object, new Class[]{TouchEvent.class});
        } else {
            this.registerNoArgs(string, object);
        }
    }

    private void registerNoArgs(String string, Object object) {
        RegisteredMethods registeredMethods = this.registerMap.get(string);
        if (registeredMethods == null) {
            registeredMethods = new RegisteredMethods();
            this.registerMap.put(string, registeredMethods);
        }
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            registeredMethods.add(object, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.die("There is no public " + string + "() method in the class " + object.getClass().getName());
        }
        catch (Exception exception) {
            this.die("Could not register " + string + " + () for " + object, exception);
        }
    }

    private void registerWithArgs(String string, Object object, Class<?>[] classArray) {
        RegisteredMethods registeredMethods = this.registerMap.get(string);
        if (registeredMethods == null) {
            registeredMethods = new RegisteredMethods();
            this.registerMap.put(string, registeredMethods);
        }
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod(string, classArray);
            registeredMethods.add(object, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.die("There is no public " + string + "() method in the class " + object.getClass().getName());
        }
        catch (Exception exception) {
            this.die("Could not register " + string + " + () for " + object, exception);
        }
    }

    public void unregisterMethod(String string, Object object) {
        RegisteredMethods registeredMethods = this.registerMap.get(string);
        if (registeredMethods == null) {
            this.die("No registered methods with the name " + string + "() were found.");
        }
        try {
            registeredMethods.remove(object);
        }
        catch (Exception exception) {
            this.die("Could not unregister " + string + "() for " + object, exception);
        }
    }

    protected void handleMethods(String string) {
        RegisteredMethods registeredMethods = this.registerMap.get(string);
        if (registeredMethods != null) {
            registeredMethods.handle();
        }
    }

    protected void handleMethods(String string, Object[] objectArray) {
        RegisteredMethods registeredMethods = this.registerMap.get(string);
        if (registeredMethods != null) {
            registeredMethods.handle(objectArray);
        }
    }

    @Deprecated
    public void registerSize(Object object) {
        System.err.println("The registerSize() command is no longer supported.");
    }

    @Deprecated
    public void registerPre(Object object) {
        this.registerNoArgs("pre", object);
    }

    @Deprecated
    public void registerDraw(Object object) {
        this.registerNoArgs("draw", object);
    }

    @Deprecated
    public void registerPost(Object object) {
        this.registerNoArgs("post", object);
    }

    @Deprecated
    public void registerDispose(Object object) {
        this.registerNoArgs("dispose", object);
    }

    @Deprecated
    public void unregisterSize(Object object) {
        System.err.println("The unregisterSize() command is no longer supported.");
    }

    @Deprecated
    public void unregisterPre(Object object) {
        this.unregisterMethod("pre", object);
    }

    @Deprecated
    public void unregisterDraw(Object object) {
        this.unregisterMethod("draw", object);
    }

    @Deprecated
    public void unregisterPost(Object object) {
        this.unregisterMethod("post", object);
    }

    @Deprecated
    public void unregisterDispose(Object object) {
        this.unregisterMethod("dispose", object);
    }

    public void setup() {
    }

    public void draw() {
        this.finished = true;
    }

    public void size(int n, int n2) {
        this.size(n, n2, "processing.opengl.PGraphics2D", null);
    }

    public void size(int n, int n2, String string) {
        this.size(n, n2, string, null);
    }

    public void size(int n, int n2, String string, String string2) {
        System.out.println("This size() method is ignored on Android.");
        System.out.println("See http://wiki.processing.org/w/Android for more information.");
    }

    public PGraphics createGraphics(int n, int n2) {
        return this.createGraphics(n, n2, "processing.core.PGraphicsAndroid2D");
    }

    public PGraphics createGraphics(int n, int n2, String string) {
        PGraphics pGraphics = null;
        if (string.equals("processing.core.PGraphicsAndroid2D")) {
            pGraphics = new PGraphicsAndroid2D();
        } else if (string.equals("processing.opengl.PGraphics2D")) {
            if (!this.g.isGL()) {
                throw new RuntimeException("createGraphics() with P2D requires size() to use P2D or P3D");
            }
            pGraphics = new PGraphics2D();
        } else if (string.equals("processing.opengl.PGraphics3D")) {
            if (!this.g.isGL()) {
                throw new RuntimeException("createGraphics() with P3D or OPENGL requires size() to use P2D or P3D");
            }
            pGraphics = new PGraphics3D();
        } else {
            Class<?> clazz = null;
            Constructor<?> constructor = null;
            try {
                clazz = this.getClass().getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Missing renderer class");
            }
            if (clazz != null) {
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("Missing renderer constructor");
                }
                if (constructor != null) {
                    try {
                        pGraphics = (PGraphics)constructor.newInstance(new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                        throw new RuntimeException(invocationTargetException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        throw new RuntimeException(illegalAccessException.getMessage());
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                        throw new RuntimeException(instantiationException.getMessage());
                    }
                }
            }
        }
        pGraphics.setParent(this);
        pGraphics.setPrimary(false);
        ((PGraphics)pGraphics).setSize(n, n2);
        return pGraphics;
    }

    public PImage createImage(int n, int n2, int n3) {
        PImage pImage = new PImage(n, n2, n3);
        pImage.parent = this;
        return pImage;
    }

    @Override
    public void run() {
        long l = System.nanoTime();
        long l2 = 0L;
        int n = 0;
        while (Thread.currentThread() == this.thread && !this.finished) {
            long l3;
            long l4;
            long l5;
            while (this.paused) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.g != null) {
                this.g.requestDraw();
            }
            if ((l5 = this.frameRatePeriod - (l4 = (l3 = System.nanoTime()) - l) - l2) > 0L) {
                try {
                    Thread.sleep(l5 / 1000000L, (int)(l5 % 1000000L));
                    n = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.nanoTime() - l3 - l5;
            } else {
                l2 = 0L;
                if (n > 15) {
                    Thread.yield();
                    n = 0;
                }
            }
            l = System.nanoTime();
        }
        if (!this.paused) {
            this.stop();
            if (this.exitCalled) {
                this.exit2();
            }
        }
    }

    public void handleDraw() {
        if (this.surfaceChanged) {
            int n = this.surfaceView.getWidth();
            int n2 = this.surfaceView.getHeight();
            if (n != this.width || n2 != this.height) {
                this.width = n;
                this.height = n2;
                this.g.setSize(this.width, this.height);
            }
            this.surfaceChanged = false;
            this.surfaceReady = true;
        }
        if (this.canDraw()) {
            this.g.beginDraw();
            long l = System.nanoTime();
            if (this.frameCount == 0) {
                try {
                    this.setup();
                }
                catch (RendererChangeException rendererChangeException) {
                    return;
                }
            } else {
                double d = 1000000.0 / ((double)(l - this.frameRateLastNanos) / 1000000.0);
                float f = (float)d / 1000.0f;
                this.frameRate = this.frameRate * 0.9f + f * 0.1f;
                if (this.frameCount != 0) {
                    this.handleMethods("pre");
                }
                this.pmouseX = this.dmouseX;
                this.pmouseY = this.dmouseY;
                this.draw();
                this.dmouseX = this.mouseX;
                this.dmouseY = this.mouseY;
                this.dequeueEvents();
                this.handleMethods("draw");
                this.redraw = false;
            }
            this.g.endDraw();
            if (this.frameCount != 0) {
                this.handleMethods("post");
            }
            this.frameRateLastNanos = l;
            ++this.frameCount;
        }
    }

    public boolean canDraw() {
        return this.g != null && this.surfaceReady && !this.paused && (this.looping || this.redraw);
    }

    public synchronized void redraw() {
        if (!this.looping) {
            this.redraw = true;
        }
    }

    public synchronized void loop() {
        if (!this.looping) {
            this.looping = true;
        }
    }

    public synchronized void noLoop() {
        if (this.looping) {
            this.looping = false;
        }
    }

    public void postEvent(Event event) {
        this.eventQueue.add(event);
        if (!this.looping) {
            this.dequeueEvents();
        }
    }

    protected void dequeueEvents() {
        while (this.eventQueue.available()) {
            Event event = this.eventQueue.remove();
            switch (event.getFlavor()) {
                case 2: {
                    this.handleMouseEvent((MouseEvent)event);
                    break;
                }
                case 1: {
                    this.handleKeyEvent((KeyEvent)event);
                }
            }
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getAction() == 4 || mouseEvent.getAction() == 5) {
            this.pmouseX = this.emouseX;
            this.pmouseY = this.emouseY;
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
        }
        if (mouseEvent.getAction() == 1) {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
        }
        switch (mouseEvent.getAction()) {
            case 1: {
                this.mousePressed = true;
                break;
            }
            case 2: {
                this.mousePressed = false;
            }
        }
        this.handleMethods("mouseEvent", new Object[]{mouseEvent});
        switch (mouseEvent.getAction()) {
            case 1: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 2: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 3: {
                this.mouseClicked(mouseEvent);
                break;
            }
            case 4: {
                this.mouseDragged(mouseEvent);
                break;
            }
            case 5: {
                this.mouseMoved(mouseEvent);
                break;
            }
            case 6: {
                this.mouseEntered(mouseEvent);
                break;
            }
            case 7: {
                this.mouseExited(mouseEvent);
            }
        }
        if (mouseEvent.getAction() == 4 || mouseEvent.getAction() == 5) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
        if (mouseEvent.getAction() == 1) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
    }

    protected void nativeMotionEvent(MotionEvent motionEvent) {
        int n = motionEvent.getMetaState();
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 2;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 8;
        }
        int n3 = 1;
        switch (motionEvent.getAction()) {
            case 0: {
                this.motionPointerId = motionEvent.getPointerId(0);
                this.postEvent(new MouseEvent(motionEvent, motionEvent.getEventTime(), 1, n2, (int)motionEvent.getX(), (int)motionEvent.getY(), 21, n3));
                break;
            }
            case 2: {
                int n4 = motionEvent.findPointerIndex(this.motionPointerId);
                if (n4 == -1) break;
                this.postEvent(new MouseEvent(motionEvent, motionEvent.getEventTime(), 4, n2, (int)motionEvent.getX(n4), (int)motionEvent.getY(n4), 21, n3));
                break;
            }
            case 1: {
                int n5 = motionEvent.findPointerIndex(this.motionPointerId);
                if (n5 == -1) break;
                this.postEvent(new MouseEvent(motionEvent, motionEvent.getEventTime(), 2, n2, (int)motionEvent.getX(n5), (int)motionEvent.getY(n5), 21, n3));
            }
        }
    }

    public void mousePressed() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed();
    }

    public void mouseReleased() {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseReleased();
    }

    public void mouseClicked() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClicked();
    }

    public void mouseDragged() {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragged();
    }

    public void mouseMoved() {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseMoved();
    }

    public void mouseEntered() {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered();
    }

    public void mouseExited() {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseExited();
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        this.key = keyEvent.getKey();
        this.keyCode = keyEvent.getKeyCode();
        switch (keyEvent.getAction()) {
            case 1: {
                this.keyPressed = true;
                this.keyPressed(keyEvent);
                break;
            }
            case 2: {
                this.keyPressed = false;
                this.keyReleased(keyEvent);
            }
        }
        this.handleMethods("keyEvent", new Object[]{keyEvent});
        if (keyEvent.getAction() == 1 && keyEvent.getKeyCode() == 4) {
            this.exit();
        }
    }

    protected void nativeKeyEvent(android.view.KeyEvent keyEvent) {
        char c = (char)keyEvent.getUnicodeChar();
        if (c == '\u0000' || c == '\uffff') {
            c = '\uffff';
        }
        int n = keyEvent.getKeyCode();
        int n2 = 0;
        int n3 = keyEvent.getAction();
        if (n3 == 0) {
            n2 = 1;
        } else if (n3 == 1) {
            n2 = 2;
        }
        int n4 = 0;
        KeyEvent keyEvent2 = new KeyEvent(keyEvent, keyEvent.getEventTime(), n2, n4, c, n);
        if (n3 == 0 && n == 4) {
            this.exit();
        }
        this.postEvent(keyEvent2);
    }

    public void keyPressed() {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyPressed();
    }

    public void keyReleased() {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyReleased();
    }

    public void keyTyped() {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.keyTyped();
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public int millis() {
        return (int)(System.currentTimeMillis() - this.millisOffset);
    }

    public static int second() {
        time.setToNow();
        return PApplet.time.second;
    }

    public static int minute() {
        time.setToNow();
        return PApplet.time.minute;
    }

    public static int hour() {
        time.setToNow();
        return PApplet.time.hour;
    }

    public static int day() {
        time.setToNow();
        return PApplet.time.monthDay;
    }

    public static int month() {
        time.setToNow();
        return PApplet.time.month + 1;
    }

    public static int year() {
        time.setToNow();
        return PApplet.time.year;
    }

    public void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void frameRate(float f) {
        this.frameRateTarget = f;
        this.frameRatePeriod = (long)(1.0E9 / (double)this.frameRateTarget);
        this.g.setFrameRate(f);
    }

    public void link(String string) {
        this.link(string, null);
    }

    public void link(String string, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        this.startActivity(intent);
    }

    public static void open(String string) {
        PApplet.open(new String[]{string});
    }

    public static Process open(String[] stringArray) {
        return PApplet.exec(stringArray);
    }

    public static Process exec(String[] stringArray) {
        try {
            return Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Could not open " + PApplet.join(stringArray, ' '));
        }
    }

    public void die(String string) {
        this.stop();
        throw new RuntimeException(string);
    }

    public void die(String string, Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        this.die(string);
    }

    public void exit() {
        if (this.thread == null) {
            this.exit2();
        } else if (this.looping) {
            this.finished = true;
            this.exitCalled = true;
        } else if (!this.looping) {
            this.dispose();
            this.exit2();
        }
    }

    void exit2() {
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public final void dispose() {
        this.finished = true;
        if (this.thread == null) {
            return;
        }
        this.thread = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.handleMethods("dispose");
    }

    public void method(String string) {
        try {
            Method method = this.getClass().getMethod(string, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("There is no public " + string + "() method " + "in the class " + this.getClass().getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void thread(final String string) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PApplet.this.method(string);
            }
        };
        thread.start();
    }

    public void save(String string) {
        this.g.save(this.savePath(string));
    }

    public void saveFrame() {
        try {
            this.g.save(this.savePath("screen-" + PApplet.nf(this.frameCount, 4) + ".tif"));
        }
        catch (SecurityException securityException) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    public void saveFrame(String string) {
        try {
            this.g.save(this.savePath(this.insertFrame(string)));
        }
        catch (SecurityException securityException) {
            System.err.println("Can't use saveFrame() when running in a browser, unless using a signed applet.");
        }
    }

    protected String insertFrame(String string) {
        int n = string.indexOf(35);
        int n2 = string.lastIndexOf(35);
        if (n != -1 && n2 - n > 0) {
            String string2 = string.substring(0, n);
            int n3 = n2 - n + 1;
            String string3 = string.substring(n2 + 1);
            return string2 + PApplet.nf(this.frameCount, n3) + string3;
        }
        return string;
    }

    public static void print(byte by) {
        System.out.print(by);
        System.out.flush();
    }

    public static void print(boolean bl) {
        System.out.print(bl);
        System.out.flush();
    }

    public static void print(char c) {
        System.out.print(c);
        System.out.flush();
    }

    public static void print(int n) {
        System.out.print(n);
        System.out.flush();
    }

    public static void print(float f) {
        System.out.print(f);
        System.out.flush();
    }

    public static void print(String string) {
        System.out.print(string);
        System.out.flush();
    }

    public static void print(Object object) {
        if (object == null) {
            System.out.print("null");
        } else {
            System.out.println(object.toString());
        }
    }

    public static void println() {
        System.out.println();
    }

    public static void println(byte by) {
        PApplet.print(by);
        System.out.println();
    }

    public static void println(boolean bl) {
        PApplet.print(bl);
        System.out.println();
    }

    public static void println(char c) {
        PApplet.print(c);
        System.out.println();
    }

    public static void println(int n) {
        PApplet.print(n);
        System.out.println();
    }

    public static void println(float f) {
        PApplet.print(f);
        System.out.println();
    }

    public static void println(String string) {
        PApplet.print(string);
        System.out.println();
    }

    public static void println(Object object) {
        block17: {
            block18: {
                block16: {
                    if (object != null) break block16;
                    System.out.println("null");
                    break block17;
                }
                String string = object.getClass().getName();
                if (string.charAt(0) != '[') break block18;
                switch (string.charAt(1)) {
                    case '[': {
                        System.out.println(object);
                        break;
                    }
                    case 'L': {
                        Object[] objectArray = (Object[])object;
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] instanceof String) {
                                System.out.println("[" + i + "] \"" + objectArray[i] + "\"");
                                continue;
                            }
                            System.out.println("[" + i + "] " + objectArray[i]);
                        }
                        break block17;
                    }
                    case 'Z': {
                        boolean[] blArray = (boolean[])object;
                        for (int i = 0; i < blArray.length; ++i) {
                            System.out.println("[" + i + "] " + blArray[i]);
                        }
                        break block17;
                    }
                    case 'B': {
                        byte[] byArray = (byte[])object;
                        for (int i = 0; i < byArray.length; ++i) {
                            System.out.println("[" + i + "] " + byArray[i]);
                        }
                        break block17;
                    }
                    case 'C': {
                        char[] cArray = (char[])object;
                        for (int i = 0; i < cArray.length; ++i) {
                            System.out.println("[" + i + "] '" + cArray[i] + "'");
                        }
                        break block17;
                    }
                    case 'I': {
                        int[] nArray = (int[])object;
                        for (int i = 0; i < nArray.length; ++i) {
                            System.out.println("[" + i + "] " + nArray[i]);
                        }
                        break block17;
                    }
                    case 'F': {
                        float[] fArray = (float[])object;
                        for (int i = 0; i < fArray.length; ++i) {
                            System.out.println("[" + i + "] " + fArray[i]);
                        }
                        break block17;
                    }
                    default: {
                        System.out.println(object);
                    }
                }
                break block17;
            }
            System.out.println(object);
        }
    }

    public static final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final float sq(float f) {
        return f * f;
    }

    public static final float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static final float log(float f) {
        return (float)Math.log(f);
    }

    public static final float exp(float f) {
        return (float)Math.exp(f);
    }

    public static final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static final int max(int n, int n2, int n3) {
        return n > n2 ? (n > n3 ? n : n3) : (n2 > n3 ? n2 : n3);
    }

    public static final float max(float f, float f2, float f3) {
        return f > f2 ? (f > f3 ? f : f3) : (f2 > f3 ? f2 : f3);
    }

    public static final int max(int[] nArray) {
        if (nArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static final float max(float[] fArray) {
        if (fArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] > f)) continue;
            f = fArray[i];
        }
        return f;
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static final int min(int n, int n2, int n3) {
        return n < n2 ? (n < n3 ? n : n3) : (n2 < n3 ? n2 : n3);
    }

    public static final float min(float f, float f2, float f3) {
        return f < f2 ? (f < f3 ? f : f3) : (f2 < f3 ? f2 : f3);
    }

    public static final int min(int[] nArray) {
        if (nArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static final float min(float[] fArray) {
        if (fArray.length == 0) {
            throw new ArrayIndexOutOfBoundsException(ERROR_MIN_MAX);
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] < f)) continue;
            f = fArray[i];
        }
        return f;
    }

    public static final int constrain(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static final float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static final float sin(float f) {
        return (float)Math.sin(f);
    }

    public static final float cos(float f) {
        return (float)Math.cos(f);
    }

    public static final float tan(float f) {
        return (float)Math.tan(f);
    }

    public static final float asin(float f) {
        return (float)Math.asin(f);
    }

    public static final float acos(float f) {
        return (float)Math.acos(f);
    }

    public static final float atan(float f) {
        return (float)Math.atan(f);
    }

    public static final float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public static final float degrees(float f) {
        return f * 57.295776f;
    }

    public static final float radians(float f) {
        return f * ((float)Math.PI / 180);
    }

    public static final int ceil(float f) {
        return (int)Math.ceil(f);
    }

    public static final int floor(float f) {
        return (int)Math.floor(f);
    }

    public static final int round(float f) {
        return Math.round(f);
    }

    public static final float mag(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static final float mag(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static final float dist(float f, float f2, float f3, float f4) {
        return PApplet.sqrt(PApplet.sq(f3 - f) + PApplet.sq(f4 - f2));
    }

    public static final float dist(float f, float f2, float f3, float f4, float f5, float f6) {
        return PApplet.sqrt(PApplet.sq(f4 - f) + PApplet.sq(f5 - f2) + PApplet.sq(f6 - f3));
    }

    public static final float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static final float norm(float f, float f2, float f3) {
        return (f - f2) / (f3 - f2);
    }

    public static final float map(float f, float f2, float f3, float f4, float f5) {
        return f4 + (f5 - f4) * ((f - f2) / (f3 - f2));
    }

    public final float random(float f) {
        if (f == 0.0f) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float f2 = 0.0f;
        while ((f2 = this.internalRandom.nextFloat() * f) == f) {
        }
        return f2;
    }

    public final float random(float f, float f2) {
        if (f >= f2) {
            return f;
        }
        float f3 = f2 - f;
        return this.random(f3) + f;
    }

    public final void randomSeed(long l) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(l);
    }

    public float noise(float f) {
        return this.noise(f, 0.0f, 0.0f);
    }

    public float noise(float f, float f2) {
        return this.noise(f, f2, 0.0f);
    }

    public float noise(float f, float f2, float f3) {
        int n;
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            for (n = 0; n < 4096; ++n) {
                this.perlin[n] = this.perlinRandom.nextFloat();
            }
            this.perlin_cosTable = PGraphics.cosLUT;
            this.perlin_PI = 720;
            this.perlin_TWOPI = 720;
            this.perlin_PI >>= 1;
        }
        if (f < 0.0f) {
            f = -f;
        }
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f3;
        float f4 = f - (float)n;
        float f5 = f2 - (float)n2;
        float f6 = f3 - (float)n3;
        float f7 = 0.0f;
        float f8 = 0.5f;
        for (int i = 0; i < this.perlin_octaves; ++i) {
            int n4 = n + (n2 << 4) + (n3 << 8);
            float f9 = this.noise_fsc(f4);
            float f10 = this.noise_fsc(f5);
            float f11 = this.perlin[n4 & 0xFFF];
            f11 += f9 * (this.perlin[n4 + 1 & 0xFFF] - f11);
            float f12 = this.perlin[n4 + 16 & 0xFFF];
            f12 += f9 * (this.perlin[n4 + 16 + 1 & 0xFFF] - f12);
            f11 += f10 * (f12 - f11);
            f12 = this.perlin[(n4 += 256) & 0xFFF];
            f12 += f9 * (this.perlin[n4 + 1 & 0xFFF] - f12);
            float f13 = this.perlin[n4 + 16 & 0xFFF];
            f13 += f9 * (this.perlin[n4 + 16 + 1 & 0xFFF] - f13);
            f12 += f10 * (f13 - f12);
            f11 += this.noise_fsc(f6) * (f12 - f11);
            f7 += f11 * f8;
            f8 *= this.perlin_amp_falloff;
            n <<= 1;
            f4 *= 2.0f;
            n2 <<= 1;
            f5 *= 2.0f;
            n3 <<= 1;
            f6 *= 2.0f;
            if (f4 >= 1.0f) {
                ++n;
                f4 -= 1.0f;
            }
            if (f5 >= 1.0f) {
                ++n2;
                f5 -= 1.0f;
            }
            if (!(f6 >= 1.0f)) continue;
            ++n3;
            f6 -= 1.0f;
        }
        return f7;
    }

    private float noise_fsc(float f) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(f * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int n) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
    }

    public void noiseDetail(int n, float f) {
        if (n > 0) {
            this.perlin_octaves = n;
        }
        if (f > 0.0f) {
            this.perlin_amp_falloff = f;
        }
    }

    public void noiseSeed(long l) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(l);
        this.perlin = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PImage loadImage(String string) {
        InputStream inputStream = this.createInput(string);
        if (inputStream == null) {
            System.err.println("Could not find the image " + string + ".");
            return null;
        }
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        finally {
            try {
                inputStream.close();
                inputStream = null;
            }
            catch (IOException iOException) {}
        }
        PImage pImage = new PImage(bitmap);
        pImage.parent = this;
        return pImage;
    }

    public PImage requestImage(String string) {
        PImage pImage = this.createImage(0, 0, 2);
        AsyncImageLoader asyncImageLoader = new AsyncImageLoader(string, pImage);
        asyncImageLoader.start();
        return pImage;
    }

    public XML createXML(String string) {
        try {
            return new XML(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public XML loadXML(String string) {
        return this.loadXML(string, null);
    }

    public XML loadXML(String string, String string2) {
        try {
            return new XML(this.createInput(string), string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public XML parseXML(String string) {
        return this.parseXML(string, null);
    }

    public XML parseXML(String string, String string2) {
        try {
            return XML.parse(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean saveXML(XML xML, String string) {
        return this.saveXML(xML, string, null);
    }

    public boolean saveXML(XML xML, String string, String string2) {
        return xML.save(this.saveFile(string), string2);
    }

    public Table createTable() {
        return new Table();
    }

    public Table loadTable(String string) {
        return this.loadTable(string, null);
    }

    public Table loadTable(String string, String string2) {
        try {
            String string3 = this.checkExtension(string);
            if (string3 != null && (string3.equals("csv") || string3.equals("tsv"))) {
                string2 = string2 == null ? string3 : string3 + "," + string2;
            }
            return new Table(this.createInput(string), string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public boolean saveTable(Table table, String string) {
        return this.saveTable(table, string, null);
    }

    public boolean saveTable(Table table, String string, String string2) {
        try {
            table.save(this.saveFile(string), string2);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected String checkExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1).toLowerCase();
    }

    public PFont loadFont(String string) {
        try {
            InputStream inputStream = this.createInput(string);
            return new PFont(inputStream);
        }
        catch (Exception exception) {
            this.die("Could not load font " + string + ". " + "Make sure that the font has been copied " + "to the data folder of your sketch.", exception);
            return null;
        }
    }

    protected PFont createDefaultFont(float f) {
        return this.createFont("SansSerif", f, true, null);
    }

    public PFont createFont(String string, float f) {
        return this.createFont(string, f, true, null);
    }

    public PFont createFont(String string, float f, boolean bl) {
        return this.createFont(string, f, bl, null);
    }

    public PFont createFont(String string, float f, boolean bl, char[] cArray) {
        String string2 = string.toLowerCase();
        Typeface typeface = null;
        if (string2.endsWith(".otf") || string2.endsWith(".ttf")) {
            AssetManager assetManager = this.getBaseContext().getAssets();
            typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)string);
        } else {
            typeface = (Typeface)PFont.findNative(string);
        }
        return new PFont(typeface, PApplet.round(f), bl, cArray);
    }

    public BufferedReader createReader(String string) {
        try {
            InputStream inputStream = this.createInput(string);
            if (inputStream == null) {
                System.err.println(string + " does not exist or could not be read");
                return null;
            }
            return PApplet.createReader(inputStream);
        }
        catch (Exception exception) {
            if (string == null) {
                System.err.println("Filename passed to reader() was null");
            } else {
                System.err.println("Couldn't create a reader for " + string);
            }
            return null;
        }
    }

    public static BufferedReader createReader(File file) {
        try {
            InputStream inputStream = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            return PApplet.createReader(inputStream);
        }
        catch (Exception exception) {
            if (file == null) {
                throw new RuntimeException("File passed to createReader() was null");
            }
            exception.printStackTrace();
            throw new RuntimeException("Couldn't create a reader for " + file.getAbsolutePath());
        }
    }

    public static BufferedReader createReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new BufferedReader(inputStreamReader);
    }

    public PrintWriter createWriter(String string) {
        return PApplet.createWriter(this.saveFile(string));
    }

    public static PrintWriter createWriter(File file) {
        try {
            OutputStream outputStream = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            return PApplet.createWriter(outputStream);
        }
        catch (Exception exception) {
            if (file == null) {
                throw new RuntimeException("File passed to createWriter() was null");
            }
            exception.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream outputStream) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 8192);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
            return new PrintWriter(outputStreamWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public InputStream createInput(String string) {
        InputStream inputStream = this.createInputRaw(string);
        if (inputStream != null && string.toLowerCase().endsWith(".gz")) {
            try {
                return new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return inputStream;
    }

    public InputStream createInputRaw(String string) {
        File file;
        InputStream inputStream = null;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.indexOf(":") != -1) {
            try {
                HttpGet httpGet = null;
                httpGet = new HttpGet(URI.create(string));
                DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                HttpEntity httpEntity = httpResponse.getEntity();
                return httpEntity.getContent();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        AssetManager assetManager = this.getAssets();
        try {
            inputStream = assetManager.open(string);
            if (inputStream != null) {
                return inputStream;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file2 = new File(string);
        if (file2.exists()) {
            try {
                inputStream = new FileInputStream(file2);
                if (inputStream != null) {
                    return inputStream;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((file = new File(this.sketchPath(string))).exists()) {
            try {
                inputStream = new FileInputStream(file);
                if (inputStream != null) {
                    return inputStream;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        Context context = this.getApplicationContext();
        try {
            inputStream = context.openFileInput(string);
            if (inputStream != null) {
                return inputStream;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream createInput(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File passed to createInput() was null");
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPInputStream(fileInputStream);
            }
            return fileInputStream;
        }
        catch (IOException iOException) {
            System.err.println("Could not createInput() for " + file);
            iOException.printStackTrace();
            return null;
        }
    }

    public byte[] loadBytes(String string) {
        InputStream inputStream = this.createInput(string);
        if (inputStream != null) {
            return PApplet.loadBytes(inputStream);
        }
        System.err.println("The file \"" + string + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static byte[] loadBytes(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = bufferedInputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = bufferedInputStream.read();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static byte[] loadBytes(File file) {
        InputStream inputStream = PApplet.createInput(file);
        return PApplet.loadBytes(inputStream);
    }

    public static String[] loadStrings(File file) {
        InputStream inputStream = PApplet.createInput(file);
        if (inputStream != null) {
            return PApplet.loadStrings(inputStream);
        }
        return null;
    }

    public String[] loadStrings(String string) {
        InputStream inputStream = this.createInput(string);
        if (inputStream != null) {
            return PApplet.loadStrings(inputStream);
        }
        System.err.println("The file \"" + string + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static String[] loadStrings(InputStream inputStream) {
        try {
            String[] stringArray;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String[] stringArray2 = new String[100];
            int n = 0;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (n == stringArray2.length) {
                    stringArray = new String[n << 1];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    stringArray2 = stringArray;
                }
                stringArray2[n++] = string;
            }
            bufferedReader.close();
            if (n == stringArray2.length) {
                return stringArray2;
            }
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            return stringArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public OutputStream createOutput(String string) {
        try {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(this.sketchPath(string));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                return new GZIPOutputStream(fileOutputStream);
            }
            return fileOutputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public boolean saveStream(String string, String string2) {
        return this.saveStream(this.saveFile(string), string2);
    }

    public boolean saveStream(File file, String string) {
        return PApplet.saveStream(file, this.createInputRaw(string));
    }

    public boolean saveStream(String string, InputStream inputStream) {
        return PApplet.saveStream(this.saveFile(string), inputStream);
    }

    public static boolean saveStream(File file, InputStream inputStream) {
        File file2 = null;
        try {
            int n;
            File file3 = file.getParentFile();
            PApplet.createPath(file);
            file2 = File.createTempFile(file.getName(), null, file3);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 16384);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedOutputStream = null;
            if (file.exists() && !file.delete()) {
                System.err.println("Could not replace " + file.getAbsolutePath() + ".");
            }
            if (!file2.renameTo(file)) {
                System.err.println("Could not rename temporary file " + file2.getAbsolutePath());
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            if (file2 != null) {
                file2.delete();
            }
            iOException.printStackTrace();
            return false;
        }
    }

    public void saveBytes(String string, byte[] byArray) {
        PApplet.saveBytes(this.saveFile(string), byArray);
    }

    public static void saveBytes(File file, byte[] byArray) {
        try {
            String string = file.getAbsolutePath();
            PApplet.createPath(string);
            OutputStream outputStream = new FileOutputStream(file);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            PApplet.saveBytes(outputStream, byArray);
            ((OutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error saving bytes to " + file);
            iOException.printStackTrace();
        }
    }

    public static void saveBytes(OutputStream outputStream, byte[] byArray) {
        try {
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveStrings(String string, String[] stringArray) {
        PApplet.saveStrings(this.saveFile(string), stringArray);
    }

    public static void saveStrings(File file, String[] stringArray) {
        try {
            String string = file.getAbsolutePath();
            PApplet.createPath(string);
            OutputStream outputStream = new FileOutputStream(string);
            if (file.getName().toLowerCase().endsWith(".gz")) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            PApplet.saveStrings(outputStream, stringArray);
            ((OutputStream)outputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void saveStrings(OutputStream outputStream, String[] stringArray) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(stringArray[i]);
            }
            printWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String sketchPath(String string) {
        if (this.sketchPath == null) {
            return string;
        }
        try {
            if (new File(string).isAbsolute()) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Context context = this.getApplicationContext();
        return context.getFileStreamPath(string).getAbsolutePath();
    }

    public File sketchFile(String string) {
        return new File(this.sketchPath(string));
    }

    public String savePath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.sketchPath(string);
        PApplet.createPath(string2);
        return string2;
    }

    public File saveFile(String string) {
        return new File(this.savePath(string));
    }

    public String dataPath(String string) {
        if (new File(string).isAbsolute()) {
            return string;
        }
        return this.sketchPath + File.separator + "data" + File.separator + string;
    }

    public File dataFile(String string) {
        return new File(this.dataPath(string));
    }

    public static void createPath(String string) {
        PApplet.createPath(new File(string));
    }

    public static void createPath(File file) {
        try {
            File file2;
            String string = file.getParent();
            if (string != null && !(file2 = new File(string)).exists()) {
                file2.mkdirs();
            }
        }
        catch (SecurityException securityException) {
            System.err.println("You don't have permissions to create " + file.getAbsolutePath());
        }
    }

    public static String getExtension(String string) {
        int n;
        String string2;
        String string3 = string.toLowerCase();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            string2 = "unknown";
        }
        if ((n = (string2 = string3.substring(n2 + 1)).indexOf(63)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] sort(byte[] byArray) {
        return PApplet.sort(byArray, byArray.length);
    }

    public static byte[] sort(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Arrays.sort(byArray2, 0, n);
        return byArray2;
    }

    public static char[] sort(char[] cArray) {
        return PApplet.sort(cArray, cArray.length);
    }

    public static char[] sort(char[] cArray, int n) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        Arrays.sort(cArray2, 0, n);
        return cArray2;
    }

    public static int[] sort(int[] nArray) {
        return PApplet.sort(nArray, nArray.length);
    }

    public static int[] sort(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray2, 0, n);
        return nArray2;
    }

    public static float[] sort(float[] fArray) {
        return PApplet.sort(fArray, fArray.length);
    }

    public static float[] sort(float[] fArray, int n) {
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        Arrays.sort(fArray2, 0, n);
        return fArray2;
    }

    public static String[] sort(String[] stringArray) {
        return PApplet.sort(stringArray, stringArray.length);
    }

    public static String[] sort(String[] stringArray, int n) {
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Arrays.sort(objectArray, 0, n);
        return objectArray;
    }

    public static void arrayCopy(Object object, int n, Object object2, int n2, int n3) {
        System.arraycopy(object, n, object2, n2, n3);
    }

    public static void arrayCopy(Object object, Object object2, int n) {
        System.arraycopy(object, 0, object2, 0, n);
    }

    public static void arrayCopy(Object object, Object object2) {
        System.arraycopy(object, 0, object2, 0, Array.getLength(object));
    }

    public static boolean[] expand(boolean[] blArray) {
        return PApplet.expand(blArray, blArray.length << 1);
    }

    public static boolean[] expand(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, Math.min(n, blArray.length));
        return blArray2;
    }

    public static byte[] expand(byte[] byArray) {
        return PApplet.expand(byArray, byArray.length << 1);
    }

    public static byte[] expand(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n, byArray.length));
        return byArray2;
    }

    public static char[] expand(char[] cArray) {
        return PApplet.expand(cArray, cArray.length << 1);
    }

    public static char[] expand(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(n, cArray.length));
        return cArray2;
    }

    public static int[] expand(int[] nArray) {
        return PApplet.expand(nArray, nArray.length << 1);
    }

    public static int[] expand(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(n, nArray.length));
        return nArray2;
    }

    public static PImage[] expand(PImage[] pImageArray) {
        return PApplet.expand(pImageArray, pImageArray.length << 1);
    }

    public static PImage[] expand(PImage[] pImageArray, int n) {
        PImage[] pImageArray2 = new PImage[n];
        System.arraycopy(pImageArray, 0, pImageArray2, 0, Math.min(n, pImageArray.length));
        return pImageArray2;
    }

    public static float[] expand(float[] fArray) {
        return PApplet.expand(fArray, fArray.length << 1);
    }

    public static float[] expand(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(n, fArray.length));
        return fArray2;
    }

    public static String[] expand(String[] stringArray) {
        return PApplet.expand(stringArray, stringArray.length << 1);
    }

    public static String[] expand(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(n, stringArray.length));
        return stringArray2;
    }

    public static Object expand(Object object) {
        return PApplet.expand(object, Array.getLength(object) << 1);
    }

    public static Object expand(Object object, int n) {
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        System.arraycopy(object, 0, object2, 0, Math.min(Array.getLength(object), n));
        return object2;
    }

    public static byte[] append(byte[] byArray, byte by) {
        byArray = PApplet.expand(byArray, byArray.length + 1);
        byArray[byArray.length - 1] = by;
        return byArray;
    }

    public static char[] append(char[] cArray, char c) {
        cArray = PApplet.expand(cArray, cArray.length + 1);
        cArray[cArray.length - 1] = c;
        return cArray;
    }

    public static int[] append(int[] nArray, int n) {
        nArray = PApplet.expand(nArray, nArray.length + 1);
        nArray[nArray.length - 1] = n;
        return nArray;
    }

    public static float[] append(float[] fArray, float f) {
        fArray = PApplet.expand(fArray, fArray.length + 1);
        fArray[fArray.length - 1] = f;
        return fArray;
    }

    public static String[] append(String[] stringArray, String string) {
        stringArray = PApplet.expand(stringArray, stringArray.length + 1);
        stringArray[stringArray.length - 1] = string;
        return stringArray;
    }

    public static Object append(Object object, Object object2) {
        int n = Array.getLength(object);
        object = PApplet.expand(object, n + 1);
        Array.set(object, n, object2);
        return object;
    }

    public static boolean[] shorten(boolean[] blArray) {
        return PApplet.subset(blArray, 0, blArray.length - 1);
    }

    public static byte[] shorten(byte[] byArray) {
        return PApplet.subset(byArray, 0, byArray.length - 1);
    }

    public static char[] shorten(char[] cArray) {
        return PApplet.subset(cArray, 0, cArray.length - 1);
    }

    public static int[] shorten(int[] nArray) {
        return PApplet.subset(nArray, 0, nArray.length - 1);
    }

    public static float[] shorten(float[] fArray) {
        return PApplet.subset(fArray, 0, fArray.length - 1);
    }

    public static String[] shorten(String[] stringArray) {
        return PApplet.subset(stringArray, 0, stringArray.length - 1);
    }

    public static Object shorten(Object object) {
        int n = Array.getLength(object);
        return PApplet.subset(object, 0, n - 1);
    }

    public static final boolean[] splice(boolean[] blArray, boolean bl, int n) {
        boolean[] blArray2 = new boolean[blArray.length + 1];
        System.arraycopy(blArray, 0, blArray2, 0, n);
        blArray2[n] = bl;
        System.arraycopy(blArray, n, blArray2, n + 1, blArray.length - n);
        return blArray2;
    }

    public static final boolean[] splice(boolean[] blArray, boolean[] blArray2, int n) {
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, n);
        System.arraycopy(blArray2, 0, blArray3, n, blArray2.length);
        System.arraycopy(blArray, n, blArray3, n + blArray2.length, blArray.length - n);
        return blArray3;
    }

    public static final byte[] splice(byte[] byArray, byte by, int n) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        System.arraycopy(byArray, n, byArray2, n + 1, byArray.length - n);
        return byArray2;
    }

    public static final byte[] splice(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, n, byArray3, n + byArray2.length, byArray.length - n);
        return byArray3;
    }

    public static final char[] splice(char[] cArray, char c, int n) {
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        cArray2[n] = c;
        System.arraycopy(cArray, n, cArray2, n + 1, cArray.length - n);
        return cArray2;
    }

    public static final char[] splice(char[] cArray, char[] cArray2, int n) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, cArray2.length);
        System.arraycopy(cArray, n, cArray3, n + cArray2.length, cArray.length - n);
        return cArray3;
    }

    public static final int[] splice(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray2[n2] = n;
        System.arraycopy(nArray, n2, nArray2, n2 + 1, nArray.length - n2);
        return nArray2;
    }

    public static final int[] splice(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray3, n, nArray2.length);
        System.arraycopy(nArray, n, nArray3, n + nArray2.length, nArray.length - n);
        return nArray3;
    }

    public static final float[] splice(float[] fArray, float f, int n) {
        float[] fArray2 = new float[fArray.length + 1];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        fArray2[n] = f;
        System.arraycopy(fArray, n, fArray2, n + 1, fArray.length - n);
        return fArray2;
    }

    public static final float[] splice(float[] fArray, float[] fArray2, int n) {
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, n);
        System.arraycopy(fArray2, 0, fArray3, n, fArray2.length);
        System.arraycopy(fArray, n, fArray3, n + fArray2.length, fArray.length - n);
        return fArray3;
    }

    public static final String[] splice(String[] stringArray, String string, int n) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = string;
        System.arraycopy(stringArray, n, stringArray2, n + 1, stringArray.length - n);
        return stringArray2;
    }

    public static final String[] splice(String[] stringArray, String[] stringArray2, int n) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, stringArray2.length);
        System.arraycopy(stringArray, n, stringArray3, n + stringArray2.length, stringArray.length - n);
        return stringArray3;
    }

    public static final Object splice(Object object, Object object2, int n) {
        Object[] objectArray = null;
        int n2 = Array.getLength(object);
        if (object2.getClass().getName().charAt(0) == '[') {
            int n3 = Array.getLength(object2);
            objectArray = new Object[n2 + n3];
            System.arraycopy(object, 0, objectArray, 0, n);
            System.arraycopy(object2, 0, objectArray, n, n3);
            System.arraycopy(object, n, objectArray, n + n3, n2 - n);
        } else {
            objectArray = new Object[n2 + 1];
            System.arraycopy(object, 0, objectArray, 0, n);
            Array.set(objectArray, n, object2);
            System.arraycopy(object, n, objectArray, n + 1, n2 - n);
        }
        return objectArray;
    }

    public static boolean[] subset(boolean[] blArray, int n) {
        return PApplet.subset(blArray, n, blArray.length - n);
    }

    public static boolean[] subset(boolean[] blArray, int n, int n2) {
        boolean[] blArray2 = new boolean[n2];
        System.arraycopy(blArray, n, blArray2, 0, n2);
        return blArray2;
    }

    public static byte[] subset(byte[] byArray, int n) {
        return PApplet.subset(byArray, n, byArray.length - n);
    }

    public static byte[] subset(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static char[] subset(char[] cArray, int n) {
        return PApplet.subset(cArray, n, cArray.length - n);
    }

    public static char[] subset(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    public static int[] subset(int[] nArray, int n) {
        return PApplet.subset(nArray, n, nArray.length - n);
    }

    public static int[] subset(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static float[] subset(float[] fArray, int n) {
        return PApplet.subset(fArray, n, fArray.length - n);
    }

    public static float[] subset(float[] fArray, int n, int n2) {
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, n, fArray2, 0, n2);
        return fArray2;
    }

    public static String[] subset(String[] stringArray, int n) {
        return PApplet.subset(stringArray, n, stringArray.length - n);
    }

    public static String[] subset(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    public static Object subset(Object object, int n) {
        int n2 = Array.getLength(object);
        return PApplet.subset(object, n, n2 - n);
    }

    public static Object subset(Object object, int n, int n2) {
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n2);
        System.arraycopy(object, n, object2, 0, n2);
        return object2;
    }

    public static boolean[] concat(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[blArray.length + blArray2.length];
        System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
        System.arraycopy(blArray2, 0, blArray3, blArray.length, blArray2.length);
        return blArray3;
    }

    public static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static char[] concat(char[] cArray, char[] cArray2) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, 0, cArray3, cArray.length, cArray2.length);
        return cArray3;
    }

    public static int[] concat(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static float[] concat(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length + fArray2.length];
        System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
        System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
        return fArray3;
    }

    public static String[] concat(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static Object concat(Object object, Object object2) {
        Class<?> clazz = object.getClass().getComponentType();
        int n = Array.getLength(object);
        int n2 = Array.getLength(object2);
        Object object3 = Array.newInstance(clazz, n + n2);
        System.arraycopy(object, 0, object3, 0, n);
        System.arraycopy(object2, 0, object3, n, n2);
        return object3;
    }

    public static boolean[] reverse(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        int n = blArray.length - 1;
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = blArray[n - i];
        }
        return blArray2;
    }

    public static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = byArray.length - 1;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[n - i];
        }
        return byArray2;
    }

    public static char[] reverse(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        int n = cArray.length - 1;
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[i] = cArray[n - i];
        }
        return cArray2;
    }

    public static int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[n - i];
        }
        return nArray2;
    }

    public static float[] reverse(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        int n = fArray.length - 1;
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[n - i];
        }
        return fArray2;
    }

    public static String[] reverse(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = stringArray.length - 1;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[n - i];
        }
        return stringArray2;
    }

    public static Object reverse(Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object2, i, Array.get(object, n - 1 - i));
        }
        return object2;
    }

    public static String trim(String string) {
        return string.replace('\u00a0', ' ').trim();
    }

    public static String[] trim(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArray2[i] = stringArray[i].replace('\u00a0', ' ').trim();
        }
        return stringArray2;
    }

    public static String join(String[] stringArray, char c) {
        return PApplet.join(stringArray, String.valueOf(c));
    }

    public static String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String[] splitTokens(String string) {
        return PApplet.splitTokens(string, " \t\n\r\f\u00a0");
    }

    public static String[] splitTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++n;
        }
        if (n == 0) {
            String[] stringArray = new String[]{new String(string)};
            return stringArray;
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            stringArray[n2++] = new String(cArray, n3, i - n3);
            n3 = i + 1;
        }
        stringArray[n2] = new String(cArray, n3, cArray.length - n3);
        return stringArray;
    }

    public static String[] split(String string, String string2) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) != -1) {
            arrayList.add(string.substring(n2, n));
            n2 = n + string2.length();
        }
        arrayList.add(string.substring(n2));
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    static Pattern matchPattern(String string) {
        Pattern pattern = null;
        if (matchPatterns == null) {
            matchPatterns = new HashMap();
        } else {
            pattern = matchPatterns.get(string);
        }
        if (pattern == null) {
            if (matchPatterns.size() == 10) {
                matchPatterns.clear();
            }
            pattern = Pattern.compile(string, 40);
            matchPatterns.put(string, pattern);
        }
        return pattern;
    }

    public static String[] match(String string, String string2) {
        Pattern pattern = PApplet.matchPattern(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            int n = matcher.groupCount() + 1;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = matcher.group(i);
            }
            return stringArray;
        }
        return null;
    }

    public static String[][] matchAll(String string, String string2) {
        int n;
        String[] stringArray;
        Pattern pattern = PApplet.matchPattern(string2);
        Matcher matcher = pattern.matcher(string);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = matcher.groupCount() + 1;
        while (matcher.find()) {
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = matcher.group(n);
            }
            arrayList.add(stringArray);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        stringArray = new String[arrayList.size()][n2];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String[])arrayList.get(n);
        }
        return stringArray;
    }

    public static final boolean parseBoolean(int n) {
        return n != 0;
    }

    public static final boolean parseBoolean(String string) {
        return new Boolean(string);
    }

    public static final boolean[] parseBoolean(byte[] byArray) {
        boolean[] blArray = new boolean[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            blArray[i] = byArray[i] != 0;
        }
        return blArray;
    }

    public static final boolean[] parseBoolean(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            blArray[i] = nArray[i] != 0;
        }
        return blArray;
    }

    public static final boolean[] parseBoolean(String[] stringArray) {
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[i] = new Boolean(stringArray[i]);
        }
        return blArray;
    }

    public static final byte parseByte(boolean bl) {
        return bl ? (byte)1 : 0;
    }

    public static final byte parseByte(char c) {
        return (byte)c;
    }

    public static final byte parseByte(int n) {
        return (byte)n;
    }

    public static final byte parseByte(float f) {
        return (byte)f;
    }

    public static final byte[] parseByte(boolean[] blArray) {
        byte[] byArray = new byte[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            byArray[i] = blArray[i] ? (byte)1 : 0;
        }
        return byArray;
    }

    public static final byte[] parseByte(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static final byte[] parseByte(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    public static final byte[] parseByte(float[] fArray) {
        byte[] byArray = new byte[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            byArray[i] = (byte)fArray[i];
        }
        return byArray;
    }

    public static final char parseChar(byte by) {
        return (char)(by & 0xFF);
    }

    public static final char parseChar(int n) {
        return (char)n;
    }

    public static final char[] parseChar(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return cArray;
    }

    public static final char[] parseChar(int[] nArray) {
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    public static final int parseInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public static final int parseInt(byte by) {
        return by & 0xFF;
    }

    public static final int parseInt(char c) {
        return c;
    }

    public static final int parseInt(float f) {
        return (int)f;
    }

    public static final int parseInt(String string) {
        return PApplet.parseInt(string, 0);
    }

    public static final int parseInt(String string, int n) {
        try {
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                return Integer.parseInt(string);
            }
            return Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static final int[] parseInt(boolean[] blArray) {
        int[] nArray = new int[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = blArray[i] ? 1 : 0;
        }
        return nArray;
    }

    public static final int[] parseInt(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static final int[] parseInt(char[] cArray) {
        int[] nArray = new int[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            nArray[i] = cArray[i];
        }
        return nArray;
    }

    public static int[] parseInt(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = (int)fArray[i];
        }
        return nArray;
    }

    public static int[] parseInt(String[] stringArray) {
        return PApplet.parseInt(stringArray, 0);
    }

    public static int[] parseInt(String[] stringArray, int n) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = n;
            }
        }
        return nArray;
    }

    public static final float parseFloat(int n) {
        return n;
    }

    public static final float parseFloat(String string) {
        return PApplet.parseFloat(string, Float.NaN);
    }

    public static final float parseFloat(String string, float f) {
        try {
            return new Float(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public static final float[] parseByte(byte[] byArray) {
        float[] fArray = new float[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            fArray[i] = byArray[i];
        }
        return fArray;
    }

    public static final float[] parseFloat(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        return fArray;
    }

    public static final float[] parseFloat(String[] stringArray) {
        return PApplet.parseFloat(stringArray, Float.NaN);
    }

    public static final float[] parseFloat(String[] stringArray, float f) {
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                fArray[i] = new Float(stringArray[i]).floatValue();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                fArray[i] = f;
            }
        }
        return fArray;
    }

    public static final String str(boolean bl) {
        return String.valueOf(bl);
    }

    public static final String str(byte by) {
        return String.valueOf(by);
    }

    public static final String str(char c) {
        return String.valueOf(c);
    }

    public static final String str(int n) {
        return String.valueOf(n);
    }

    public static final String str(float f) {
        return String.valueOf(f);
    }

    public static final String[] str(boolean[] blArray) {
        String[] stringArray = new String[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            stringArray[i] = String.valueOf(blArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(byte[] byArray) {
        String[] stringArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            stringArray[i] = String.valueOf(byArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(char[] cArray) {
        String[] stringArray = new String[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            stringArray[i] = String.valueOf(cArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = String.valueOf(nArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(float[] fArray) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = String.valueOf(fArray[i]);
        }
        return stringArray;
    }

    public static String[] nf(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nf(nArray[i], n);
        }
        return stringArray;
    }

    public static String nf(int n, int n2) {
        if (int_nf != null && int_nf_digits == n2 && !int_nf_commas) {
            return int_nf.format(n);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(n2);
        int_nf_digits = n2;
        return int_nf.format(n);
    }

    public static String[] nfc(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfc(nArray[i]);
        }
        return stringArray;
    }

    public static String nfc(int n) {
        if (int_nf != null && int_nf_digits == 0 && int_nf_commas) {
            return int_nf.format(n);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(true);
        int_nf_commas = true;
        int_nf.setMinimumIntegerDigits(0);
        int_nf_digits = 0;
        return int_nf.format(n);
    }

    public static String nfs(int n, int n2) {
        return n < 0 ? PApplet.nf(n, n2) : ' ' + PApplet.nf(n, n2);
    }

    public static String[] nfs(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfs(nArray[i], n);
        }
        return stringArray;
    }

    public static String nfp(int n, int n2) {
        return n < 0 ? PApplet.nf(n, n2) : '+' + PApplet.nf(n, n2);
    }

    public static String[] nfp(int[] nArray, int n) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfp(nArray[i], n);
        }
        return stringArray;
    }

    public static String[] nf(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nf(fArray[i], n, n2);
        }
        return stringArray;
    }

    public static String nf(float f, int n, int n2) {
        if (float_nf != null && float_nf_left == n && float_nf_right == n2 && !float_nf_commas) {
            return float_nf.format(f);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        float_nf_commas = false;
        if (n != 0) {
            float_nf.setMinimumIntegerDigits(n);
        }
        if (n2 != 0) {
            float_nf.setMinimumFractionDigits(n2);
            float_nf.setMaximumFractionDigits(n2);
        }
        float_nf_left = n;
        float_nf_right = n2;
        return float_nf.format(f);
    }

    public static String[] nfc(float[] fArray, int n) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfc(fArray[i], n);
        }
        return stringArray;
    }

    public static String nfc(float f, int n) {
        if (float_nf != null && float_nf_left == 0 && float_nf_right == n && float_nf_commas) {
            return float_nf.format(f);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(true);
        float_nf_commas = true;
        if (n != 0) {
            float_nf.setMinimumFractionDigits(n);
            float_nf.setMaximumFractionDigits(n);
        }
        float_nf_left = 0;
        float_nf_right = n;
        return float_nf.format(f);
    }

    public static String[] nfs(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfs(fArray[i], n, n2);
        }
        return stringArray;
    }

    public static String nfs(float f, int n, int n2) {
        return f < 0.0f ? PApplet.nf(f, n, n2) : ' ' + PApplet.nf(f, n, n2);
    }

    public static String[] nfp(float[] fArray, int n, int n2) {
        String[] stringArray = new String[fArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = PApplet.nfp(fArray[i], n, n2);
        }
        return stringArray;
    }

    public static String nfp(float f, int n, int n2) {
        return f < 0.0f ? PApplet.nf(f, n, n2) : '+' + PApplet.nf(f, n, n2);
    }

    public static final String hex(byte by) {
        return PApplet.hex(by, 2);
    }

    public static final String hex(char c) {
        return PApplet.hex(c, 4);
    }

    public static final String hex(int n) {
        return PApplet.hex(n, 8);
    }

    public static final String hex(int n, int n2) {
        int n3;
        String string = Integer.toHexString(n).toUpperCase();
        if (n2 > 8) {
            n2 = 8;
        }
        if ((n3 = string.length()) > n2) {
            return string.substring(n3 - n2);
        }
        if (n3 < n2) {
            return "00000000".substring(8 - (n2 - n3)) + string;
        }
        return string;
    }

    public static final int unhex(String string) {
        return (int)Long.parseLong(string, 16);
    }

    public static final String binary(byte by) {
        return PApplet.binary(by, 8);
    }

    public static final String binary(char c) {
        return PApplet.binary(c, 16);
    }

    public static final String binary(int n) {
        return PApplet.binary(n, 32);
    }

    public static final String binary(int n, int n2) {
        int n3;
        String string = Integer.toBinaryString(n);
        if (n2 > 32) {
            n2 = 32;
        }
        if ((n3 = string.length()) > n2) {
            return string.substring(n3 - n2);
        }
        if (n3 < n2) {
            int n4 = 32 - (n2 - n3);
            return "00000000000000000000000000000000".substring(n4) + string;
        }
        return string;
    }

    public static final int unbinary(String string) {
        return Integer.parseInt(string, 2);
    }

    public final int color(int n) {
        if (this.g == null) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(n);
    }

    public final int color(float f) {
        if (this.g == null) {
            int n = (int)f;
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(f);
    }

    public final int color(int n, int n2) {
        if (this.g == null) {
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n > 255) {
                return n2 << 24 | n & 0xFFFFFF;
            }
            return n2 << 24 | n << 16 | n << 8 | n;
        }
        return this.g.color(n, n2);
    }

    public final int color(float f, float f2) {
        if (this.g == null) {
            int n = (int)f;
            int n2 = (int)f2;
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            return 0xFF000000 | n << 16 | n << 8 | n;
        }
        return this.g.color(f, f2);
    }

    public final int color(int n, int n2, int n3) {
        if (this.g == null) {
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return 0xFF000000 | n << 16 | n2 << 8 | n3;
        }
        return this.g.color(n, n2, n3);
    }

    public final int color(float f, float f2, float f3) {
        if (this.g == null) {
            if (f > 255.0f) {
                f = 255.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 > 255.0f) {
                f2 = 255.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 255.0f) {
                f3 = 255.0f;
            } else if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            return 0xFF000000 | (int)f << 16 | (int)f2 << 8 | (int)f3;
        }
        return this.g.color(f, f2, f3);
    }

    public final int color(int n, int n2, int n3, int n4) {
        if (this.g == null) {
            if (n4 > 255) {
                n4 = 255;
            } else if (n4 < 0) {
                n4 = 0;
            }
            if (n > 255) {
                n = 255;
            } else if (n < 0) {
                n = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            } else if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > 255) {
                n3 = 255;
            } else if (n3 < 0) {
                n3 = 0;
            }
            return n4 << 24 | n << 16 | n2 << 8 | n3;
        }
        return this.g.color(n, n2, n3, n4);
    }

    public final int color(float f, float f2, float f3, float f4) {
        if (this.g == null) {
            if (f4 > 255.0f) {
                f4 = 255.0f;
            } else if (f4 < 0.0f) {
                f4 = 0.0f;
            }
            if (f > 255.0f) {
                f = 255.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            if (f2 > 255.0f) {
                f2 = 255.0f;
            } else if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 255.0f) {
                f3 = 255.0f;
            } else if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            return (int)f4 << 24 | (int)f << 16 | (int)f2 << 8 | (int)f3;
        }
        return this.g.color(f, f2, f3, f4);
    }

    public static int blendColor(int n, int n2, int n3) {
        return PImage.blendColor(n, n2, n3);
    }

    public static void main(String[] stringArray) {
    }

    public void loadPixels() {
        this.g.loadPixels();
        this.pixels = this.g.pixels;
    }

    public void updatePixels() {
        this.g.updatePixels();
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        this.g.updatePixels(n, n2, n3, n4);
    }

    private void tellPDE(String string) {
        Log.i((String)this.getComponentName().getPackageName(), (String)("PROCESSING " + string));
    }

    protected void onStart() {
        this.tellPDE("onStart");
        super.onStart();
    }

    protected void onStop() {
        this.tellPDE("onStop");
        super.onStop();
    }

    public void setCache(PImage pImage, Object object) {
        this.g.setCache(pImage, object);
    }

    public Object getCache(PImage pImage) {
        return this.g.getCache(pImage);
    }

    public void removeCache(PImage pImage) {
        this.g.removeCache(pImage);
    }

    public void flush() {
        this.g.flush();
    }

    public PGL beginPGL() {
        return this.g.beginPGL();
    }

    public void endPGL() {
        this.g.endPGL();
    }

    public void hint(int n) {
        this.g.hint(n);
    }

    public void beginShape() {
        this.g.beginShape();
    }

    public void beginShape(int n) {
        this.g.beginShape(n);
    }

    public void edge(boolean bl) {
        this.g.edge(bl);
    }

    public void normal(float f, float f2, float f3) {
        this.g.normal(f, f2, f3);
    }

    public void textureMode(int n) {
        this.g.textureMode(n);
    }

    public void textureWrap(int n) {
        this.g.textureWrap(n);
    }

    public void texture(PImage pImage) {
        this.g.texture(pImage);
    }

    public void noTexture() {
        this.g.noTexture();
    }

    public void vertex(float f, float f2) {
        this.g.vertex(f, f2);
    }

    public void vertex(float f, float f2, float f3) {
        this.g.vertex(f, f2, f3);
    }

    public void vertex(float[] fArray) {
        this.g.vertex(fArray);
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.g.vertex(f, f2, f3, f4);
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.g.vertex(f, f2, f3, f4, f5);
    }

    public void breakShape() {
        this.g.breakShape();
    }

    public void beginContour() {
        this.g.beginContour();
    }

    public void endContour() {
        this.g.endContour();
    }

    public void endShape() {
        this.g.endShape();
    }

    public void endShape(int n) {
        this.g.endShape(n);
    }

    public void clip(float f, float f2, float f3, float f4) {
        this.g.clip(f, f2, f3, f4);
    }

    public void noClip() {
        this.g.noClip();
    }

    public void blendMode(int n) {
        this.g.blendMode(n);
    }

    public PShape loadShape(String string) {
        return this.g.loadShape(string);
    }

    public PShape createShape(PShape pShape) {
        return this.g.createShape(pShape);
    }

    public PShape createShape() {
        return this.g.createShape();
    }

    public PShape createShape(int n) {
        return this.g.createShape(n);
    }

    public PShape createShape(int n, float ... fArray) {
        return this.g.createShape(n, fArray);
    }

    public PShader loadShader(String string) {
        return this.g.loadShader(string);
    }

    public PShader loadShader(String string, String string2) {
        return this.g.loadShader(string, string2);
    }

    public void shader(PShader pShader) {
        this.g.shader(pShader);
    }

    public void shader(PShader pShader, int n) {
        this.g.shader(pShader, n);
    }

    public void resetShader() {
        this.g.resetShader();
    }

    public void resetShader(int n) {
        this.g.resetShader(n);
    }

    public PShader getShader(int n) {
        return this.g.getShader(n);
    }

    public void filter(PShader pShader) {
        this.g.filter(pShader);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.bezierVertex(f, f2, f3, f4, f5, f6);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.g.bezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void quadraticVertex(float f, float f2, float f3, float f4) {
        this.g.quadraticVertex(f, f2, f3, f4);
    }

    public void quadraticVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.quadraticVertex(f, f2, f3, f4, f5, f6);
    }

    public void curveVertex(float f, float f2) {
        this.g.curveVertex(f, f2);
    }

    public void curveVertex(float f, float f2, float f3) {
        this.g.curveVertex(f, f2, f3);
    }

    public void point(float f, float f2) {
        this.g.point(f, f2);
    }

    public void point(float f, float f2, float f3) {
        this.g.point(f, f2, f3);
    }

    public void line(float f, float f2, float f3, float f4) {
        this.g.line(f, f2, f3, f4);
    }

    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.line(f, f2, f3, f4, f5, f6);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.triangle(f, f2, f3, f4, f5, f6);
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.quad(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void rectMode(int n) {
        this.g.rectMode(n);
    }

    public void rect(float f, float f2, float f3, float f4) {
        this.g.rect(f, f2, f3, f4);
    }

    public void rect(float f, float f2, float f3, float f4, float f5) {
        this.g.rect(f, f2, f3, f4, f5);
    }

    public void rect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.rect(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void ellipseMode(int n) {
        this.g.ellipseMode(n);
    }

    public void ellipse(float f, float f2, float f3, float f4) {
        this.g.ellipse(f, f2, f3, f4);
    }

    public void arc(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.arc(f, f2, f3, f4, f5, f6);
    }

    public void arc(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        this.g.arc(f, f2, f3, f4, f5, f6, n);
    }

    public void box(float f) {
        this.g.box(f);
    }

    public void box(float f, float f2, float f3) {
        this.g.box(f, f2, f3);
    }

    public void sphereDetail(int n) {
        this.g.sphereDetail(n);
    }

    public void sphereDetail(int n, int n2) {
        this.g.sphereDetail(n, n2);
    }

    public void sphere(float f) {
        this.g.sphere(f);
    }

    public float bezierPoint(float f, float f2, float f3, float f4, float f5) {
        return this.g.bezierPoint(f, f2, f3, f4, f5);
    }

    public float bezierTangent(float f, float f2, float f3, float f4, float f5) {
        return this.g.bezierTangent(f, f2, f3, f4, f5);
    }

    public void bezierDetail(int n) {
        this.g.bezierDetail(n);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void bezier(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.g.bezier(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public float curvePoint(float f, float f2, float f3, float f4, float f5) {
        return this.g.curvePoint(f, f2, f3, f4, f5);
    }

    public float curveTangent(float f, float f2, float f3, float f4, float f5) {
        return this.g.curveTangent(f, f2, f3, f4, f5);
    }

    public void curveDetail(int n) {
        this.g.curveDetail(n);
    }

    public void curveTightness(float f) {
        this.g.curveTightness(f);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8);
    }

    public void curve(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.g.curve(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    public void smooth() {
        this.g.smooth();
    }

    public void smooth(int n) {
        this.g.smooth(n);
    }

    public void noSmooth() {
        this.g.noSmooth();
    }

    public void imageMode(int n) {
        this.g.imageMode(n);
    }

    public void image(PImage pImage, float f, float f2) {
        this.g.image(pImage, f, f2);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4) {
        this.g.image(pImage, f, f2, f3, f4);
    }

    public void image(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        this.g.image(pImage, f, f2, f3, f4, n, n2, n3, n4);
    }

    public void shapeMode(int n) {
        this.g.shapeMode(n);
    }

    public void shape(PShape pShape) {
        this.g.shape(pShape);
    }

    public void shape(PShape pShape, float f, float f2) {
        this.g.shape(pShape, f, f2);
    }

    public void shape(PShape pShape, float f, float f2, float f3, float f4) {
        this.g.shape(pShape, f, f2, f3, f4);
    }

    public void textAlign(int n) {
        this.g.textAlign(n);
    }

    public void textAlign(int n, int n2) {
        this.g.textAlign(n, n2);
    }

    public float textAscent() {
        return this.g.textAscent();
    }

    public float textDescent() {
        return this.g.textDescent();
    }

    public void textFont(PFont pFont) {
        this.g.textFont(pFont);
    }

    public void textFont(PFont pFont, float f) {
        this.g.textFont(pFont, f);
    }

    public void textLeading(float f) {
        this.g.textLeading(f);
    }

    public void textMode(int n) {
        this.g.textMode(n);
    }

    public void textSize(float f) {
        this.g.textSize(f);
    }

    public float textWidth(char c) {
        return this.g.textWidth(c);
    }

    public float textWidth(String string) {
        return this.g.textWidth(string);
    }

    public void text(char c, float f, float f2) {
        this.g.text(c, f, f2);
    }

    public void text(char c, float f, float f2, float f3) {
        this.g.text(c, f, f2, f3);
    }

    public void text(String string, float f, float f2) {
        this.g.text(string, f, f2);
    }

    public void text(String string, float f, float f2, float f3) {
        this.g.text(string, f, f2, f3);
    }

    public void text(String string, float f, float f2, float f3, float f4) {
        this.g.text(string, f, f2, f3, f4);
    }

    public void text(int n, float f, float f2) {
        this.g.text(n, f, f2);
    }

    public void text(int n, float f, float f2, float f3) {
        this.g.text(n, f, f2, f3);
    }

    public void text(float f, float f2, float f3) {
        this.g.text(f, f2, f3);
    }

    public void text(float f, float f2, float f3, float f4) {
        this.g.text(f, f2, f3, f4);
    }

    public void pushMatrix() {
        this.g.pushMatrix();
    }

    public void popMatrix() {
        this.g.popMatrix();
    }

    public void translate(float f, float f2) {
        this.g.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        this.g.translate(f, f2, f3);
    }

    public void rotate(float f) {
        this.g.rotate(f);
    }

    public void rotateX(float f) {
        this.g.rotateX(f);
    }

    public void rotateY(float f) {
        this.g.rotateY(f);
    }

    public void rotateZ(float f) {
        this.g.rotateZ(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.g.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        this.g.scale(f);
    }

    public void scale(float f, float f2) {
        this.g.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        this.g.scale(f, f2, f3);
    }

    public void shearX(float f) {
        this.g.shearX(f);
    }

    public void shearY(float f) {
        this.g.shearY(f);
    }

    public void resetMatrix() {
        this.g.resetMatrix();
    }

    public void applyMatrix(PMatrix pMatrix) {
        this.g.applyMatrix(pMatrix);
    }

    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.g.applyMatrix(pMatrix2D);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.applyMatrix(f, f2, f3, f4, f5, f6);
    }

    public void applyMatrix(PMatrix3D pMatrix3D) {
        this.g.applyMatrix(pMatrix3D);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.g.applyMatrix(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public PMatrix getMatrix() {
        return this.g.getMatrix();
    }

    public PMatrix2D getMatrix(PMatrix2D pMatrix2D) {
        return this.g.getMatrix(pMatrix2D);
    }

    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        return this.g.getMatrix(pMatrix3D);
    }

    public void setMatrix(PMatrix pMatrix) {
        this.g.setMatrix(pMatrix);
    }

    public void setMatrix(PMatrix2D pMatrix2D) {
        this.g.setMatrix(pMatrix2D);
    }

    public void setMatrix(PMatrix3D pMatrix3D) {
        this.g.setMatrix(pMatrix3D);
    }

    public void printMatrix() {
        this.g.printMatrix();
    }

    public void beginCamera() {
        this.g.beginCamera();
    }

    public void endCamera() {
        this.g.endCamera();
    }

    public void camera() {
        this.g.camera();
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.g.camera(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void printCamera() {
        this.g.printCamera();
    }

    public void ortho() {
        this.g.ortho();
    }

    public void ortho(float f, float f2, float f3, float f4) {
        this.g.ortho(f, f2, f3, f4);
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.ortho(f, f2, f3, f4, f5, f6);
    }

    public void perspective() {
        this.g.perspective();
    }

    public void perspective(float f, float f2, float f3, float f4) {
        this.g.perspective(f, f2, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.frustum(f, f2, f3, f4, f5, f6);
    }

    public void printProjection() {
        this.g.printProjection();
    }

    public float screenX(float f, float f2) {
        return this.g.screenX(f, f2);
    }

    public float screenY(float f, float f2) {
        return this.g.screenY(f, f2);
    }

    public float screenX(float f, float f2, float f3) {
        return this.g.screenX(f, f2, f3);
    }

    public float screenY(float f, float f2, float f3) {
        return this.g.screenY(f, f2, f3);
    }

    public float screenZ(float f, float f2, float f3) {
        return this.g.screenZ(f, f2, f3);
    }

    public float modelX(float f, float f2, float f3) {
        return this.g.modelX(f, f2, f3);
    }

    public float modelY(float f, float f2, float f3) {
        return this.g.modelY(f, f2, f3);
    }

    public float modelZ(float f, float f2, float f3) {
        return this.g.modelZ(f, f2, f3);
    }

    public void pushStyle() {
        this.g.pushStyle();
    }

    public void popStyle() {
        this.g.popStyle();
    }

    public void style(PStyle pStyle) {
        this.g.style(pStyle);
    }

    public void strokeWeight(float f) {
        this.g.strokeWeight(f);
    }

    public void strokeJoin(int n) {
        this.g.strokeJoin(n);
    }

    public void strokeCap(int n) {
        this.g.strokeCap(n);
    }

    public void noStroke() {
        this.g.noStroke();
    }

    public void stroke(int n) {
        this.g.stroke(n);
    }

    public void stroke(int n, float f) {
        this.g.stroke(n, f);
    }

    public void stroke(float f) {
        this.g.stroke(f);
    }

    public void stroke(float f, float f2) {
        this.g.stroke(f, f2);
    }

    public void stroke(float f, float f2, float f3) {
        this.g.stroke(f, f2, f3);
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.g.stroke(f, f2, f3, f4);
    }

    public void noTint() {
        this.g.noTint();
    }

    public void tint(int n) {
        this.g.tint(n);
    }

    public void tint(int n, float f) {
        this.g.tint(n, f);
    }

    public void tint(float f) {
        this.g.tint(f);
    }

    public void tint(float f, float f2) {
        this.g.tint(f, f2);
    }

    public void tint(float f, float f2, float f3) {
        this.g.tint(f, f2, f3);
    }

    public void tint(float f, float f2, float f3, float f4) {
        this.g.tint(f, f2, f3, f4);
    }

    public void noFill() {
        this.g.noFill();
    }

    public void fill(int n) {
        this.g.fill(n);
    }

    public void fill(int n, float f) {
        this.g.fill(n, f);
    }

    public void fill(float f) {
        this.g.fill(f);
    }

    public void fill(float f, float f2) {
        this.g.fill(f, f2);
    }

    public void fill(float f, float f2, float f3) {
        this.g.fill(f, f2, f3);
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.g.fill(f, f2, f3, f4);
    }

    public void ambient(int n) {
        this.g.ambient(n);
    }

    public void ambient(float f) {
        this.g.ambient(f);
    }

    public void ambient(float f, float f2, float f3) {
        this.g.ambient(f, f2, f3);
    }

    public void specular(int n) {
        this.g.specular(n);
    }

    public void specular(float f) {
        this.g.specular(f);
    }

    public void specular(float f, float f2, float f3) {
        this.g.specular(f, f2, f3);
    }

    public void shininess(float f) {
        this.g.shininess(f);
    }

    public void emissive(int n) {
        this.g.emissive(n);
    }

    public void emissive(float f) {
        this.g.emissive(f);
    }

    public void emissive(float f, float f2, float f3) {
        this.g.emissive(f, f2, f3);
    }

    public void lights() {
        this.g.lights();
    }

    public void noLights() {
        this.g.noLights();
    }

    public void ambientLight(float f, float f2, float f3) {
        this.g.ambientLight(f, f2, f3);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.ambientLight(f, f2, f3, f4, f5, f6);
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.directionalLight(f, f2, f3, f4, f5, f6);
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g.pointLight(f, f2, f3, f4, f5, f6);
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.g.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
    }

    public void lightFalloff(float f, float f2, float f3) {
        this.g.lightFalloff(f, f2, f3);
    }

    public void lightSpecular(float f, float f2, float f3) {
        this.g.lightSpecular(f, f2, f3);
    }

    public void background(int n) {
        this.g.background(n);
    }

    public void background(int n, float f) {
        this.g.background(n, f);
    }

    public void background(float f) {
        this.g.background(f);
    }

    public void background(float f, float f2) {
        this.g.background(f, f2);
    }

    public void background(float f, float f2, float f3) {
        this.g.background(f, f2, f3);
    }

    public void background(float f, float f2, float f3, float f4) {
        this.g.background(f, f2, f3, f4);
    }

    public void clear() {
        this.g.clear();
    }

    public void background(PImage pImage) {
        this.g.background(pImage);
    }

    public void colorMode(int n) {
        this.g.colorMode(n);
    }

    public void colorMode(int n, float f) {
        this.g.colorMode(n, f);
    }

    public void colorMode(int n, float f, float f2, float f3) {
        this.g.colorMode(n, f, f2, f3);
    }

    public void colorMode(int n, float f, float f2, float f3, float f4) {
        this.g.colorMode(n, f, f2, f3, f4);
    }

    public final float alpha(int n) {
        return this.g.alpha(n);
    }

    public final float red(int n) {
        return this.g.red(n);
    }

    public final float green(int n) {
        return this.g.green(n);
    }

    public final float blue(int n) {
        return this.g.blue(n);
    }

    public final float hue(int n) {
        return this.g.hue(n);
    }

    public final float saturation(int n) {
        return this.g.saturation(n);
    }

    public final float brightness(int n) {
        return this.g.brightness(n);
    }

    public int lerpColor(int n, int n2, float f) {
        return this.g.lerpColor(n, n2, f);
    }

    public static int lerpColor(int n, int n2, float f, int n3) {
        return PGraphics.lerpColor(n, n2, f, n3);
    }

    public static void showDepthWarning(String string) {
        PGraphics.showDepthWarning(string);
    }

    public static void showDepthWarningXYZ(String string) {
        PGraphics.showDepthWarningXYZ(string);
    }

    public static void showMethodWarning(String string) {
        PGraphics.showMethodWarning(string);
    }

    public static void showVariationWarning(String string) {
        PGraphics.showVariationWarning(string);
    }

    public static void showMissingWarning(String string) {
        PGraphics.showMissingWarning(string);
    }

    public boolean displayable() {
        return this.g.displayable();
    }

    public boolean isGL() {
        return this.g.isGL();
    }

    public Object getNative() {
        return this.g.getNative();
    }

    public int get(int n, int n2) {
        return this.g.get(n, n2);
    }

    public PImage get(int n, int n2, int n3, int n4) {
        return this.g.get(n, n2, n3, n4);
    }

    public PImage get() {
        return this.g.get();
    }

    public void set(int n, int n2, int n3) {
        this.g.set(n, n2, n3);
    }

    public void set(int n, int n2, PImage pImage) {
        this.g.set(n, n2, pImage);
    }

    public void mask(int[] nArray) {
        this.g.mask(nArray);
    }

    public void mask(PImage pImage) {
        this.g.mask(pImage);
    }

    public void filter(int n) {
        this.g.filter(n);
    }

    public void filter(int n, float f) {
        this.g.filter(n, f);
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.g.copy(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.g.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.g.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.g.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    static {
        ICON_IMAGE = new byte[]{71, 73, 70, 56, 57, 97, 16, 0, 16, 0, -77, 0, 0, 0, 0, 0, -1, -1, -1, 12, 12, 13, -15, -15, -14, 45, 57, 74, 54, 80, 111, 47, 71, 97, 62, 88, 117, 1, 14, 27, 7, 41, 73, 15, 52, 85, 2, 31, 55, 4, 54, 94, 18, 69, 109, 37, 87, 126, -1, -1, -1, 33, -7, 4, 1, 0, 0, 15, 0, 44, 0, 0, 0, 0, 16, 0, 16, 0, 0, 4, 122, -16, -107, 114, -86, -67, 83, 30, -42, 26, -17, -100, -45, 56, -57, -108, 48, 40, 122, -90, 104, 67, -91, -51, 32, -53, 77, -78, -100, 47, -86, 12, 76, -110, -20, -74, -101, 97, -93, 27, 40, 20, -65, 65, 48, -111, 99, -20, -112, -117, -123, -47, -105, 24, 114, -112, 74, 69, 84, 25, 93, 88, -75, 9, 46, 2, 49, 88, -116, -67, 7, -19, -83, 60, 38, 3, -34, 2, 66, -95, 27, -98, 13, 4, -17, 55, 33, 109, 11, 11, -2, -128, 121, 123, 62, 91, 120, -128, 127, 122, 115, 102, 2, 119, 0, -116, -113, -119, 6, 102, 121, -108, -126, 5, 18, 6, 4, -102, -101, -100, 114, 15, 17, 0, 59};
    }

    class AsyncImageLoader
    extends Thread {
        String filename;
        PImage vessel;

        public AsyncImageLoader(String string, PImage pImage) {
            this.filename = string;
            this.vessel = pImage;
        }

        @Override
        public void run() {
            while (PApplet.this.requestImageCount == PApplet.this.requestImageMax) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++PApplet.this.requestImageCount;
            PImage pImage = PApplet.this.loadImage(this.filename);
            if (pImage == null) {
                this.vessel.width = -1;
                this.vessel.height = -1;
            } else {
                this.vessel.width = pImage.width;
                this.vessel.height = pImage.height;
                this.vessel.format = pImage.format;
                this.vessel.pixels = pImage.pixels;
                this.vessel.bitmap = pImage.bitmap;
            }
            --PApplet.this.requestImageCount;
        }
    }

    class InternalEventQueue {
        protected Event[] queue = new Event[10];
        protected int offset;
        protected int count;

        InternalEventQueue() {
        }

        synchronized void add(Event event) {
            if (this.count == this.queue.length) {
                this.queue = (Event[])PApplet.expand(this.queue);
            }
            this.queue[this.count++] = event;
        }

        synchronized Event remove() {
            if (this.offset == this.count) {
                throw new RuntimeException("Nothing left on the event queue.");
            }
            Event event = this.queue[this.offset++];
            if (this.offset == this.count) {
                this.offset = 0;
                this.count = 0;
            }
            return event;
        }

        synchronized boolean available() {
            return this.count != 0;
        }
    }

    class RegisteredMethods {
        int count;
        Object[] objects;
        Method[] methods;
        Object[] emptyArgs = new Object[0];

        RegisteredMethods() {
        }

        void handle() {
            this.handle(this.emptyArgs);
        }

        void handle(Object[] objectArray) {
            for (int i = 0; i < this.count; ++i) {
                try {
                    this.methods[i].invoke(this.objects[i], objectArray);
                    continue;
                }
                catch (Exception exception) {
                    Throwable throwable;
                    if (exception instanceof InvocationTargetException) {
                        InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
                        throwable = invocationTargetException.getCause();
                    } else {
                        throwable = exception;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throwable.printStackTrace();
                }
            }
        }

        void add(Object object, Method method) {
            if (this.findIndex(object) == -1) {
                if (this.objects == null) {
                    this.objects = new Object[5];
                    this.methods = new Method[5];
                } else if (this.count == this.objects.length) {
                    this.objects = (Object[])PApplet.expand(this.objects);
                    this.methods = (Method[])PApplet.expand(this.methods);
                }
                this.objects[this.count] = object;
                this.methods[this.count] = method;
                ++this.count;
            } else {
                PApplet.this.die(method.getName() + "() already added for this instance of " + object.getClass().getName());
            }
        }

        public void remove(Object object) {
            int n = this.findIndex(object);
            if (n != -1) {
                --this.count;
                for (int i = n; i < this.count; ++i) {
                    this.objects[i] = this.objects[i + 1];
                    this.methods[i] = this.methods[i + 1];
                }
                this.objects[this.count] = null;
                this.methods[this.count] = null;
            }
        }

        protected int findIndex(Object object) {
            for (int i = 0; i < this.count; ++i) {
                if (this.objects[i] != object) continue;
                return i;
            }
            return -1;
        }
    }

    public class SketchSurfaceViewGL
    extends GLSurfaceView {
        PGraphicsOpenGL g3;
        SurfaceHolder surfaceHolder;

        public SketchSurfaceViewGL(Context context, int n, int n2, boolean bl) {
            boolean bl2;
            super(context);
            ActivityManager activityManager = (ActivityManager)PApplet.this.getSystemService("activity");
            ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
            boolean bl3 = bl2 = configurationInfo.reqGlEsVersion >= 131072;
            if (!bl2) {
                throw new RuntimeException("OpenGL ES 2.0 is not supported by this device.");
            }
            this.surfaceHolder = this.getHolder();
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            this.g3 = bl ? new PGraphics3D() : new PGraphics2D();
            this.g3.setParent(PApplet.this);
            this.g3.setPrimary(true);
            this.g3.setSize(n, n2);
            this.setEGLContextClientVersion(2);
            this.setRenderer(this.g3.pgl.getRenderer());
            this.setRenderMode(0);
            PApplet.this.g = this.g3;
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        }

        public PGraphics getGraphics() {
            return this.g3;
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            super.surfaceCreated(surfaceHolder);
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            super.surfaceDestroyed(surfaceHolder);
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            super.surfaceChanged(surfaceHolder, n, n2, n3);
            PApplet.this.surfaceChanged = true;
        }

        public void onWindowFocusChanged(boolean bl) {
            PApplet.this.surfaceWindowFocusChanged(bl);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            return PApplet.this.surfaceTouchEvent(motionEvent);
        }

        public boolean onKeyDown(int n, android.view.KeyEvent keyEvent) {
            return PApplet.this.surfaceKeyDown(n, keyEvent);
        }

        public boolean onKeyUp(int n, android.view.KeyEvent keyEvent) {
            return PApplet.this.surfaceKeyUp(n, keyEvent);
        }
    }

    public class SketchSurfaceView
    extends SurfaceView
    implements SurfaceHolder.Callback {
        PGraphicsAndroid2D g2;
        SurfaceHolder surfaceHolder;

        public SketchSurfaceView(Context context, int n, int n2) {
            super(context);
            this.surfaceHolder = this.getHolder();
            this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            this.surfaceHolder.setType(2);
            this.g2 = new PGraphicsAndroid2D();
            this.g2.setSize(n, n2);
            this.g2.setParent(PApplet.this);
            this.g2.setPrimary(true);
            PApplet.this.g = this.g2;
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            PApplet.this.surfaceChanged = true;
        }

        public void onWindowFocusChanged(boolean bl) {
            PApplet.this.surfaceWindowFocusChanged(bl);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            return PApplet.this.surfaceTouchEvent(motionEvent);
        }

        public boolean onKeyDown(int n, android.view.KeyEvent keyEvent) {
            return PApplet.this.surfaceKeyDown(n, keyEvent);
        }

        public boolean onKeyUp(int n, android.view.KeyEvent keyEvent) {
            return PApplet.this.surfaceKeyUp(n, keyEvent);
        }
    }

    public static class RendererChangeException
    extends RuntimeException {
    }
}

