//x = [1,2,3,4,5,6];
//y = [1,4,8,7,4,1];

//plot(x,y);



function fz = berechneZielkraft(xs,ys)
    //Position des Ziels:
    zx=10;
    zy=10;

    //Verstärkungsfaktor der Kraft:
    vfaktor = 10.0;

    //1. Differenzvektor:
    differenz = [zx-xs;zy-ys];

    //2. Betrag berechnen
    laenge = sqrt(  differenz'*differenz  );

    fz = [0;0];

    if laenge>0.1 then
           fz = differenz./laenge;
    end

    fz = fz*vfaktor;

endfunction

function fh = berechneHinderniskraft(xs,ys)
    //Position des Hindernisses:
    hx=5;
    hy=5;

    //Verstärkungsfaktor der Kraft:
    vfaktor = 10.0;

    //1. Differenzvektor:
    differenz = [hx-xs;hy-ys];

    //2. Betrag berechnen
    laenge = sqrt(  differenz'*differenz  );

    fh = [0;0];

    if laenge>0.1 then
           fh = differenz./laenge;
    end

    //Quadratisch abnehmend:
    abnahme = 1/((laenge*laenge)+0.01);

    fh = fh*vfaktor*abnahme;

endfunction

//Beide Kräfte zusammenfassen für fchamp:
function fa = berechneAntriebskraft(xs,ys)
    fa  = berechneZielkraft(xs,ys) + berechneHinderniskraft(xs,ys);
endfunction

function f = rechteSeite(t,y)

    D = 1;
    m = 1;

    xs = y(1,1);
    vx = y(2,1);
    ys = y(3,1);
    vy = y(4,1);

    FA  = berechneZielkraft(xs,ys) + berechneHinderniskraft(xs,ys);

    FAx = FA(1);
    FAy = FA(2);

    f(1,1) = vx;                  //   dx/dt  = vx
    f(2,1) = (-D*vx + FAx)/m;     //   dvx/dt = FAx -D*x
    f(3,1) = vy;                  //   dy/dt  = vy
    f(4,1) = (-D*vy + FAy)/m;     //   dvy/dt = FAy -D*y

endfunction

//t = linspace(0,30,3000);
t = 0:0.01:5;

y0 = [0,0.3,0,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

//plot(t,y(2,:)',t,y(4,:)');
//plot(t,y(1,:)',t,y(3,:)');
plot(y(1,:)',y(3,:)');

//
//fchamp(berechneAntriebskraft,0,linspace(-1,12,13),linspace(-1,12,13));
fchamp(berechneHinderniskraft,0,linspace(-1,12,13),linspace(-1,12,13));
//fchamp(berechneZielkraft,0,linspace(-1,12,13),linspace(-1,12,13));

