import oscP5.*;
import netP5.*;
//import processing.vr.*;
EyeMatrix eyeMat;
PShape spheres;
OscP5 oscP5;

//Resultat zu Koordinatenrichtungen:

// x-Achse zeigt nach rechts 
// y-Achse zeigt nach oben
// z-Achse zeigt nach hinten
// eigene Position: z>0, also leicht nach hinten versetzt

//Auslesen der Objektmatrix:
//Spalten 1..3: Einheitsvektoren des Blick-Koordinatensystems, 4. Spalte Position des Viewers.

//PMatrix3D eyeMat = new PMatrix3D();
void setup() 
{
  oscP5 = new OscP5(this,6217);
  eyeMat = new EyeMatrix();
  fullScreen(P3D);
  spheres = createShape(GROUP);
  float[][] orte = {
                       {1000,0,0},  //rot links von mir
                       {-1000,0,0}, //grün rechts von mir
                       {0,1000,0},  //gelb unter mir
                       {0,-1000,0}, //blau über mir
                       {0,0,1000},  //türkis hinter mir
                       {0,0,-1000}  //violett weit vor mir durch weiss verdeckt!
                   };
  int[][] farben = {
                        {255,0,0},//rot
                        {0,255,0},//gruen
                        {255,255,0},//gelb
                        {0,0,255},  //blau
                        {0,255,255},//türkis
                        {255,0,255}  //violett
                   };                   
  for(int i=0;i<orte.length;i++)
  {
      PShape sphere = createShape(SPHERE, 50);
      sphere.setStroke(false);
      sphere.setFill(color(farben[i][0],farben[i][1],farben[i][2]));
      sphere.translate(orte[i][0],orte[i][1],orte[i][2]);
      spheres.addChild(sphere);
  }
  textAlign(CENTER, CENTER);
//  textSize(displayDensity * 36);  
  textSize(36);  
  frameRate(30);
}
int zzz=0;
float phi = 0.0f;
void draw() 
{
  background(0);
//  getEyeMatrix(eyeMat); //Kameramatrix auslesen
pushMatrix();
rotateY(phi);

//  translate(eyeMat.m03, eyeMat.m13, eyeMat.m23); //Welt in Koordinatenursprung von Kamera setzen.
  lights();
  shape(spheres);

  //eye(); //Transformation realtiv zur Kamera
  
  //translate(0, 0, 500); //Zielkreis relativ zur Kamera zeichnen
  
  if(zzz%90==0)
  {
      println(zzz);
      //Einheitsvektoren des Kamerasystems in Koordinaten des Inertialsystems ex, ey , ez
      println("ex=["+nfp(eyeMat.m00,1,3)+","+nfp(eyeMat.m10,1,3)+","+nfp(eyeMat.m20,1,3)+"]");
      println("ey=["+nfp(eyeMat.m01,1,3)+","+nfp(eyeMat.m11,1,3)+","+nfp(eyeMat.m21,1,3)+"]");
      //ez zeigt in die Blickrichtung!
      //In Startrichtung nach vorne blicken: ez=[0,0,-1]
      //nach links blicken:                  ez=[-1,0,0]
      //nach rechts blicken:                 ez=[ 1,0,0]
      //nach hinten blicken:                 ez=[ 0,0,1]
      //nach oben   blicken:                 ez=[ 0,-1,0]
      //nach unten  blicken:                 ez=[ 0, 1,0]
      println("ez=["+nfp(eyeMat.m02,1,3)+","+nfp(eyeMat.m12,1,3)+","+nfp(eyeMat.m22,1,3)+"]");
      println("pos=["+nfp(eyeMat.m03,1,3)+","+nfp(eyeMat.m13,1,3)+","+nfp(eyeMat.m23,1,3)+"]");
      println("ez so anpassen, dass dessn Norm mit den Koordinaten der Spheren übereinstimmt:");
      println("ez=["+nfp(eyeMat.m02,1,3)+","+nfp(-eyeMat.m12,1,3)+","+nfp(eyeMat.m22,1,3)+"]");
  }    
  zzz++;
  //eyeX Y Z
  //centerX Y Z
  //upX Y Z
popMatrix();  
  noFill();
  stroke(255,0,0);
  ellipse(0, 0, 50, 50);
  camera(0, 0, 500, 0, 0, 0, 0, 1, 0);
/*  
  camera(0, 0, 0, 
         0,    0,   -1, 
         0,    0,   1);
*/
//  phi+=0.01;
}


void oscEvent(OscMessage theOscMessage) 
{
  /* print the address pattern and the typetag of the received OscMessage */
  print("### received an osc message.");
  print(" addrpattern: "+theOscMessage.addrPattern());
  println(" typetag: "+theOscMessage.typetag());
  
  if(theOscMessage.checkAddrPattern("/kramann")==true) 
  {
       eyeMat.m00 = ((float)theOscMessage.get(0).intValue())/1000.0;
       eyeMat.m01 = ((float)theOscMessage.get(1).intValue())/1000.0;
       eyeMat.m02 = ((float)theOscMessage.get(2).intValue())/1000.0;
       eyeMat.m03 = ((float)theOscMessage.get(3).intValue())/1000.0;
       
       eyeMat.m10 = ((float)theOscMessage.get(4).intValue())/1000.0;
       eyeMat.m11 = ((float)theOscMessage.get(5).intValue())/1000.0;
       eyeMat.m12 = ((float)theOscMessage.get(6).intValue())/1000.0;
       eyeMat.m13 = ((float)theOscMessage.get(7).intValue())/1000.0;
       
       eyeMat.m20 = ((float)theOscMessage.get(8).intValue())/1000.0;
       eyeMat.m21 = ((float)theOscMessage.get(9).intValue())/1000.0;
       eyeMat.m22 = ((float)theOscMessage.get(10).intValue())/1000.0;
       eyeMat.m23 = ((float)theOscMessage.get(11).intValue())/1000.0;
       
       eyeMat.m30 = ((float)theOscMessage.get(12).intValue())/1000.0;
       eyeMat.m31 = ((float)theOscMessage.get(13).intValue())/1000.0;
       eyeMat.m32 = ((float)theOscMessage.get(14).intValue())/1000.0;
       eyeMat.m33 = ((float)theOscMessage.get(15).intValue())/1000.0;
       
       phi = eyeMat.bestimmePHIY();       
  }
  
}