import processing.vr.*;
import oscP5.*;
import netP5.*;

PShape spheres;
OscP5 oscP5;
NetAddress myRemoteLocation;

//Resultat zu Koordinatenrichtungen:

// x-Achse zeigt nach rechts 
// y-Achse zeigt nach oben
// z-Achse zeigt nach hinten
// eigene Position: z>0, also leicht nach hinten versetzt

//Auslesen der Objektmatrix:
//Spalten 1..3: Einheitsvektoren des Blick-Koordinatensystems, 4. Spalte Position des Viewers.
PMatrix3D eyeMat = new PMatrix3D();
public void sendeEyeMat()
{
     OscMessage myMessage = new OscMessage("/kramann");
     myMessage.add((int)round(1000.0*eyeMat.m00));
     myMessage.add((int)round(1000.0*eyeMat.m01));
     myMessage.add((int)round(1000.0*eyeMat.m02));
     myMessage.add((int)round(1000.0*eyeMat.m03));
     myMessage.add((int)round(1000.0*eyeMat.m10));
     myMessage.add((int)round(1000.0*eyeMat.m11));
     myMessage.add((int)round(1000.0*eyeMat.m12));
     myMessage.add((int)round(1000.0*eyeMat.m13));
     myMessage.add((int)round(1000.0*eyeMat.m20));
     myMessage.add((int)round(1000.0*eyeMat.m21));
     myMessage.add((int)round(1000.0*eyeMat.m22));
     myMessage.add((int)round(1000.0*eyeMat.m23));
     myMessage.add((int)round(1000.0*eyeMat.m30));
     myMessage.add((int)round(1000.0*eyeMat.m31));
     myMessage.add((int)round(1000.0*eyeMat.m32));
     myMessage.add((int)round(1000.0*eyeMat.m33));
     oscP5.send(myMessage, myRemoteLocation);      
}

void setup() 
{
  oscP5 = new OscP5(this,6217);
  myRemoteLocation = new NetAddress("192.168.178.21",6217);
  
  fullScreen(STEREO);
  spheres = createShape(GROUP);
  float[][] orte = {
                       {1000,0,0},  //rot links von mir
                       {-1000,0,0}, //grün rechts von mir
                       {0,1000,0},  //gelb unter mir
                       {0,-1000,0}, //blau über mir
                       {0,0,1000},  //türkis hinter mir
                       {0,0,-1000}  //violett weit vor mir durch weiss verdeckt!
                   };
  int[][] farben = {
                        {255,0,0},//rot
                        {0,255,0},//gruen
                        {255,255,0},//gelb
                        {0,0,255},  //blau
                        {0,255,255},//türkis
                        {255,0,255}  //violett
                   };                   
  for(int i=0;i<orte.length;i++)
  {
      PShape sphere = createShape(SPHERE, 50);
      sphere.setStroke(false);
      sphere.setFill(color(farben[i][0],farben[i][1],farben[i][2]));
      sphere.translate(orte[i][0],orte[i][1],orte[i][2]);
      spheres.addChild(sphere);
  }
  textAlign(CENTER, CENTER);
  textSize(displayDensity * 36);  
  frameRate(30);
}
int zzz=0;
void draw() 
{
  background(0);
  getEyeMatrix(eyeMat); //Kameramatrix auslesen

  if(zzz%11==0)
  {
       sendeEyeMat();
  }
  
  translate(eyeMat.m03, eyeMat.m13, eyeMat.m23); //Welt in Koordinatenursprung von Kamera setzen.
  lights();
  shape(spheres);

  eye(); //Transformation realtiv zur Kamera
  translate(0, 0, 500); //Zielkreis relativ zur Kamera zeichnen
  noFill();
  stroke(255,0,0);
  ellipse(0, 0, 50, 50);
  
  if(zzz%90==0)
  {
      println(zzz);
      //Einheitsvektoren des Kamerasystems in Koordinaten des Inertialsystems ex, ey , ez
      println("ex=["+nfp(eyeMat.m00,1,3)+","+nfp(eyeMat.m10,1,3)+","+nfp(eyeMat.m20,1,3)+"]");
      println("ey=["+nfp(eyeMat.m01,1,3)+","+nfp(eyeMat.m11,1,3)+","+nfp(eyeMat.m21,1,3)+"]");
      //ez zeigt in die Blickrichtung!
      //In Startrichtung nach vorne blicken: ez=[0,0,-1]
      //nach links blicken:                  ez=[-1,0,0]
      //nach rechts blicken:                 ez=[ 1,0,0]
      //nach hinten blicken:                 ez=[ 0,0,1]
      //nach oben   blicken:                 ez=[ 0,-1,0]
      //nach unten  blicken:                 ez=[ 0, 1,0]
      println("ez=["+nfp(eyeMat.m02,1,3)+","+nfp(eyeMat.m12,1,3)+","+nfp(eyeMat.m22,1,3)+"]");
      println("pos=["+nfp(eyeMat.m03,1,3)+","+nfp(eyeMat.m13,1,3)+","+nfp(eyeMat.m23,1,3)+"]");
      println("ez so anpassen, dass dessn Norm mit den Koordinaten der Spheren übereinstimmt:");
      println("ez=["+nfp(eyeMat.m02,1,3)+","+nfp(-eyeMat.m12,1,3)+","+nfp(eyeMat.m22,1,3)+"]");
  }    
  zzz++;
}