#include <Arduino_FreeRTOS.h>

// define two tasks for Blink & AnalogRead
void Task1( void *a );
void Task2( void *b );
char str1[]="Hello";
char str2[]="Bye";
int x=1;

int MAX1 = 0;
int MAX2 = 0;

// the setup function runs once when you press reset or power the board
void setup() {
  
  // initialize serial communication at 9600 bits per second:
  Serial.begin(9600);
  
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB, on LEONARDO, MICRO, YUN, and other 32u4 based boards.
  }

  // Now set up two tasks to run independently.
  xTaskCreate(
    Task1
    ,  (const portCHAR *)"Hello"   // A name just for humans
    ,  128  // This stack size can be checked & adjusted by reading the Stack Highwater
    ,  NULL
    ,  0 // Priority, with 3 (configMAX_PRIORITIES - 1) being the highest, and 0 being the lowest.
    ,  NULL );

  xTaskCreate(
    Task2
    ,  (const portCHAR *) "Bye"
    ,  128  // Stack size
    ,  NULL
    ,  0 // Priority
    ,  NULL );

  // Now the task scheduler, which takes over control of scheduling individual tasks, is automatically started.
}

void loop()
{
  // Empty. Things are done in Tasks.
}


                    


void Task1(void *a)  // This is a task.
{
  (void) a;
  for (;;)
  {
    if (x==1)
    {
      x=0;
      MAX1=strlen(str1);
    }  
    else
    {
      MAX1=0;  
    }
    
    for (int i=0;i<MAX1;i++)
    {    
      Serial.println(str1[i]);
      vTaskDelay(10);
    }
 
//    if (x==0)   nicht ganz richtig!
    if (MAX1>0)   //Resource durch aktuellen Task in Benutzung
    { 
      x=1;
      vTaskDelay(20);
    }
      
  }
}


void Task2(void *b)  // This is a task.
{
  (void) b;
  for (;;)
  {
    if (x==1)
    {
      x=0;
      MAX2=strlen(str2);
    }  
    else
    {
      MAX2=0;  
    }
    
    for (int i=0;i<MAX2;i++)
    {    
      Serial.println(str2[i]);
      vTaskDelay(10);
    }
 
//    if (x==0)   nicht ganz richtig!
    if (MAX2>0)   //Resource durch aktuellen Task in Benutzung
    { 
      x=1;
      vTaskDelay(20);
    }
      
  }
}
