public interface iWav
{
    public abstract void saveWav(String name, float[][] data);  
    //float-Array wieder zurück in ein byte-Array umwandeln (Vorbereitung speichern eines Stereokanals)
    public abstract byte[] toByte(float[][] data);
    //Lädt eine Stereo-Wav-Datei in zwei getrennten float-Arrays, Wertebereich [-1,+1]:
    public abstract float[][] ladeWav(String name);
    public abstract float[][] ladeWavGEKUERZT(String name,int ANZAHL_SAMPLES, int AUSKLANG_SAMPLES, float VERST);
    public abstract float[][] ladeWav(String name, int sampleanzahl);
    //Lädt eine Stereo-Wav-Datei, die dann zu einem Kanal gemischt wird und als float-Array zurück gegeben wird.
    //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)
    public abstract float[] ladeWavMix(String name); 
    /**
     * Lädt eine Stereo-Datei, mixt sie zu Mono und baut sie zu einer loop-baren Variante
     * zusammen:<br/>
     * [AB] a=A ausblenden, b=B einblenden<br/>
     * ab + ba<br/>
     */
    public abstract float[] ladeWavMixLoop(String name); //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)
    //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)    
    public abstract float[] ladeWavMix(String name, int sampleanzahl);
    //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)    
    public abstract float[] ladeWavMixLoop(String name, int sampleanzahl); 
    /**
    *  Lädt wav-Files, die als 16-Bit Mono-Files vorliegen
    */
    public abstract float[] ladeWavMono(String name); 
    /**
     * Shows wav-data as Java-short-Array
     */
    public abstract void showAsShortArray(float[] wav);    
}
public class Wav implements iWav
{
    private PApplet pap;
  
    public Wav(PApplet pap)
    {
        this.pap = pap;
    }



    public void saveWav(String name, float[][] data)
    {
          double gross = 0.5*(255.0*256.0 + 255.0);
          double gesamt_links,gesamt_rechts;
          byte[] dat = new byte[44+data[0].length*4];
          for(int i=0;i<data[0].length;i++)
          {
               float links = data[0][i];
               float rechts = data[1][i];
               
               gesamt_links = Math.round(  (links+gross)*gross  );
               gesamt_rechts = Math.round(  (rechts+gross)*gross  );
               

               int lo_links = (int)gesamt_links%256;
               int lo_rechts = (int)gesamt_rechts%256;
               int hi_links = (int)gesamt_links/256;
               int hi_rechts = (int)gesamt_rechts/256;

               hi_links-=128;
               hi_rechts-=128;
               
               byte left_lo = (byte)lo_links;
               byte left_hi = (byte)hi_links;
               byte right_lo = (byte)lo_rechts;
               byte right_hi = (byte)hi_rechts;
               
               dat[44+i*4+0] = left_lo;               
               dat[44+i*4+1] = left_hi;               
               dat[44+i*4+2] = right_lo;               
               dat[44+i*4+3] = right_hi;               
          }
          
          //Kopf für wav-Datei passend erzeugen:
          int[] kopf = {  82,   73,   70,   70,   52,  177,    2,    0,   87,   65, 
                                86,   69,  102,  109,  116,   32,   16,    0,    0,    0, 
                                 1,    0,    2,    0,   68,  172,    0,    0,   16,  177, 
                                 2,    0,    4,    0,   16,    0,  100,   97,  116,   97, 
                                16,  177,    2,    0  };
          int[] zahl1 = {0,0,0,0};
          int[] zahl2 = {0,0,0,0};

          int  z1 = data[0].length*4+36;
          int  z2 = data[0].length*4;
          //KOPF bilden
          for(int i=0;i<4;i++)
          {  
              zahl1[i] = z1%256;
              z1/=256;
              kopf[4+i] = zahl1[i];
          }
          for(int i=0;i<4;i++)
          {
              zahl2[i] = z2%256;
              z2/=256;
              kopf[40+i] = zahl2[i];
          }
          
          for(int i=0;i<kopf.length;i++)
//              dat[i] = (byte)(kopf[i]-128);
              dat[i] = (byte)(kopf[i]);
              
          pap.saveBytes(name,dat);    
    }

    public byte[] toByte(float[][] data)
    {
          double gross = 0.5*(255.0*256.0 + 255.0);
          double gesamt_links,gesamt_rechts;
          byte[] dat = new byte[data[0].length*4];
          for(int i=0;i<data[0].length;i++)
          {
               float links = data[0][i];
               float rechts = data[1][i];
               
               gesamt_links = Math.round(  (links+gross)*gross  );
               gesamt_rechts = Math.round(  (rechts+gross)*gross  );
               

               int lo_links = (int)gesamt_links%256;
               int lo_rechts = (int)gesamt_rechts%256;
               int hi_links = (int)gesamt_links/256;
               int hi_rechts = (int)gesamt_rechts/256;

               hi_links-=128;
               hi_rechts-=128;
               
               byte left_lo = (byte)lo_links;
               byte left_hi = (byte)hi_links;
               byte right_lo = (byte)lo_rechts;
               byte right_hi = (byte)hi_rechts;
               
               dat[i*4+0] = left_lo;               
               dat[i*4+1] = left_hi;               
               dat[i*4+2] = right_lo;               
               dat[i*4+3] = right_hi;               
          }
          
          return dat;
    }

    /**
     * Lädt eine Stereo-Wav-Datei in zwei getrennten float-Arrays, Wertebereich [-1,+1]
     */
    public float[][] ladeWav(String name)
    {
            int zl,zh,lo,gesamt;
            float gross = 0.5f*(255.0f*256.0f + 255.0f);
          
            byte[] dat = pap.loadBytes(name);

            int anz = dat.length;
          
            float[][] y = new float[2][(anz-44)/4];                        
            //float[][] y = new float[2][sampleanzahl];                        

            int inx=44;
            
            for(int i=0;i<y[0].length;i++)
            {
                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;                
                 gesamt+=lo;
                
                 y[0][i] = ((float)gesamt - gross)/gross;        

                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 y[1][i] = ((float)gesamt - gross)/gross;        
                 
            }    
            
            return y;
    }

    /**
     * Lädt eine Stereo-Wav-Datei in zwei getrennten float-Arrays, Wertebereich [-1,+1]
     */
    public float[][] ladeWavGEKUERZT(String name,int ANZAHL_SAMPLES, int AUSKLANG_SAMPLES, float VERST)
    {
            int zl,zh,lo,gesamt;
            float gross = 0.5f*(255.0f*256.0f + 255.0f);
          
            byte[] dat = pap.loadBytes(name);

            int anz = dat.length;
          
            //maximal 2 sek!
            int anz2 = ANZAHL_SAMPLES*4 + 44;
            if(anz2 > anz)
                anz2 = anz;
          
//            float[][] y = new float[2][(anz-44)/4];                        
            float[][] y = new float[2][(anz2-44)/4];                        
            //float[][] y = new float[2][sampleanzahl];                        

            int inx=44;
            
            for(int i=0;i<y[0].length;i++)
            {
                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;                
                 gesamt+=lo;
                
                 y[0][i] = ((float)gesamt - gross)/gross;        

                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 y[1][i] = ((float)gesamt - gross)/gross;        
                 
            }    
            
            //Hinteren Bereich ausklingen lassen:
            for(int i=0;i<=AUSKLANG_SAMPLES;i++)
            {
                 double f = 1.0 - (double)i/(double)AUSKLANG_SAMPLES;
                 y[0][y[0].length-1-AUSKLANG_SAMPLES+i] = (float)(f*(double)y[0][y[0].length-1-AUSKLANG_SAMPLES+i]);
                 y[1][y[1].length-1-AUSKLANG_SAMPLES+i] = (float)(f*(double)y[1][y[1].length-1-AUSKLANG_SAMPLES+i]);
            }

            for(int i=0;i<y[0].length;i++)
                y[0][i]*=VERST;
            for(int i=0;i<y[1].length;i++)
                y[1][i]*=VERST;
            
            return y;
    }
  
  
    /**
    *   Prüft, ob pfad+"/ton"+midi+".wav" im Original existiert, sucht andernfalls nach Nachbarn und interpoliert diese.    
    */
    int[] tests = {-1,1,-2,2,-3,3,-4,4,-5,5,-6,6,-7,7,-8,8,-9,9,-10,10,-11,11,-12,12};
    public float[][] ladeWavInterpolate(String pfad,int midi)
    {
        String name = pfad+"/ton"+midi+".wav";
        if(  (new File(name)).exists()  )
        {
             return ladeWav(name);    
        }
        else
        {
             for(int i=0;i<tests.length;i++)
             {
                 name = pfad+"/ton"+(midi+tests[i])+".wav";
                 if(  (new File(name)).exists()  )
                 {
                     float[][] data =  ladeWav(name);
                     
                     double ineu = Math.pow(2.0,(1.0/12.0)*(double)(-tests[i]));
                     
                     float[][] data_neu = new float[2][(int)Math.round((double)data[0].length/ineu)+1];
                     
                     for(int k=0;k<data_neu[0].length;k++)
                     {
                           double inx = ineu*(double)k;
                           double inx1 = Math.floor(inx);
                           double inx2 = Math.ceil(inx);
                           int iinx1 = (int)inx1;
                           int iinx2 = (int)inx2;
                           
                           if(iinx1==iinx2 && iinx1>=0 && iinx1<data[0].length)
                           {
                                data_neu[0][k] = data[0][iinx1];
                                data_neu[1][k] = data[1][iinx1];
                           }
                           else if(iinx1!=iinx2 && iinx1>=0 && iinx1<data[0].length && iinx2>=0 && iinx2<data[0].length)
                           {
                                double anteil2 = inx - inx1;  
                                double anteil1 = 1.0 - anteil2;  
                                data_neu[0][k] = (float)anteil1*data[0][iinx1] + (float)anteil2*data[0][iinx2];
                                data_neu[1][k] = (float)anteil1*data[1][iinx1] + (float)anteil2*data[1][iinx2];
                           }
                           
                     }
                     
                     return data_neu;
                 }
             }
        }
        
        return null;
    }  
    
    /**
     * Lädt eine Stereo-Wav-Datei in zwei getrennten float-Arrays, Wertebereich [-1,+1]
     */
    public float[][] ladeWav(String name, int sampleanzahl)
    {
            int zl,zh,lo,gesamt;
            float gross = 0.5f*(255.0f*256.0f + 255.0f);
          
            byte[] dat = pap.loadBytes(name);

            int anz = dat.length;
          
            //double[][] y = new double[2][(anz-44)/4];                        
            float[][] y = new float[2][sampleanzahl];                        

            int inx=44;
            
            for(int i=0;i<y[0].length;i++)
            {
                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 y[0][i] = ((float)gesamt - gross)/gross;        

                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 y[1][i] = ((float)gesamt - gross)/gross;        
                 
            }    
            
            return y;
    }

    /**
     * Lädt eine Stereo-Wav-Datei, die dann zu einem Kanal gemischt wird und als float-Array zurück gegeben wird.
     */
    public float[] ladeWavMix(String name) //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)
    {
            int zl,zh,lo,gesamt;
            float gross = 0.5f*(255.0f*256.0f + 255.0f);
          
            byte[] dat = pap.loadBytes(name);

            int anz = dat.length;
          
            //double[][] y = new double[2][(anz-44)/4];                        
            //float[] y = new float[sampleanzahl];                        
            float[] y = new float[(anz-44)/4];                        

            int inx=44;
            
            for(int i=0;i<y.length;i++)
            {
                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 //y[0][i] = ((float)gesamt - gross)/gross;        
                 y[i] = 0.5f*((float)gesamt - gross)/gross;        

                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 //y[1][i] = ((float)gesamt - gross)/gross;        
                 y[i] += 0.5f*((float)gesamt - gross)/gross;        
                 
            }    
            
            return y;    
    }
    
    /**
     * Lädt eine Stereo-Datei, mixt sie zu Mono und baut sie zu einer loop-baren Variante
     * zusammen:<br/>
     * [AB] a=A ausblenden, b=B einblenden<br/>
     * ab + ba<br/>
     */
    public float[] ladeWavMixLoop(String name) //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)
    {
          float[] AB = ladeWavMix(name);   
          for(int i=0;i<AB.length/2;i++)
          {
              AB[i] = AB[i]*(1.0f - (float)i/(float)(AB.length/2)-1);
              int ii = AB.length-1-i;
              AB[ii] = AB[ii]*(1.0f - (float)i/(float)(AB.length/2)-1);
          }   
          
          for(int i=0;i<AB.length/2;i++)
          {
              int ii = AB.length/2+i;
              float a = AB[i];
              float b = AB[ii];
              AB[i] = a+b;
              AB[ii] = a+b;
          }   
          return AB;
    }

    public float[] ladeWavMix(String name, int sampleanzahl) //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)
    {
         float[][] stereo = ladeWav(name,sampleanzahl);
         for(int i=0;i<stereo[0].length;i++)
             stereo[0][i] = 0.5f*(stereo[0][i]+stereo[1][i]);
         return stereo[0];    
    }
    
    public float[] ladeWavMixLoop(String name, int sampleanzahl) //Gleich nur Mix aus linkem und rechtem Kanal laden (aus 44100 2x16Bit extrahieren)
    {
         float[][] stereo = ladeWav(name,sampleanzahl);
         for(int i=0;i<stereo[0].length;i++)
             stereo[0][i] = 0.5f*(stereo[0][i]+stereo[1][i]);
         float[] AB = stereo[0];   
         for(int i=0;i<AB.length/2;i++)
         {
              AB[i] = AB[i]*(1.0f - (float)i/(float)(AB.length/2)-1);
              int ii = AB.length-1-i;
              AB[ii] = AB[ii]*(1.0f - (float)i/(float)(AB.length/2)-1);
         }   
          
         for(int i=0;i<AB.length/2;i++)
         {
              int ii = AB.length/2+i;
              float a = AB[i];
              float b = AB[ii];
              AB[i] = a+b;
              AB[ii] = a+b;
         }   
         return AB;
         
    }
    
    /**
    *  Lädt wav-Files, die als 16-Bit Mono-Files vorliegen
    */
    public float[] ladeWavMono(String name) 
    {
            int zl,zh,lo,gesamt;
            float gross = 0.5f*(255.0f*256.0f + 255.0f);
          
            byte[] dat = pap.loadBytes(name);

            int anz = dat.length;
          
            //double[][] y = new double[2][(anz-44)/4];                        
            //float[] y = new float[sampleanzahl];                        
            //float[] y = new float[(anz-44)/4];                        
            float[] y = new float[(anz-44)/2];                        

            int inx=44;
            
            for(int i=0;i<y.length;i++)
            {
                 zl = dat[inx++];
                 zh = dat[inx++];
                 if(zl>127)
                     zl-=256;
            
                 if(zh>127)
                     zh-=256;

                 lo     =  zl;
                 if(lo<0)
                     lo+=256;
                 gesamt = (zh+128)*256;
                
                 gesamt+=lo;
                
                 //y[0][i] = ((float)gesamt - gross)/gross;        
                 y[i] = ((float)gesamt - gross)/gross;                         
            }    
            
            return y;
    }
    
    /**
     * Shows wav-data as Java-short-Array
     */
    public void showAsShortArray(float[] wav)
    {
         PApplet.println();
         PApplet.println("private short[] data = {");
         for(int i=0;i<wav.length;i++)
         {
              if(i<wav.length-1)
                 PApplet.print((int)PApplet.round((wav[i]*32000.0f))+",");
              else   
                 PApplet.print((int)PApplet.round((wav[i]*32000.0f)));
                 
              if(i%200==0 && i>0)   
                  PApplet.println();
         }
         PApplet.println();
         PApplet.println("};");
         
    }
    
    public void ueberlappendVerketten(String quelle1, String quelle2, String ziel, int samples_ueberlappung)
    {
         float[][] q1 = ladeWav(quelle1);
         float[][] q2 = ladeWav(quelle2);
         
         float[][] z = new float[2][q1[0].length+q2[0].length-samples_ueberlappung];
         
         for(int i=0;i<q1[0].length;i++)
         {
              z[0][i] = q1[0][i];
              z[1][i] = q1[1][i];
         }
         for(int i=0;i<q2[0].length;i++)
         {
              z[0][i+q1[0].length-samples_ueberlappung] += q2[0][i];
              z[1][i+q1[1].length-samples_ueberlappung] += q2[1][i];
         }
         
         saveWav(ziel,z);         
    }
    
}
