public void setText(String text,float x, float y, float b, float h)
{
    float ts = 10.0;
    textSize(ts);
    float w = textWidth(text);
    while(w<b)
    {
        ts+=0.125;
        textSize(ts);
        w = textWidth(text);
    }
    while(w>b)
    {
        ts-=0.125;
        textSize(ts);
        w = textWidth(text);
    }
    
    
    float hb_soll = h;//Höhe eines Buchstabens
    float hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
    
    while(hb_ist>hb_soll)
    {
        ts-=0.125;
        textSize(ts);
        hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
    }
    
    text(text,x,y+h);
}

public class RastertextRahmen
{
     private Rastertext rt;
     public RastertextRahmen(float x, float y, float b, float h, int zeilen, int spalten)
     {
         rt = new Rastertext(x+0.1*b,y+0.1*h,0.8*b,0.8*h,zeilen,spalten);
     }
     public void setText(String text, int xx, int yy)
     {
          rt.setText(text,xx,yy);
     }
     public void zeigeRaster()
     {
         rt.zeigeRaster();
     }     
}
public class Rastertext
{
     float INK = 0.1f;
  
     float ts = 10.0;
     float x,y,b,h,bb,hh; //bb,hh=Buchstabenmaße
     int zeilen,spalten;
     public Rastertext(float x, float y, float b, float h, int zeilen, int spalten)
     {
         this.x=x;
         this.y=y;
         this.b=b;
         this.h=h;
         
         this.bb = b/(float)spalten;
         this.hh = h/(float)zeilen;
         
         this.zeilen = zeilen;
         this.spalten = spalten;
         
         this.INK = hh*0.01;  //Inkrement gröber bei großen Buchstaben!
         
         StringBuffer sb = new StringBuffer();
         for(int i=0;i<spalten;i++)
             sb.append("M");
         String text = sb.toString();
         
         textSize(ts);
         float w = textWidth(text);
         while(w<b)
         {
             ts+=INK;
             textSize(ts);
             w = textWidth(text);
         }
         while(w>b)
         {
             ts-=INK;
             textSize(ts);
             w = textWidth(text);
         }
         
         float hb_soll = h/(float)zeilen;//Höhe eines Buchstabens
         float hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
    
         while(hb_ist>hb_soll)
         {
             ts-=INK;
             textSize(ts);
             hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
         }
     }
     
     public void setText(String text, int xx, int yy)
     {
          textSize(ts);
          text(text,x+(float)xx*bb,y+0.9*hh+(float)yy*hh);
     }

     
     public void setTextColor(String text, int xx, int yy)
     {
          textSize(ts);
          
          for(int i=0;i<text.length();i++)
          {
               String s = text.substring(i,i+1);
               String sn = "x";
               if(i<text.length()-1)
                  sn = text.substring(i+1,i+2);
               if(sn.equals(" "))
                  sn="∙";
               if(i==text.length()-1 && text.substring(i-1,i).equals("∙"))   
                  sn="∙";
               if(i==text.length()-2 && text.substring(i-1,i).equals("∙"))   
                  sn="∙";
               if(i==text.length()-2 && text.substring(i-1,i).equals("("))   
                  sn="∙";
                  
               if(i>5 && s.equals("2") && sn.equals("∙"))
                   fill(0,0,255);
               else if(i>5 && s.equals("3") && sn.equals("∙"))
                   fill(255,0,0);
               else if(i>5 && s.equals("5") && sn.equals("∙"))
                   fill(0,255,0);
               else if(i>5 && s.equals("7") && sn.equals("∙"))
                   fill(255,255,0);
               else
                   fill(255);
               text(s,x+(float)xx*bb +0.5*bb*(float)i ,y+0.9*hh+(float)yy*hh);
          }
          
     }

     public void setTextColorFreq(String text, int xx, int yy)
     {
          textSize(ts);
          
          for(int i=0;i<text.length();i++)
          {
               String s = text.substring(i,i+1);
               String sn = "x";
               if(i<text.length()-1)
                  sn = text.substring(i+1,i+2);
               if(sn.equals(" "))
                  sn="∙";
               if(i==text.length()-1 && text.substring(i-1,i).equals("∙"))   
                  sn="∙";
               if(i==text.length()-2 && text.substring(i-1,i).equals("∙"))   
                  sn="∙";
               if(i==text.length()-2 && text.substring(i-1,i).equals("("))   
                  sn="∙";

               if(text.length()<8)
                   sn="x";
                  
               if(s.equals("2") && sn.equals("∙"))
                   fill(0,0,255);
               else if(s.equals("3") && sn.equals("∙"))
                   fill(255,0,0);
               else if(s.equals("5") && sn.equals("∙"))
                   fill(0,255,0);
               else if(s.equals("7") && sn.equals("∙"))
                   fill(255,255,0);
               else
                   fill(255);
               text(s,x+(float)xx*bb +0.5*bb*(float)i ,y+0.9*hh+(float)yy*hh);
          }
          
     }
     
     public void setTextColorTon(String text, int xx, int yy)
     {
          textSize(ts);
          
          for(int i=0;i<text.length();i++)
          {
               String s = text.substring(i,i+1);
               String sn = "x";
               if(i<text.length()-1)
                  sn = text.substring(i+1,i+2);
               if(sn.equals(" "))
                  sn="∙";
               if(i==text.length()-1 && i>0 && text.substring(i-1,i).equals("∙"))   
                  sn="∙";
               if(i==text.length()-2 && text.substring(i-1,i).equals("∙"))   
                  sn="∙";
               if(i==text.length()-2 && text.substring(i-1,i).equals("("))   
                  sn="∙";

               if(!text.contains("∙"))
                   sn="x";
                  
               if(s.equals("2") && sn.equals("∙"))
                   fill(0,0,255);
               else if(s.equals("3") && sn.equals("∙"))
                   fill(255,0,0);
               else if(s.equals("5") && sn.equals("∙"))
                   fill(0,255,0);
               else if(s.equals("7") && sn.equals("∙"))
                   fill(255,255,0);
               else
                   fill(255);
               text(s,x+(float)xx*bb +0.5*bb*(float)i ,y+0.9*hh+(float)yy*hh);
          }
          
     }
     
     public void zeigeRaster()
     {
          noFill();
          stroke(0,255,0);
          for(int i=0;i<zeilen;i++)
          {
              for(int k=0;k<spalten;k++)
              {
                  rect(x+(float)k*bb,y+(float)i*hh,bb,hh);
              }
          }
     }
}


  public double midi2Frequency(double midi)
  {
        if(midi<1.0)
            return 0.0; //Nullereignisse behandeln
  
        double freq69 = Math.pow(2.0,69.0/12.0);
        return Math.pow(2.0,midi/12.0)*440.0/freq69;
  }

  public double frequency2Midi(double freq)
  {
        if(freq<1.0)
             return 0.0; //Nullereignisse behandeln
  
        double freq69 = Math.pow(2.0,69.0/12.0);
        return 12.0*Math.log(freq*freq69/440.0)/Math.log(2.0);
  }

  public int freq2mid(int freq)
  {
    if(freq==0)
        return 0;
    else
        return (int)Math.round(frequency2Midi((double)freq));
  }

  public int mid2freq(int mid)
  {
      if(mid==0)
          return 0;
      else
          return (int)Math.round(midi2Frequency((double)mid));
  }

  public int[] holeSpalteAlsZeileAusMatrix(int[][] mat, int spalte_nr)
  {
        int[] z = new int[mat.length];
        for(int i=0;i<mat.length;i++)
            z[i] = mat[i][spalte_nr];
        return z;    
  }
  
 
