import javax.sound.sampled.*;
import java.nio.ByteBuffer;

public class Sound implements iSound
{
    //private AudioTrack audioTrack; //Connection to sound card
    
    SourceDataLine line;
    TargetDataLine targetLine;  //Mikrofon
    DataLine.Info info;
    DataLine.Info targetInfo;  //Mikrofon
    
    AudioFormat format;
    
    private int sr=44100; //Sample rate
    private int buffsize=512; //buffer size
    private int BYTEPUFFERGROESSE = buffsize*4;    
    private byte[]  bytepuffer = new byte[BYTEPUFFERGROESSE];
    private byte[] targetData = new byte[BYTEPUFFERGROESSE];
    
    public Sound()
    {
      
      
        this.format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED,(float)sr, 16, 2, 4, (float)sr, false);
        this.info = new DataLine.Info(SourceDataLine.class, format);
//Hier anderes Format ev.:        
        this.targetInfo = new DataLine.Info(TargetDataLine.class, format);
        if (!AudioSystem.isLineSupported(info))
        {
         System.out.println("Line matching " + info + " is not supported.");
         //throw new LineUnavailableException();
        }
        //format = new AudioFormat(SAMPLERATE, 16, 2, true, true);
        try
        {
            this.targetLine = (TargetDataLine) AudioSystem.getLine(targetInfo);
            this.targetLine.open(format);
            this.targetLine.start();            
            
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(format,BYTEPUFFERGROESSE);  
            this.line.start();
        }
        catch(Exception ee)
        {
            System.out.println("FEHLER: "+ee);
        }                             
        
    }
    
    public void write(short[] shortpuffer)
    {
        for (int i=0; i < buffsize; i++) 
        {
            bytepuffer[i*4+1] = (byte)(shortpuffer[i*2+0]>>8);
            bytepuffer[i*4+0] = (byte)(shortpuffer[i*2+0] & 0xFF); 
            bytepuffer[i*4+3] = (byte)(shortpuffer[i*2+1]>>8);
            bytepuffer[i*4+2] = (byte)(shortpuffer[i*2+1] & 0xFF);                     
        }            
        targetLine.read(targetData, 0, targetData.length);
        line.write(bytepuffer, 0, BYTEPUFFERGROESSE);        
    }    
}
