//Shortest program to just play two sinus waves with Android


/*
import android.media.AudioTrack;
import android.media.AudioFormat;
import android.media.AudioManager;

import android.media.AudioRecord;
import android.media.MediaRecorder;
*/

public class Welle implements Runnable
{
    private ScheduledExecutorService schedExecService; //realtime process    
    private int buffsize=512; //buffer size
    private int sr=44100; //Sample rate
    private int buffsize2=buffsize*2;
    private short[] shortbuffer = new short[buffsize*2]; //stereo buffer l0 r0 l1 r1 l2 r2 ... frequently sent to sound card
    private double t=0.0; //realtime
    private double dt = 1.0/(double)sr; //time step according to sampling rate.
    private float MAX_SHORT = 32767.0;
    iSound sound;
    public Welle()
    {
        sound = new Sound();
        schedExecService = Executors.newSingleThreadScheduledExecutor();
        long period = (buffsize*1000)/sr; //Seconds per Beat==60/BPM, die Hälfte weil 8tel, mal 1000 weil Millisekunden.
        schedExecService.scheduleAtFixedRate(this, 0, period, TimeUnit.MILLISECONDS);
    }
    
    
    public void run()
    {
        for(int i=0;i<buffsize2;i+=2)
        {
             //This may be the part of the programm where you might want to modify something like
             //introducing other sound sources / directional sound and so on:
             float left  = MAX_SHORT*sin(TWO_PI*440.0*(float)t);
             float right = MAX_SHORT*sin(TWO_PI*770.0*(float)t);
             shortbuffer[i]=(short)left;
             shortbuffer[i+1]=(short)right;
             t+=dt; //increment of realtime for each sample
        }
      
        //write(shortbuffer, 0,buffsize2);      
        sound.write(shortbuffer);      
    }
}



public class AudioWav implements Runnable
{
    int MIDIMIN = 48;
    int MIDIMAX = 60;
    String NAME = "ton";
    
    private ScheduledExecutorService schedExecService; //realtime process    
    private int buffsize=512; //buffer size
    private int sr=44100; //Sample rate
    private int buffsize2=buffsize*2;
    private short[] shortbuffer = new short[buffsize*2]; //stereo buffer l0 r0 l1 r1 l2 r2 ... frequently sent to sound card
    private double t=0.0; //realtime
    private double dt = 1.0/(double)sr; //time step according to sampling rate.
    private float MAX_SHORT = 32767.0;
    iSound sound;
    
    float[][][] ton;
    
    public AudioWav(PApplet pap)
    {
        Wav wav = new Wav(pap);

        println("Lade wavfiles");
        ton = new float[MIDIMAX-MIDIMIN+1][][];
        for(int i=0;i<ton.length;i++)  //ladeWavGEKUERZT(String name,int ANZAHL_SAMPLES, int AUSKLANG_SAMPLES, float VERST);
        {
          if( (i+MIDIMIN)<55 )
               ton[i] = wav.ladeWavGEKUERZT(NAME+(i+MIDIMIN)+".wav",3*44100, 5000, 5000.0);
          else     
               ton[i] = wav.ladeWavGEKUERZT(NAME+(i+MIDIMIN)+".wav",3*44100, 5000, 15000.0);
        }    
//            ton[i] = wav.ladeWav("va_ton"+(i+48)+".wav");
        println("Lade wavfiles fertig");
        println("ton[0][0].length="+ton[0][0].length);
        println("ton[0][1].length="+ton[0][1].length);
      
        sound = new Sound();
        schedExecService = Executors.newSingleThreadScheduledExecutor();
        long period = (buffsize*1000)/sr; //Seconds per Beat==60/BPM, die Hälfte weil 8tel, mal 1000 weil Millisekunden.
        schedExecService.scheduleAtFixedRate(this, 0, period, TimeUnit.MILLISECONDS);
    }

    //ArrayList<int[]> toplay = new ArrayList<int[]>();  // ton index, index aktuell, max-index
    int[][] toplay = new int[10][3];
    int tox = 0;
    public void play(int midi)
    {
        if(toplay[tox][1]!=toplay[tox][2])
            return;
      
        while(midi<MIDIMIN)
            midi+=12;
        while(midi>MIDIMAX)
            midi-=12;
        toplay[tox][0]=midi-MIDIMIN;
        toplay[tox][1]=0;
        toplay[tox][2]=ton[midi-MIDIMIN][0].length;
        tox++;
        tox%=toplay.length;
    }
    public void run()
    {
        for(int i=0;i<buffsize2;i+=2)
        {
             //This may be the part of the programm where you might want to modify something like
             //introducing other sound sources / directional sound and so on:
             float left  = 0;
             float right = 0;

             for(int k=0;k<toplay.length;k++)
             {
                  if(toplay[k][1]<toplay[k][2])
                  {
                        left += ton[toplay[k][0]][0][toplay[k][1]];
                        right += ton[toplay[k][0]][1][toplay[k][1]];
                    
                        toplay[k][1]++;
                  }
             }
//             left  = MAX_SHORT*sin(TWO_PI*440.0*(float)t);
//             right = MAX_SHORT*sin(TWO_PI*770.0*(float)t);

             
             shortbuffer[i]=(short)left;
             shortbuffer[i+1]=(short)right;
             t+=dt; //increment of realtime for each sample
        }
      
        //write(shortbuffer, 0,buffsize2);      
        sound.write(shortbuffer);      
    }
}
