public void setText(String text,float x, float y, float b, float h)
{
    float ts = 10.0;
    textSize(ts);
    float w = textWidth(text);
    while(w<b)
    {
        ts+=0.125;
        textSize(ts);
        w = textWidth(text);
    }
    while(w>b)
    {
        ts-=0.125;
        textSize(ts);
        w = textWidth(text);
    }
    
    
    float hb_soll = h;//Höhe eines Buchstabens
    float hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
    
    while(hb_ist>hb_soll)
    {
        ts-=0.125;
        textSize(ts);
        hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
    }
    
    text(text,x,y+h);
}

public class RastertextRahmen
{
     private Rastertext rt;
     public RastertextRahmen(float x, float y, float b, float h, int zeilen, int spalten)
     {
         rt = new Rastertext(x+0.1*b,y+0.1*h,0.8*b,0.8*h,zeilen,spalten);
     }
     public void setText(String text, int xx, int yy)
     {
          rt.setText(text,xx,yy);
     }
     public void zeigeRaster()
     {
         rt.zeigeRaster();
     }     
}
public class Rastertext
{
     float INK = 0.1f;
  
     float ts = 10.0;
     float x,y,b,h,bb,hh; //bb,hh=Buchstabenmaße
     int zeilen,spalten;
     public Rastertext(float x, float y, float b, float h, int zeilen, int spalten)
     {
         this.x=x;
         this.y=y;
         this.b=b;
         this.h=h;
         
         this.bb = b/(float)spalten;
         this.hh = h/(float)zeilen;
         
         this.zeilen = zeilen;
         this.spalten = spalten;
         
         this.INK = hh*0.01;  //Inkrement gröber bei großen Buchstaben!
         
         StringBuffer sb = new StringBuffer();
         for(int i=0;i<spalten;i++)
             sb.append("M");
         String text = sb.toString();
         
         textSize(ts);
         float w = textWidth(text);
         while(w<b)
         {
             ts+=INK;
             textSize(ts);
             w = textWidth(text);
         }
         while(w>b)
         {
             ts-=INK;
             textSize(ts);
             w = textWidth(text);
         }
         
         float hb_soll = h/(float)zeilen;//Höhe eines Buchstabens
         float hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
    
         while(hb_ist>hb_soll)
         {
             ts-=INK;
             textSize(ts);
             hb_ist  = (4.0/3.0)*(textWidth(text)/(float)text.length());
         }
     }
     
     public void setText(String text, int xx, int yy)
     {
          textSize(ts);
          text(text,x+(float)xx*bb,y+0.9*hh+(float)yy*hh);
     }
     
     public void zeigeRaster()
     {
          noFill();
          stroke(0,255,0);
          for(int i=0;i<zeilen;i++)
          {
              for(int k=0;k<spalten;k++)
              {
                  rect(x+(float)k*bb,y+(float)i*hh,bb,hh);
              }
          }
     }
}
