import java.util.*;

class Evoopt
{
        public int generation_nr=0;

        private Random zufallszahl=null;


        public int ANZAHL_DNA    = 100;   //Anzahl der Individuen innerhalb einer Generation
        public int ANZAHL_BESTE  =  10;   //Anzahl der Besten einer Generation, die in die nchste Generation bernommen werden.
        private int PANZ=2;
        private int BITANZAHL=8; //..der Parameter

        private int MUTATIONSRATE=800; //..der Parameter 0..1000

        public  double[]  fehler    = new double[ANZAHL_DNA];   //Merker fr die Fehler einer Generation

        public  int[]    psatz      = new int[ANZAHL_DNA*BITANZAHL*PANZ];    //Merker der Parameterstze einer Generation, 8-Bit-Werte, pro Bit ein Integerwert
        private int[]    psatzbest  = new int[ANZAHL_BESTE*BITANZAHL*PANZ]; //Merker der Parameterstze der Besten einer Generation

        private int[]    bestindex  = new int[ANZAHL_BESTE];    //Merker fr die Indices der ANZAHL_BESTE Besten einer Generation
        private double[] bestfehler = new double[ANZAHL_BESTE]; //Merker fr den Fehler bei den Besten.
        private double[] unterboten = new double[ANZAHL_BESTE]; //Differenz der Besten zu aktuell untersuchtem Fehler
        

        private ZahlenpaarRaten zahlenpaarraten=null;

        //Allerbesten in folgenden Werten merken:
        public int[] psatz_allerbest = new int[PANZ];
        public double fehler_minimal=Double.MAX_VALUE;
        public int index_allerbest=0;

        public void zeigeAlles()
        {
            System.out.println("Generation:"+generation_nr);
            System.out.println("Parameter:");
            for(int i=0;i<ANZAHL_DNA;i++)
            {
                System.out.print(" [");
                for(int k=0;k<PANZ;k++)
                {
                    System.out.print(integerAusBitfolge(psatz,i*PANZ*BITANZAHL+k*BITANZAHL)+" ");
                }
                System.out.print("] ");
            }
            System.out.println();
            System.out.println("Beste Parameter mit ihren jeweiligen Fehlern:");
            for(int i=0;i<ANZAHL_BESTE;i++)
            {
                System.out.print(" [");
                for(int k=0;k<PANZ;k++)
                {
                    System.out.print(integerAusBitfolge(psatz,bestindex[i]*PANZ*BITANZAHL+k*BITANZAHL)+" ");
                }
                System.out.print(" f="+bestfehler[i]);
                System.out.print("] ");
            }
            System.out.println();                            
            System.out.print("Bester Fehler:"+fehler_minimal+" bei: ");
            for(int k=0;k<psatz_allerbest.length;k++)
                System.out.print(psatz_allerbest[k]+" ");
            System.out.println();                            
        }
     
        public int zufall(int von, int bis) //geschlossenes Intervall von..bis als Zufallszahl
        {            
            return zufallszahl.nextInt(bis-von+1)+von;        
        }

        private int integerAusBitfolge(int[] x, int von)
        {
            int faktor = 1;
            int ergebnis = 0;
            for(int i=von+BITANZAHL-1;i>=von;i--)
            {
                if(x[i]==1)
                    ergebnis+=faktor;
                faktor*=2;                    
            }
            return ergebnis;
        }

        public Evoopt(ZahlenpaarRaten zahlenpaarraten)
        {
            zufallszahl = new Random(0);
            this.zahlenpaarraten = zahlenpaarraten;            
        }

        public void extrahiereAllerbesten()
        {
           index_allerbest = bestindex[0];
           fehler_minimal  = bestfehler[0];
           for(int i=0;i<ANZAHL_BESTE;i++)
           {
               if(bestfehler[i]<fehler_minimal)
               {
                   index_allerbest = bestindex[i];
                   fehler_minimal  = bestfehler[i];                   
               }
           }        
           
           for(int i=0;i<PANZ;i++)
              psatz_allerbest[i] = integerAusBitfolge(psatz,index_allerbest*PANZ*BITANZAHL + i*BITANZAHL);
        }
       
        void rekombinieren(int index_quelle1, int index_quelle2, int index_ziel)
        {
            for(int paramnr=0;paramnr<PANZ;paramnr++)
            {
                for(int bits=0;bits<BITANZAHL;bits++)
                {
                    if(zufall(0,1000)>500)
                        psatz[index_ziel*PANZ*BITANZAHL+BITANZAHL*paramnr+bits] = 
                        psatz[index_quelle1*PANZ*BITANZAHL+BITANZAHL*paramnr+bits];                                    
                    else                        
                        psatz[index_ziel*PANZ*BITANZAHL+BITANZAHL*paramnr+bits] = 
                        psatz[index_quelle2*PANZ*BITANZAHL+BITANZAHL*paramnr+bits];                                    
                }        
            }            
        }
         
        public void mutieren(int index_ziel)
        {
            for(int paramnr=0;paramnr<PANZ;paramnr++)
            {
                for(int bits=0;bits<BITANZAHL;bits++)
                {
                    if(zufall(0,1000)<MUTATIONSRATE)
                    
                        if(psatz[index_ziel*PANZ*BITANZAHL+BITANZAHL*paramnr+bits]==0)
                            psatz[index_ziel*PANZ*BITANZAHL+BITANZAHL*paramnr+bits]=1;
                        else                            
                            psatz[index_ziel*PANZ*BITANZAHL+BITANZAHL*paramnr+bits]=0;
                }        
            }            
        }         
         
        void erzeugeNeueGeneration()
        {
            if(generation_nr==0)
            {
                for(int i=0;i<psatz.length;i++) //Parameterstze zufllig erzeugen.
                    psatz[i] = zufall(0,1);
            }
            else
            {
                for(int i=0;i<ANZAHL_DNA;i++) //Aktuelle Fehler aller Parameterstze bestimmen
                {
                    int x = integerAusBitfolge(psatz, i*PANZ*BITANZAHL);                
                    int y = integerAusBitfolge(psatz, i*PANZ*BITANZAHL+BITANZAHL);                
                    fehler[i] = zahlenpaarraten.berechneFehler(new int[]{x,y});
                }

                for(int i=0;i<ANZAHL_BESTE;i++) //Pltze mit beliebigen besetzt, einfach die ersten nehmen.
                {
                    bestindex[i] = i;
                    bestfehler[i] = fehler[i];
                }


//Verworfen, da es nicht garantiert die Besten findet.
/*
                for(int i=0;i<ANZAHL_DNA;i++) //Immer besseren an ersten Platz, andere rcken eins weiter, letzter fllt von der Bank
                {
                    if( fehler[i]<bestfehler[0] )
                    {
                        for(int k=ANZAHL_BESTE-1;k>=1;k--)
                        {
                            bestindex[k] = bestindex[k-1];
                            bestfehler[k] = fehler[k-1];
                        }                             
                        bestindex[0] = i;
                        bestfehler[0] = fehler[i];   
                    }                
                }                 

*/
                
                //Besseres Vorgehen:
                //Immer den Wert berschreiben, der unterboten wird.
                //Wird keiner unterboten, dann nichts berschreiben.
                //Werden mehrere unterboten, dann denjenigen berschreiben, der
                //im geringsten Ma unterboten wird.
                for(int i=0;i<PANZ;i++)
                {
                    boolean gefunden = false; //Prfen, ob Unterbieten auftritt.
                    for(int k=0;k<ANZAHL_BESTE;k++)
                    {
                            unterboten[k] = bestfehler[k] - fehler[i];
                            if(unterboten[k]>0.0)
                                gefunden=true;
                    }                             

                    //Nur berschreiben, wenn irgendwo ein bisher bester Fehler unterboten wird:
                    if(gefunden==true)
                    {
                        int index_nehmen = 0;
                        double unterbietung = Double.MAX_VALUE;
                        for(int k=0;k<ANZAHL_BESTE;k++)
                        {
                            if(unterboten[k]>0.0 && unterboten[k]<unterbietung)
                            {
                                index_nehmen = k;
                                unterbietung = unterboten[k];
                            }                                
                        }                                    
                        //Jetzt den am geringsten unterbotenen Wert berschreiben:
                        bestindex[index_nehmen]  = i;                                     
                        bestfehler[index_nehmen] = fehler[i];                                     
                    }                    
                }                 

                for(int i=0;i<ANZAHL_DNA;i++) //Rekombination aus zwei Besten eines neuen Elementes
                {
                    boolean ist_bestes = false;
                    for(int k=0;k<ANZAHL_BESTE;k++)
                       if(i==bestindex[k])
                           ist_bestes = true;
                           
                    if(ist_bestes==false) //nur wenn es keines der Besten ist
                    {
                        //Rekombination aus zwei Besten:
                        int zufalls_index1 = zufall(0,ANZAHL_BESTE-1);
                        int index_bester1 = bestindex[zufalls_index1];
                        int zufalls_index2 = zufall(0,ANZAHL_BESTE-1);
                        int index_bester2 = bestindex[zufalls_index2];
                                                
                        rekombinieren(index_bester1,index_bester2,i);
                        
                        //Mutation:
                        mutieren(i);
                        
                    }                           
                }                
            }

            //Allerbesten extrahieren
            extrahiereAllerbesten();
            generation_nr++;
        }

        
        
        public static void main(String[] args)
        {
            ZahlenpaarRaten zahlenpaarraten = new ZahlenpaarRaten(42,13);             
            Evoopt evoopt = new Evoopt(zahlenpaarraten);   
                               
            evoopt.erzeugeNeueGeneration();
            for(int i=0;i<10;i++)
            {
              evoopt.erzeugeNeueGeneration();
              //evoopt.zeigeAlles();
              if(i%1==0)
              {
                System.out.println("Gen."+evoopt.generation_nr+" Fehler:"+evoopt.fehler_minimal
                +" x="+evoopt.psatz_allerbest[0]
                +" y="+evoopt.psatz_allerbest[1]);            
              }                
            }    
            
        }        
}

