package info.kramann.fuzzy.fuzzyset;


public class FuzzyGroesseMitte implements iFuzzygroesse
{
    private double m1,m2;
    private double x0,x1,x2;
    public FuzzyGroesseMitte(double x0, double x1, double x2)
    {
        this.x0 = x0;
        this.x1 = x1;
        this.x2 = x2;
        aktualisiereSteigungen();
    }
    public double berechneZugehoerigkeit(double x)
    {
        if(x<=x0) return 0.0;
        if(x>=x2) return 0.0;
        
        if(x<x1)
        {
            return m1*(x-x0);
        }
        else
        {
            return 1.0 + m2*(x-x1);
        }
    }
    
    private void aktualisiereSteigungen()
    {
        m1=1.0/(x1-x0);
        m2=-1.0/(x2-x1);
    }
    
    /**
     * ..macht nur Sinn, wenn die anderen Punkte bleiben.
     */
    public boolean setzePunkt(int nr, double wert)
    {
        switch(nr)
        {
            case 0:
                if(wert>=x1) return false;
                x0=wert;
                aktualisiereSteigungen();
                return true;
            case 1:
                if(wert<=x0) return false;
                if(wert>=x2) return false;
                x1=wert;
                aktualisiereSteigungen();
                return true;
            case 2:
                if(wert<=x1) return false;
                x2=wert;
                aktualisiereSteigungen();
                return true;
            default:
                return false;
        }
    }
}
