//s als Argument für ein Polynom definieren:
s = poly(0,"s"); 
//Übertragungsfunktion definieren:
//PT1-Glied: G0(s)=K/(1+Ts)
//P-Regler:  R(s)=P
//Geschlossener Reglkreis: G(s)=RG/(1+RG)
P=3.0;
K=3.0;
T=10.0;
G = syslin('c',[P*K],[1+P*K+T*s]);
//Zeitbereich für die Simulation festlegen:
t=[0:0.1:50]; 
u=sin(t);
y=csim(u,t,G); 
plot(t,u,'blu--',t,y,'gre');
xtitle("Untersuchung der dynamischen Stabilität zu G(s) ")
a = gca();
a.x_label.text = 't/s';
a.y_label.text = 'u(t),y(t)';
a.title.text = 'Untersuchung der dynamischen Stabilität bei P-Regler für PT1';
hl=legend(['u(t)';'y(t)'],a=1);