a = 34520;
b = 83;
c = 1303;

//   (s^3 + b*s^2 + c*s)*PHI = a*U
//   G(s) = PHI/U = a / (s^3 + b*s^2 + c*s)

//


s = poly(0,"s");
G = syslin('c',[a],[s*s*s + b*s*s + c*s]);
strecke=tf2ss(G)
clean(ss2tf(strecke))
Astrecke = strecke(2)//A-Matrix auslesen
ewStrecke = spec(Astrecke)
//plzr(G)


A = [0,1,0;0,0,1;0,-c,-b];
B = [0;0;a];

s2 = -b/2 + sqrt(-c+b*b/4)
s3 = -b/2 - sqrt(-c+b*b/4)

ew = [s2+%i*s2,s2-%i*s2,s3];

R = ppol(A,B,ew);

//Ergebnis:
//R = [1.5871842,    0.0633561,    0.0006090]

Astern = A - B*R;
ew_stern = spec(Astern);
disp(ew_stern);

//Letzter Schritt:
//Testweise Simulation des Systems im Zeitbereich und
//Durchführen des gleichen Experiments, das zur Identifikation
//des Systems geführt hat:

function f = rechteSeite(t,y)
    phi   = y(1,1); //zur Info
    omega = y(2,1);
    alfa  = y(3,1);

    A = [0,1,0;0,0,1;0,-c,-b];
    B = [0;0;a];
    R = [1.5871842,    0.0633561,    0.0006090];

    f = (A-B*R)*y;
endfunction

//200Hz == 0.005s
t = 0:0.005:(1-0.005);
y0 = [-300,0,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);


//Alter Test-P-Regler:

function f = rechteSeiteALT(t,y)
    phi   = y(1,1);
    omega = y(2,1);
    alfa  = y(3,1);

    //P-Regler:
    u = 2*(0-phi);

    f(1,1) = omega;
    f(2,1) = alfa;
    f(3,1) = -b*alfa -c*omega + a*u;
endfunction

yalt  = ode(y0,t0,t,rechteSeiteALT);

plot(t,y(1,:),'blk',t,yalt(1,:),'red')

//Verlauf der Stellgroesse????
// u = -R*y

u = -R*y;

plot(t,u);







