//Answendung des gefundenen Zustandsreglers auf das ursprüngliche 
//nichtlineare System:

a = 362.51078;
b = 0.6240459;
c = 75.735496;
d = 22000.004;

R = [0.2083822  ,  0.0462607 ];

B = [0 ; a];

//Nichtlineare Rechte-Seite-Funktion
function f = rechteSeite(t,y)
    phi   = y(1,1);
    omega = y(2,1);

    //P-Regler:
//    u = 2*(0-phi);
    Bu = -B*R*y;
    Mreib = abs(d)*(  -1/(1+exp(-1000*omega))*2+1  );

    f(1,1) = omega;
    f(2,1) = -b*omega -c*phi + Mreib + Bu(2); //erste Komponente ist Null
endfunction

t = 0:0.005:(1-0.005);
y0 = [-300,0]';
t0 = 0;
y       = ode(y0,t0,t,rechteSeite);

plot(t,y(1,:),'red');
//Fazit: regelt mit nichtlinearem Mreib nicht mehr aus.
//       Zustandsregler für nichtlinearem System nicht brauchbar!


