a = 362.51078;
b = 0.6240459;
c = 75.735496;
d = 22000.004;

function f = rechteSeiteLinear(t,y)
    phi   = y(1,1);
    omega = y(2,1);

    //P-Regler:
    u = 2*(0-phi);

    f(1,1) = omega;
    f(2,1) = -b*omega -c*phi + + a*u;
endfunction

//Reines gegebenes System, ohne P-Regler:
function f = rechteSeite(t,y)
    phi   = y(1,1);
    omega = y(2,1);

    f(1,1) = omega;
    f(2,1) = -b*omega -c*phi;
endfunction


//  d omega/dt = -b*omega -c*phi + a*u
//  phi.. + b*phi. + c*phi = a*u
//
//  y = [phi, omega]
//
// | phi.   |    |  0      1  |   | phi   |   | 0 |
// |        | =  |            | * |       | + |   | * u
// | omega. |    | -c     -b  |   | omega |   | a |
//

A = [0,1;-c,-b];
ew = spec(A);
disp(ew);

B = [0;a];

// EW:
//  - 0.3120230 + 8.6970189i  
//  - 0.3120230 - 8.6970189i  

// Wunsch-EW:
//  - 8.6970189 + 8.6970189i  
//  - 8.6970189 - 8.6970189i  

R = ppol(A,B,[- 8.6970189 + 8.6970189*%i  ,- 8.6970189 - 8.6970189*%i  ]);

disp(R);

// R = [0.2083822  ,  0.0462607 ]

Astern = A - B*R;

neue_ew = spec(Astern);
disp(neue_ew);

//-------------------------------------------

//Reines gegebenes System, ohne P-Regler:
function f = rechteSeiteAstern(t,y)
     f = Astern*y;
endfunction


t = 0:0.005:(1-0.005);
y0 = [-300,0]';
t0 = 0;
y       = ode(y0,t0,t,rechteSeite);
ystern  = ode(y0,t0,t,rechteSeiteAstern);

plot(t,y(1,:),'red',t,ystern(1,:),'blu');









