//Simulationsmodell: PT3 mit P-Regler als Referenz, bzw.
//Differenz zu Meßdaten als Grundlage der Fehlerfunktion

a = 100;
b = 0.1;
c = 0.1;
d = 10000;
function f = rechteSeite(t,y)
    phi   = y(1,1);
    omega = y(2,1);

    //P-Regler:
    u = 2*(0-phi);
    Mreib = abs(d)*(  -1/(1+exp(-1000*omega))*2+1  );

    f(1,1) = omega;
    f(2,1) = -b*omega -c*phi + Mreib + a*u;
endfunction

function f = rechteSeiteLinear(t,y)
    phi   = y(1,1);
    omega = y(2,1);

    //P-Regler:
    u = 2*(0-phi);

    f(1,1) = omega;
    f(2,1) = -b*omega -c*phi + + a*u;
endfunction


//200Hz == 0.005s
t = 0:0.005:(1-0.005);
y0 = [-300,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

//plot(t,y(1,:)');




