//Simulationsmodell: PT3 mit P-Regler als Referenz, bzw.
//Differenz zu Meßdaten als Grundlage der Fehlerfunktion

a = 100;
b = 0.1;
c = 80;


function f = rechteSeite(t,y)
    phi   = y(1,1);
    omega = y(2,1);
    alfa  = y(3,1);

    //P-Regler:
    u = 2*(0-phi);

    f(1,1) = omega;
    f(2,1) = alfa;
    f(3,1) = -b*alfa -c*omega + a*u;
endfunction

//200Hz == 0.005s
t = 0:0.005:(1-0.005);
y0 = [-300,0,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

//plot(t,y(1,:)');




