clear();

xtot=0;
Kkrit = 2.25;       
Tkrit = 3.93;

K  =  0.6*Kkrit;
TN =  0.5*Tkrit;
TV =  0.12*Tkrit;

P = K;
I = K/TN;
D = K*TV;

eAlt   = 0.0;
eAkt   = 0.0;
eDiff  = 0.0;
eInteg = 0.0;

function f=modell(y,t,dt)
       x=y(1,1);
       v=y(2,1);

       xsoll = 1.0;
       //e     = xsoll - x;
       e     = xsoll - xtot;
       u = P*eAkt + I*eInteg + D*eDiff;
       
       f(1,1)=v;
       f(2,1)=-x-v+u;
endfunction

function yneu=ruku(y,t,dt)
       k1=modell(y,t,dt);
       k2=modell(y+0.5.*dt.*k1,t+0.5*dt);
       k3=modell(y+0.5.*dt.*k2,t+0.5*dt);
       k4=modell(y+dt.*k3,t+dt);
       yneu=y+dt.*(k1+2.*k2+2.*k3+k4)./6;
endfunction

tmax = 60.0;
dt   = 0.01;
schritte = ceil(tmax/dt);

yalt = [0,0]';
ysim = yalt;
t=0.0;
tt=t;

Ttot = 0.5;
anztot = round(Ttot/dt);
xtotarr = zeros(anztot);
xtotarr = zeros(50,1);


for i=1:1:schritte
    yneu=ruku(yalt,t,dt);   
    yalt=yneu;
    ysim=[ysim,yalt];
    tt  =[tt,t];
    t=t+dt;

    xtotarr(modulo((i-1),anztot)+1)=yneu(1);
    xtot = xtotarr(modulo((i-1+1),anztot)+1);

    eAkt  = 1.0 - xtot;
    eDiff = (eAkt-eAlt)/dt;
    eInteg = eInteg + eAkt*dt;
    eAlt  = eAkt;
end

plot(tt,ysim(1,:))