clear();

xtot=0;

function f=modell(y,t,dt)
       x=y(1,1);
       v=y(2,1);

       Kkrit = 2.25;       
       //xsoll = 1.0;
       xsoll = 1.0 - exp(-20*t);
       //e     = xsoll - x;
       e     = xsoll - xtot;
       u=Kkrit*e;
       
       f(1,1)=v;
       f(2,1)=-x-v+u;
endfunction

function yneu=ruku(y,t,dt)
       k1=modell(y,t,dt);
       k2=modell(y+0.5.*dt.*k1,t+0.5*dt);
       k3=modell(y+0.5.*dt.*k2,t+0.5*dt);
       k4=modell(y+dt.*k3,t+dt);
       yneu=y+dt.*(k1+2.*k2+2.*k3+k4)./6;
endfunction

tmax = 60.0;
dt   = 0.01;
schritte = ceil(tmax/dt);

yalt = [0,0]';
ysim = yalt;
t=0.0;
tt=t;

Ttot = 0.5;
anztot = round(Ttot/dt);
xtotarr = zeros(anztot);
xtotarr = zeros(50,1);

for i=1:1:schritte
    yneu=ruku(yalt,t,dt);   
    yalt=yneu;
    ysim=[ysim,yalt];
    tt  =[tt,t];
    t=t+dt;

    xtotarr(modulo((i-1),anztot)+1)=yneu(1);
    xtot = xtotarr(modulo((i-1+1),anztot)+1);
end

plot(tt,ysim(1,:))