package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

 /**
 *  <h4>SimulatorPIDgeregelterAntrieb.java  - Simulator for model PIDgeregelterAntrieb.</h4>
 *  <br/>
 *  <h4>SimulatorPIDgeregelterAntrieb.java  - Simulater fr das Modell PIDgeregelterAntrieb.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */


public class SimulatorPIDgeregelterAntrieb extends Simulator
{
    public int simulationsschritte = 500;

    /**init() dient zur Initialisierung des Simulators.<br/>
    Diese Methode solte von erbenden Klassen berschrieben werden und enthlt dann
    alles, was als Vorbereitung zur Durchfhrung von Simulationen ntig ist,
    z.B. ein Integratorobjekt und ein Modellobjekt erzeugen und mit add(..) als Referenz speichern (registrieren),
    sowie die notwendige Anzahl an Speicherpltzen fr y und t allokieren.
    */
    public void init()
    {
        PIDgeregelterAntrieb pidgeregelterantrieb = new PIDgeregelterAntrieb();
        RungeKuttaIntegrator rungekuttaintegrator = new RungeKuttaIntegrator();

        rungekuttaintegrator.add(pidgeregelterantrieb);
        add(pidgeregelterantrieb);
        add(rungekuttaintegrator);

        y=new double[simulationsschritte][];
        for(int i=0;i<simulationsschritte;i++)
            y[i] = new double[simulationsmodell.getAnzahlGleichungen()];

        x=new double[simulationsschritte][];
        for(int i=0;i<simulationsschritte;i++)
            x[i] = new double[2]; //0: Regeldifferenz e, 1: Stellgre pwm

        t=new double[simulationsschritte];
    }

    /**Simulation durchfhren*/
    public void simulieren()    
    {
        double dt = 0.001;
        t[0] = 0;
        y[0][0] = 0.0; //omega_viertel
        y[0][1] = 0.0; //alfa
        x[0][0] = ((PIDgeregelterAntrieb)simulationsmodell).omega_viertel_soll - y[0][0];
        x[0][1] = ((PIDgeregelterAntrieb)simulationsmodell).pwm_alt;
       
        for(int i=1;i<simulationsschritte;i++)
        {
            double[] referenz = integrator.zeitschritt(y[i-1],t[i-1],dt);

            y[i][0] = referenz[0];
            y[i][1] = referenz[1];

            x[i][0] = ((PIDgeregelterAntrieb)simulationsmodell).omega_viertel_soll - y[i][0];
            x[i][1] = ((PIDgeregelterAntrieb)simulationsmodell).pwm_alt;

            t[i]    = t[i-1]+dt;
        }
    }

    /**i-ten Parameter des Modells ndern*/
    public void setParameter(double param, int i)
    {
        switch(i)
        {
            case 0:
                ((PIDgeregelterAntrieb)simulationsmodell).K = param;
            break;
            case 1:
                ((PIDgeregelterAntrieb)simulationsmodell).L = param;
            break;
            case 2:
                ((PIDgeregelterAntrieb)simulationsmodell).M = param;
            break;
            case 3:
                ((PIDgeregelterAntrieb)simulationsmodell).P = param;
            break;
            case 4:
                ((PIDgeregelterAntrieb)simulationsmodell).I = param;
            break;
            case 5:
                ((PIDgeregelterAntrieb)simulationsmodell).D = param;
            break;
            case 6:
                ((PIDgeregelterAntrieb)simulationsmodell).Tt = param;
            break;
            case 7:
                ((PIDgeregelterAntrieb)simulationsmodell).omega_viertel_soll = param;
            break;
        }
    }

    /**Alle Parameter des Modells ndern*/
    public void setParameter(double[] param)
    {
        ((PIDgeregelterAntrieb)simulationsmodell).K = param[0];        
        ((PIDgeregelterAntrieb)simulationsmodell).L = param[1];        
        ((PIDgeregelterAntrieb)simulationsmodell).M = param[2];        
        ((PIDgeregelterAntrieb)simulationsmodell).P = param[3];        
        ((PIDgeregelterAntrieb)simulationsmodell).I = param[4];        
        ((PIDgeregelterAntrieb)simulationsmodell).D = param[5];        
        ((PIDgeregelterAntrieb)simulationsmodell).Tt = param[6];        
        ((PIDgeregelterAntrieb)simulationsmodell).omega_viertel_soll = param[7];        
    }

    /** paint(..) wird bei der Konsolenanwendung nicht verwendet.*/
    public void paint(Graphics2D g)
    {
    }
}
