package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

 /**
 *  <h4>Simulatorantrieb.java  - Simulator for model antrieb.</h4>
 *  <br/>
 *  <h4>Simulatorantrieb.java  - Simulater fr das Modell antrieb.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */


public class SimulatorAntrieb extends Simulator
{
    public double[] fuzzy_parameter = new double[] {0.0, 1.0/4.0, 1.0/3.0, 1.0/2.0, 1.0};

    public int simulationsschritte = 500;

    /**init() dient zur Initialisierung des Simulators.<br/>
    Diese Methode solte von erbenden Klassen berschrieben werden und enthlt dann
    alles, was als Vorbereitung zur Durchfhrung von Simulationen ntig ist,
    z.B. ein Integratorobjekt und ein Modellobjekt erzeugen und mit add(..) als Referenz speichern (registrieren),
    sowie die notwendige Anzahl an Speicherpltzen fr y und t allokieren.
    */
    public void init()
    {
        Antrieb antrieb = new Antrieb();

//ACHTUNG: K und L sind gegenber der Scilab-Musterlsung in Kaptiel 5.6 vertauscht!
        antrieb.K=1576.1789;
        antrieb.L=11542.314;
        antrieb.M=372.33722;
        antrieb.pwm = 1023.0;


        RungeKuttaIntegrator rungekuttaintegrator = new RungeKuttaIntegrator();

        rungekuttaintegrator.add(antrieb);
        add(antrieb);
        add(rungekuttaintegrator);

        y=new double[simulationsschritte][];
        for(int i=0;i<simulationsschritte;i++)
            y[i] = new double[simulationsmodell.getAnzahlGleichungen()];

        t=new double[simulationsschritte];
    }

    /**Simulation durchfhren*/
    public void simulieren()    
    {
        double dt = 0.001;
        t[0] = 0;
        y[0][0] = 0.0; //omega_viertel
        y[0][1] = 0.0; //alfa
       
        for(int i=1;i<simulationsschritte;i++)
        {
            double[] referenz = integrator.zeitschritt(y[i-1],t[i-1],dt);

            y[i][0] = referenz[0];
            y[i][1] = referenz[1];

            t[i]    = t[i-1]+dt;
        }
    }

    /**i-ten Parameter des Modells ndern*/
    public void setParameter(double param, int i)
    {
        if(param>1.0)
            fuzzy_parameter[i] = 1.0;
        else if(param<0.0)
            fuzzy_parameter[i] = 0.0;
        else
            fuzzy_parameter[i] = param;

        ((Antrieb)simulationsmodell).fuzzyregler.fes[0].verteileFuzzyGroessenNormiert(fuzzy_parameter);                
    }

    /**Alle Parameter des Modells ndern*/
    public void setParameter(double[] param)
    {
        for(int i=0;i<param.length;i++)
        {
            if(param[i]>1.0)
                fuzzy_parameter[i] = 1.0;
            else if(param[i]<0.0)
                fuzzy_parameter[i] = 0.0;
            else
                fuzzy_parameter[i] = param[i];
        }
 
        ((Antrieb)simulationsmodell).fuzzyregler.fes[0].verteileFuzzyGroessenNormiert(fuzzy_parameter);                        
    }

    /** paint(..) wird bei der Konsolenanwendung nicht verwendet.*/
    public void paint(Graphics2D g)
    {
    }
}
