package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

 /**
 *  <h4>Simulator.java  - base class for simulation.</h4>
 *  <br/>
 *  <h4>Simulator.java  - Basisklasse fr die Simulation.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */


public class Simulator
{
    public Simulationsmodell simulationsmodell;
    public Integrator integrator;

    /**Enthlt spter die Simulationsergebnisse<br/>
       y[zeile][i-ter Systemzustand]
    */
    public double[][] y = null;

    /**Enthlt spter weitere beobachtete Gren aus der Simulation,<br/>
       Beispiele: Regeldifferenz, Stellgre, etc.
       x[zeile][i-te Gre]
    */
    public double[][] x = null;

    /**Enthlt spter die Zeitleiste zu den aktuellen Simulationsergebnissen.
    */
    public double[] t = null;

    /**Sowohl der Integrator, als auch das Modell werden als Referenz gespeichert*/
    public void add(Integrator integrator)
    {
        this.integrator = integrator;
    }

    /**Sowohl der Integrator, als auch das Modell werden als Referenz gespeichert*/
    public void add(Simulationsmodell simulationsmodell)
    {
        this.simulationsmodell = simulationsmodell;
    }

    /**init() dient zur Initialisierung des Simulators.<br/>
    Diese Methode solte von erbenden Klassen berschrieben werden und enthlt dann
    alles, was als Vorbereitung zur Durchfhrung von Simulationen ntig ist,
    z.B. ein Integratorobjekt und ein Modellobjekt erzeugen und mit add(..) als Referenz speichern (registrieren),
    sowie die notwendige Anzahl an Speicherpltzen fr y und t allokieren.
    */
    public void init()
    {
    }

    /**Simulation durchfhren, wird von erbenden Klassen berschrieben.*/
    public void simulieren()    
    {
    }

    /**i-ten Parameter des Modells ndern, wird von erbenden Klassen berschrieben*/
    public void setParameter(double param, int i)
    {
    }

    /**Alle Parameter des Modells ndern, wird von erbenden Klassen berschrieben*/
    public void setParameter(double[] param)
    {
    }

    /**i-ten Vektor mit dem Systemzustand der letzten Simulation holen*/
    public double[] getY(int i)
    {
        return 
            y[i];
    }

    /**Alle Vektoren mit den Systemzustnden der letzten Simulation holen*/
    public double[][] getY()
    {
        return 
            y;
    }

    /**i-ten Vektor mit der beobachteten Gre der letzten Simulation holen*/
    public double[] getX(int i)
    {
        return 
            x[i];
    }

    /**Alle Vektoren mit den beobachteten Gren der letzten Simulation holen*/
    public double[][] getX()
    {
        return 
            x;
    }

    /**i-ten Zeitwert der letzten Simulation holen*/
    public double getT(int i)
    {
        return 
            t[i];
    }

    /**Alle Zeitwerte der letzten Simulation holen*/
    public double[] getT()
    {
        return 
            t;
    }

    /**Holt die Anzahl der Simulationswerte*/
    public int getAnzahl()
    {
        return 
            t.length;
    }

    /** Ein Simulator kann durch berschreiben der Methode paint() in die Lage
    versetzt werden, seinen aktuellen Zustand grafisch darzustellen.<br/>
    Die Methode wird von der paint-Methode eines Canvas-Objekts her aufgerufen.
    */
    public void paint(Graphics2D g)
    {
    }

}
