package opti;
import java.awt.*;

 /**
 *  <h4>Simulationsmodell.java  - base class for simulation-models discribed as differential-equation-systems.</h4>
 *  <br/>
 *  <h4>Simulationsmodell.java  - Basisklasse fr Simulationsmodelle, die als Differentialgleichungssystem beschrieben werden knnen.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

public class Simulationsmodell
{

    /**Der aktuelle Steigung wird im Array f gespeichert.*/
    public double[]   f = null;

    /**
       anzahlgleichungen: Anzahl der Simulationsgleichungen im DGLS ersten Grades.
    */
    public Simulationsmodell(int anzahlgleichungen)
    {
        f = new double[anzahlgleichungen];        
    }

    public int getAnzahlGleichungen()
    {
        return f.length;
    }

    /**Die folgende Berechnungsmethode mu von erbenden
    Klassen berschrieben werden.<br/>
    i bezeichnet die Gleichungsnummer, deren Steigung gerade vom Integrator gebraucht wird.
    */
    public double[] berechneRechteSeite(double[] yalt, double t)
    {
        return f;
    } 

    /** Das Modell kann durch berschreiben der Methode paint() in die Lage
    versetzt werden, seinen aktuellen Systemzustand grafisch darzustellen.<br/>
    Die Methode wird von der paint-Methode eines Canvas-Objekts her aufgerufen.
    */
    public void paint(Graphics2D g)
    {
    }
}