package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

 /**
 *  <h4>RungeKuttaIntegrator.java  - A class for numerical integration with Runge-Kutta-algorithm.</h4>
 *  <br/>
 *  <h4>RungeKuttaIntegrator.java  - Klasse fr die numerische Integration unter Verwendung des Runge-Kutta-Verfahrens.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

public class RungeKuttaIntegrator extends Integrator
{
    private double[] yhilf = null;
    private double[] k1=null,k2=null,k3=null,k4=null;
    private double[] k; //Hilfsreferenz, um Berechnungsergebnisse vom Modell zu speichern.

    public void add(Simulationsmodell simulationsmodell)
    {
        this.simulationsmodell = simulationsmodell;
        yneu  = new double[simulationsmodell.getAnzahlGleichungen()];
        yhilf = new double[simulationsmodell.getAnzahlGleichungen()];
        k1 = new double[simulationsmodell.getAnzahlGleichungen()]; 
        k2 = new double[simulationsmodell.getAnzahlGleichungen()]; 
        k3 = new double[simulationsmodell.getAnzahlGleichungen()]; 
        k4 = new double[simulationsmodell.getAnzahlGleichungen()];     
    }

    public double[] zeitschritt(double[] yalt,double t,double dt)
    {
        /**
        Erst nach der Registrierung des Modells mit add(..) ist der Integrator funktionstchtig.
        */
        if(simulationsmodell==null)
            return null;

        k = simulationsmodell.berechneRechteSeite(yalt,t);
        for(int i=0;i<simulationsmodell.getAnzahlGleichungen();i++)
        {
            k1[i] = k[i];
            yhilf[i] = yalt[i] + 0.5*dt*k1[i];
        }                
        k = simulationsmodell.berechneRechteSeite(yhilf,t);
        for(int i=0;i<simulationsmodell.getAnzahlGleichungen();i++)
        {
            k2[i] = k[i];
            yhilf[i] = yalt[i] + 0.5*dt*k2[i];
        }                
        k = simulationsmodell.berechneRechteSeite(yhilf,t);
        for(int i=0;i<simulationsmodell.getAnzahlGleichungen();i++)
        {
            k3[i] = k[i];
            yhilf[i] = yalt[i] + dt*k3[i];
        }                
        k = simulationsmodell.berechneRechteSeite(yhilf,t);
        for(int i=0;i<simulationsmodell.getAnzahlGleichungen();i++)
        {
            k4[i] = k[i];
        }                
        for(int i=0;i<simulationsmodell.getAnzahlGleichungen();i++)
        {
            yneu[i] = yalt[i] + (dt/6.0)*(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i]);
        }                

        return yneu;
    }     

    /** paint(..) wird bei der Konsolenanwendung nicht verwendet.*/
    public void paint(Graphics2D g)
    {
    }
}
