package opti;
import java.awt.*;

 /**
 *  <h4>PIDgeregelterAntrieb.java  - simulation-model of an electro-car with PID-control.</h4>
 *  <br/>
 *  <h4>PIDgeregelterAntrieb.java  - Simulationsmodell eines PID-geregelten Elektroantriebs.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

public class PIDgeregelterAntrieb extends Simulationsmodell
{
    /**
    Die folgenden Variablen sind die Modellparameter, die spter
    optimiert werden knnen.<br/>
    Als Startwert sind die zu erwartenden Extremwerte eingestellt, damit
    spter automatisiert GUI-Elemente erzeugt werden knnen.<br/>
    Da positive Extremwerte vorgegeben sind, ist damit festgelegt, dass
    alle Modell-Parameter nicht negativ werden drfen.
    */
    public double K = 100000.0;
    public double L = 100000.0;
    public double M = 100000.0;

    /**
    Die folgenden Variablen sind die Parameter des PID-Reglers, die spter
    ebenfalls optimiert werden knnen.<br/>
    Als Startwert sind die zu erwartenden Extremwerte eingestellt, damit
    spter automatisiert GUI-Elemente erzeugt werden knnen.<br/>
    Da positive Extremwerte vorgegeben sind, ist damit festgelegt, dass
    alle Modell-Parameter nicht negativ werden drfen.<br/>
    Fr die Parameteridentifikation des Modells (Bestimmung von K,L und M)
    knnen die Parameter des Reglers (P, I, D) zunchst zu Null gesetzt werden.<br/>
    Fr die Identifikation der Regelstrecke wird zunchst die Totzeit Tt zu Null gesetzt.<br/>
    In einem ersten Ansatz fr die Identifikation der Regelparameter wird Tt auf 0,01s gesetzt.
    */
    public double P = 1000.0;
    public double I = 10.0; //Faktor 0.01, da Tt=0.01s mit enthalten
    public double D = 100000.0; //Faktor 100, da 1/Tt=100.0 1/s enthalten

    public double Tt = 0.01;

    /**Sollwert fr den Regler:*/
    public double omega_viertel_soll = 100.0;

    /**
    Bei jeder Aktualisierung des Stellwertes wird der Zeitpunkt registriert.<br/>
    Eine neue Aktualisierung findet erst statt, 
    wenn seit dem ein Zeitintervall von der Dauer der Totzeit Tt vergangen ist.<br/>
    Um eine konsistente Simulation zu gewhrleisten, wird vorausgesetzt, dass eine
    neue Simulation immer bei t=0s startet.
    */
    private double t_aktualisiert = 0.0;
    private double e_alt = 0.0; //Alte Regeldifferenz.
    private double e_sum = 0.0; //Aufsummierte Regeldifferenz.
    public  double pwm_alt = 0.0; //gemerkte Stellgre, bleibt bis zur nchsten Aktualisierung erhalten.

    public PIDgeregelterAntrieb()
    {
        super(2); //Zwei Simulationsgleichungen
    }

    public double[] berechneRechteSeite(double[] yalt, double t)
    {
        /**temporre Variablen deklarieren:<br/>
           Die verwendete Zustandsgre omega_viertel (y[0]) hat die Einheit Omega/4, 
           d.h. die tatschliche Winkelgeschwindigkeit kann zu omega = 4*omega_viertel bestimmt werden.<br/>
           Damit werden genau die im Mikrocontrollerprogramm verfgbaren Gren simuliert.
        */
        double e             = e_alt;   //Regeldifferenz
        double pwm           = pwm_alt; //Stellgre -1023..+1023, entspricht u im Standardregelkreis.
        double omega_viertel = yalt[0]; //fr eine bessere Lesbarkeit 
        double v             = yalt[1]; //fr eine bessere Lesbarkeit
      

        /**Notwendige Initialisierungen bei Start einer neuen Simulation durchfhren.*/
        if(t==0.0)
        {
            t_aktualisiert = 0.0;
            e       = 0.0;
            e_alt   = 0.0;      
            e_sum   = 0.0;
            pwm     = 0.0;
            pwm_alt = 0.0;
        }
        /**Bedingungen fr die Aktualisierung der Stellgre.*/
        if(t==0.0 || t_aktualisiert+Tt<=t)
        {
            e = omega_viertel_soll - omega_viertel;

            pwm = P*e + I*e_sum + D*(e-e_alt);

            t_aktualisiert=t;  //Merken dieses neuen Aktualisierungszeitpunktes.
            e_alt = e;         //Merken der neuen aktuellen Regeldifferenz fr D-Anteil          
            e_sum += e;        //Aktualisierung der Summe der Regeldifferenzen fr I-Anteil 
            pwm_alt =  pwm;    //Merken/Aktualisierung der Stellgre
        } 

        /**Eigentliche Bestimmung der rechten Seite (Steigungsvektor)*/
        f[0] = v;
        f[1] = - K*v - L*omega_viertel + M*pwm;
        return f;
    } 

    /** paint(..) wird bei der Konsolenanwendung nicht verwendet.*/
    public void paint(Graphics2D g)
    {
    }
}