package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

 /**
 *  <h4>OptimiererModGrad.java  - A class for optimization using a modified gradient method.</h4>
 *  <br/>
 *  <h4>OptimiererModGrad.java  - Klasse fr die Optimierung mittels eines modifizierten Gradientenverfahrens.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

public class OptimiererModGrad extends Optimierer
{
    /**Optimierungsvorgang auslsen. Wird von ergbenden Klassen berschrieben*/
    public void optimieren()
    {
        /**Faktoren, mit denen die Sprungweite beim ndern eines  Parameters
        variiert wird.*/
        double[] faktor = {-2.0,-1.0,-0.5,0.0,0.5,1.0,2.0};
        double[] testfehler = new double[7];

        /**Vektorlnge in die Suchrichtung*/
        double[] laenge = new double[anzahlParameter];
        for(int i=0;i<anzahlParameter;i++)
            laenge[i]=1.0;

        /**Fehler mit aktuellem Parametersatz bestimmen:*/
        double fehler = fehlerfunktion.berechneFehler(startparameter);
        double fehler_best = fehler;
        double fehler_akt = fehler;

        double[] neueparameter = new double[anzahlParameter];        

        for(int i=0;i<anzahlParameter;i++)
            neueparameter[i] = startparameter[i];

        boolean fertig = false;

        int imerk=0,kmerk=0;
        while(fertig==false)
        {
            //Fehler der Varianten bestimmen:
            for(int i=0;i<anzahlParameter;i++)
            {
                for(int k=0;k<faktor.length;k++)
                {
                    neueparameter[i]+=laenge[i]*faktor[k];
                   
                    fehler_akt = fehlerfunktion.berechneFehler(neueparameter); 

//                    if(fehler_akt<fehler_best )
//Ergnzung wg. Beschrnkung auf 0..1:
                    if(fehler_akt<fehler_best && neueparameter[i]>=0.0 && neueparameter[i]<=1.0)
                    {
                        imerk=i;
                        kmerk=k;
                        fehler_best = fehler_akt;
                    }

                    neueparameter[i]-=laenge[i]*faktor[k];
                }
            }
            neueparameter[imerk]+=laenge[imerk]*faktor[kmerk];                   
            //fehler_best = fehlerfunktion.berechneFehler(neueparameter);
            if(kmerk!=3)             
               laenge[imerk]*=faktor[kmerk]; /**Sprungweite verbessern fr nchsten Schritt*/

            if(fehler_akt-fehler_best<epsilon)
                fertig = true;

            fehler_akt = fehler_best;
System.out.println("aktueller kleinster Fehler: "+fehler_akt);
        }

        System.out.println("Start-Parametersatz:");
        for(int i=0;i<anzahlParameter;i++)
        {
            System.out.println("Parameter Nr.0: "+startparameter[i]);
        }


        System.out.println("Startfehler: "+fehler);
        System.out.println("Minimierter Fehler: "+fehler_best);
        System.out.println("Bester gefundener Parametersatz:");
        for(int i=0;i<anzahlParameter;i++)
        {
            System.out.println("Parameter Nr.0: "+neueparameter[i]);
        }
    }

    /** paint(..) wird bei der Konsolenanwendung nicht verwendet.*/
    public void paint(Graphics2D g)
    {
    }
     
}

