package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

 /**
 *  <h4>Optimierer.java  - A base class for optimization.</h4>
 *  <br/>
 *  <h4>Optimierer.java  - Basisklasse fr die Optimierung.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

public class Optimierer
{
    protected Fehlerfunktion fehlerfunktion = null;

    public int anzahlParameter = 0;
    /**Startparameter fr einen Optimierungsdurchlauf*/
    public double[] startparameter = null;
    /**Abbruchkriterium fr einen Optimierer: Fehlernderung kleiner als Epsilon*/
    public double epsilon = 0.0001;

    /**
    Mit add(..) wird eine Referenz auf die verwendete Fehlerfunktionsklasse im 
    Optimierer-Objekt gespeichert.
    */
    public void add(Fehlerfunktion fehlerfunktion)
    {
        this.fehlerfunktion = fehlerfunktion;
        anzahlParameter = fehlerfunktion.getAnzahlParameter();
        startparameter = new double[anzahlParameter];
        for(int i=0;i<anzahlParameter;i++)
            startparameter[i] = 0.0;
    }

    /**Optimierungsvorgang auslsen. Wird von ergbenden Klassen berschrieben*/
    public void optimieren()
    {
        
    }

    /** Ein Optimierer kann durch berschreiben der Methode paint() in die Lage
    versetzt werden, seinen aktuellen Zustand grafisch darzustellen.<br/>
    Die Methode wird von der paint-Methode eines Canvas-Objekts her aufgerufen.
    */
    public void paint(Graphics2D g)
    {
    }
     
}
