package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

 /**
 *  <h4>Integrator.java  - A base class for numerical integration.</h4>
 *  <br/>
 *  <h4>Integrator.java  - Basisklasse fr die numerische Integration.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

public class Integrator
{
    protected Simulationsmodell simulationsmodell = null;
    protected double[] yneu = null;

    /**
    Mit add(..) wird eine Referenz auf das zu integrierende Modell im 
    Integrator-Objekt gespeichert.
    */
    public void add(Simulationsmodell simulationsmodell)
    {
        this.simulationsmodell = simulationsmodell;
        yneu  = new double[simulationsmodell.getAnzahlGleichungen()];
    }

    /**
    Die Objekt-Methode zeitschritt(..) muss von erbenden Integrator-Klassen berschrieben werden.
    */
    double[] zeitschritt(double[] yalt,double t,double dt)
    {
        if(simulationsmodell==null)
            return null;

        return yneu;
    }

    /** Ein Integrator kann durch berschreiben der Methode paint() in die Lage
    versetzt werden, seinen aktuellen Zustand grafisch darzustellen.<br/>
    Die Methode wird von der paint-Methode eines Canvas-Objekts her aufgerufen.
    */
    public void paint(Graphics2D g)
    {
    }
     
}
