package opti;
import java.awt.*; //package awt fr die paint()-Methode ntig.

public class FehlerfunktionPIDgeregelterAntrieb implements Fehlerfunktion
{
    public Simulator simulator = null;


    /**Liefert die Anzahl der zu optimierenden Parameter*/
    public int getAnzahlParameter()
    {
        return 3;
    }

    /**Registrieren eines Simulators*/
    public void add(Simulator simulator)
    {
        this.simulator = simulator;
    }

    public double berechneFehler(double[] parameter)
    {
        double gewicht1=1.0,gewicht2=1.0;
        double fehler = 0;

        double P = parameter[0]; //z.B. 100
        double I = parameter[1]; //z.B. 10
        double D = parameter[2]; //z.B. 0

        simulator.init();
//ACHTUNG: K und L sind gegenber der Scilab-Musterlsung in Kaptiel 5.6 vertauscht!
        simulator.setParameter(1576.1789,0); //K
        simulator.setParameter(11542.314,1); //L
        simulator.setParameter(372.33722,2); //M
        simulator.setParameter(P,3); //P
        simulator.setParameter(I,4); //I
        simulator.setParameter(D,5); //D
        simulator.setParameter(0.01,6); //Tt
        simulator.setParameter(20.0,7); //omega_viertel_soll

        simulator.simulieren();

        for(int i=0;i<simulator.getAnzahl();i++)
        {
            double e = (simulator.getX(i))[0];
            double pwm = (simulator.getX(i))[1];
            fehler += gewicht1*e;

            if(pwm>1023)
                fehler+=gewicht2*(double)(pwm-1023);
            if(pwm<-1023)
                fehler+=gewicht2*(double)(-pwm-1023);
        }
        
        return fehler;
    }

    /** paint(..) wird bei der Konsolenanwendung nicht verwendet.*/
    public void paint(Graphics2D g)
    {
    }
}