package opti;
import java.awt.*;

import fuzzy.*; //Fuzzy-Package importieren.

 /**
 *  <h4>Antrieb.java  - simulation-model of an electro-car as PT2-unit.</h4>
 *  <br/>
 *  <h4>Antrieb.java  - Simulationsmodell eines Elektroantriebs als PT2-bertragungsglied.</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

public class Antrieb extends Simulationsmodell
{
    /**
    Die folgenden Variablen sind die Modellparameter, die spter
    optimiert werden knnen.<br/>
    Als Startwert sind die zu erwartenden Extremwerte eingestellt, damit
    spter automatisiert GUI-Elemente erzeugt werden knnen.<br/>
    Da positive Extremwerte vorgegeben sind, ist damit festgelegt, dass
    alle Modell-Parameter nicht negativ werden drfen.
    */

//ACHTUNG: K und L sind gegenber Scilab-Musterlsung vertauscht!
    public double K = 100000.0;
    public double L = 100000.0;
    public double M = 100000.0;

    public double pwm = -1023.0;

//Fuzzy-Regler einfgen:
    public FuzzyRegler fuzzyregler = null;

    private double[] e_aktuell = new double[1];

    public Antrieb()
    {
        super(2); //Zwei Simulationsgleichungen

        //Fuzzy-Regler initialisieren:
        //1. Fuzzy-Regler erstellen:
        fuzzyregler = new FuzzyRegler(); 

        //2. Fuzzy-Eingangs-Sets erstellen:
        FuzzyEingangsSet[] fes = new FuzzyEingangsSet[1];

        FuzzyEingangsSet   regeldifferenz   = new FuzzyEingangsSet();
        regeldifferenz.erzeugeFuzzyGroessen(5);
        regeldifferenz.verteileFuzzyGroessenGleichmaessig(-10.0,10.0);

        fes[0] = regeldifferenz;        

        fuzzyregler.setFuzzyEingangsSet(fes);

        //3. Fuzzy-Ausgangs-Set erstellen:
        FuzzyAusgangsSet fas = new FuzzyAusgangsSet();
        fas.erzeugeFuzzyGroessen(5+2); //Fnf Fuzzygren und Minimum und Maximum
        fas.verteileFuzzyGroessenGleichmaessig(-1023.0,1023.0);
       
        fuzzyregler.setFuzzyAusgangsSet(fas);

        //4. Fuzzy-Regeln hinzufgen:
        int[][] regeln = new int[5][];

        regeln[0] = new int[] {0, 0,0};//WENN ENG DANN PNG
        regeln[1] = new int[] {1, 0,1};//WENN ENK DANN PNK
        regeln[2] = new int[] {2, 0,2};//WENN ENN DANN PNN
        regeln[3] = new int[] {3, 0,3};//WENN EPK DANN PPK
        regeln[4] = new int[] {4, 0,4};//WENN EPG DANN PPG

        fuzzyregler.setFuzzyRegeln(regeln);
//Aus Optimierung:
       fuzzyregler.fes[0].verteileFuzzyGroessenNormiert( new double[] {0.0, 0.5, 0.0, 0.0, 1.0} );
    }

    public double[] berechneRechteSeite(double[] yalt, double t)
    {
        /**Eigentliche Bestimmung der rechten Seite (Steigungsvektor)*/
        e_aktuell[0] = 20.0 - yalt[0];
        pwm = fuzzyregler.berechneAusgang(e_aktuell);
        f[0] = yalt[1];
        f[1] = - K*yalt[1] - L*yalt[0] + M*pwm;
        return f;
    } 

    /** paint(..) wird bei der Konsolenanwendung nicht verwendet.*/
    public void paint(Graphics2D g)
    {
    }
}