package fuzzy;

public class FuzzySet
{
    protected double[] maxpos = null;
    protected double min = 0.0;
    protected double max = 0.0;
    

    public FuzzySet()
    {
    }

    public void erzeugeFuzzyGroessen(int anzahl)
    {
        if(anzahl>1) //mindestens min und max bei Eingangsfuzzysets
//        if(anzahl>3) //mindestens zwei Gren und min und max fr Ausgangsfuzzysets.
        {
            maxpos = new double[anzahl];
            for(int i=0;i<maxpos.length;i++)
                maxpos[i] = (double)i;           
        }
    }

    public void verteileFuzzyGroessenGleichmaessig(double min, double max)
    {
        if(max>min && maxpos!=null && maxpos.length>1)
        {
            double delta = (max-min)/((double)maxpos.length-1);
            this.min = min;
            this.max = max;
            for(int i=0;i<maxpos.length;i++)
                maxpos[i] = min + (double)i*delta;
        }
    }

    /**
    Um bei Optimierungen mit n Parametern zwischen 0..1 operieren zu<br/>
    knnen, wird hier als absolute Grenzen min und max verwendet und<br/>
    darauf bezogen die Maxima der Fuzzysets verteilt.<br/>
    Vorgehen:<br/>
    <code>
    Es gibt die Verteilungen v0..vn-1
    1. Setze das Maximum der ersten Fuzzygre an die Stelle p0 = min + v0*(max-min)
    2. Setze das Maximum der zweiten Fuzzygre an die Stelle p1 = p0 + v1*(max-p0)
    3. Setze das Maximum der zweiten Fuzzygre an die Stelle p2 = p1 + v2*(max-p1)
    usw.
    </code>
    <br/>
    D.h. Die Rnder drfen auch innerhalb von [min,max] liegen, aber nicht auerhalb.<br/>
    Somit sollte [min,max] so eingestellt werden, dass diese absolute Grenzen darstellen, die niemals berschritten werden drfen.<br/>
    Eine gleichmige Verteilung in [min,max] erhlt man beispielsweise<br/>
    bei 5 Parametern (0-1-2-3-4) ber Verteilungswerte von:<br/>
    verteilung = { 0 , 1/4 , 1/3 , 1/2 , 1 }
    */
    public void verteileFuzzyGroessenNormiert(double[] verteilung)
    {
        if(maxpos!=null && verteilung!=null 
        && maxpos.length==verteilung.length
           && max>min)
        {
            double palt=min;    
            for(int i=0;i<maxpos.length;i++)
            {
                maxpos[i] = palt + verteilung[i]*(max-palt);
                palt = maxpos[i];                
            }
        }
    }
}