package fuzzy;

/**
 *  <h4>FuzzyEingangsSet.java</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

    /**
    Array maxpos: x-Positionen der Maxima.
    <code>

    ^
    |___      _____
    |   \/\/\/
    |   /\/\/\
    --------------> Maximums-Position
Max Nr.0  1 2 3

    </code>
    */
public class FuzzyEingangsSet extends FuzzySet
{
    /**
    Liefert den Zugehrigkeitsgrad des Eingangswerts input zu der i-ten Fuzzygre.<br/>
    D.h. es wird hier der i-te Zugehrigkeitswert fr die bergebene Eingangsgroesse berechnet.
    */
    public double getZugehoerigkeitsgrad(int i,double input)
    {
        if(maxpos==null || maxpos.length<2)
            return 0.0;
        if(i==0 && input<=maxpos[0]) //linker Rand
            return 1.0;
        if(i==maxpos.length-1 && input>=maxpos[i]) //rechter Rand
            return 1.0;
        if(i>0 && input<=maxpos[i-1]) //Nullbereich links
            return 0.0;
        if(i<maxpos.length-1 && input>=maxpos[i+1]) //Nullbereich rechts
            return 0.0;
        if(i>0 && input<maxpos[i]) //positive Steigung
            if(maxpos[i]-maxpos[i-1]>0.0)
                return (input-maxpos[i-1])/(maxpos[i]-maxpos[i-1]);
            else
                return 1.0;
        if(i<maxpos.length-1 && input>maxpos[i]) //negative Steigung
            if(maxpos[i+1]-maxpos[i]>0.0)
                return (input-maxpos[i+1])/(maxpos[i]-maxpos[i+1]);
            else
                return 1.0;

        System.out.println("Ungueltiges Ergebnis in getZugehoerigkeitsgrad()!");
        return 0.0;
    }

    public static void main(String[] args)
    {
        //Beispiel aus Vorlesung durchtesten:
        FuzzyEingangsSet raumtemperatur = new FuzzyEingangsSet();
        raumtemperatur.erzeugeFuzzyGroessen(2);
        raumtemperatur.verteileFuzzyGroessenGleichmaessig(10.0,30.0);

        FuzzyEingangsSet luftfeuchte = new FuzzyEingangsSet();
        luftfeuchte.erzeugeFuzzyGroessen(2);
        luftfeuchte.verteileFuzzyGroessenGleichmaessig(50.0,70.0);

        System.out.println("Tests:");
        System.out.println("[25,60]");
        System.out.println("RK="+raumtemperatur.getZugehoerigkeitsgrad(0,25.0));
        System.out.println("RG="+raumtemperatur.getZugehoerigkeitsgrad(1,25.0));
        System.out.println("LK="+luftfeuchte.getZugehoerigkeitsgrad(0,60.0));
        System.out.println("LG="+luftfeuchte.getZugehoerigkeitsgrad(1,60.0));
    }
}