package fuzzy;

/**
 *  <h4>FuzzyAusgangsSet.java</h4>
 *  <br/>
 *  Copyright (C) 2011 Guido Kramann<br/>
 *  kramann@fh-brandenburg.de<br/>
 *  http://www.kramann.info<br/>
 *  <br/>
 *  <p>  
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *  </p>
 *  <p>
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *  </p>
 *  <p>
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  </p>
 */

    /**
    Array maxpos: x-Positionen der Maxima.
    <code>

        ^
        |      
        |  /\/\/\/\
        | / /\/\/\ \
        --------------> Maximums-Position
Max Nr.  0 1 2 3 4 5
    Anders als beim EingangsFuzzySet
    markieren 0 und 5 in dem Beispiel keine Maximumslage, sondern
    den Rand! Nur 1..4 sind Maximumslagen in maxpos.

    </code>
    */
public class FuzzyAusgangsSet extends FuzzySet
{

    /**
    ACHTUNG:<br/>
    nr==0 verwendet das Maximum bei maxpos[1] usw.
    */
    public double getFlaeche(int nr, double regelaktivierung)
    {
        if(nr<0 || nr>maxpos.length-3)
            return 0.0;
        if(regelaktivierung<=0)
            return 0.0;
        return 
            regelaktivierung*(maxpos[nr+2]-maxpos[nr])*( 1.0 - 0.5*regelaktivierung);
    }
    public double getSchwerpunkt(int nr, double regelaktivierung)
    {
        if(nr<0 || nr>maxpos.length-3)
            return 0.0;
        if(regelaktivierung<=0)
            return 0.0;
        return
        (
           //Schwerpunkt Dreiecksflche links:
            ( maxpos[nr]+(2.0/3.0)*regelaktivierung*(maxpos[nr+1]-maxpos[nr]) ) //Schwerp.
           *regelaktivierung*(maxpos[nr+1]-maxpos[nr])*0.5*regelaktivierung     //Flaeche

          +
           //Schwerpunkt Dreiecksflche rechts:
            ( maxpos[nr+2]-(2.0/3.0)*regelaktivierung*(maxpos[nr+2]-maxpos[nr+1]) ) //Schwerp.
           *regelaktivierung*(maxpos[nr+2]-maxpos[nr+1])*0.5*regelaktivierung         //Flaeche
          +
           //Schwerpunkt Rechteck:
            //Schwerp.
            (   
                maxpos[nr]+regelaktivierung*(maxpos[nr+1]-maxpos[nr]) 
              + maxpos[nr+2]-regelaktivierung*(maxpos[nr+2]-maxpos[nr+1])

            )*0.5*
            //Flaeche
            (   
                maxpos[nr+2]-regelaktivierung*(maxpos[nr+2]-maxpos[nr+1])
              - ( maxpos[nr]+regelaktivierung*(maxpos[nr+1]-maxpos[nr]) )
            )*regelaktivierung
        )/getFlaeche(nr,regelaktivierung);
    }

    public static void main(String[] args)
    {
        //Tests mit Aufgabe aus Vorlesung:
        FuzzyAusgangsSet fas = new FuzzyAusgangsSet();
        fas.erzeugeFuzzyGroessen(3+2); //Drei Fuzzygren und Minimum und Maximum
        fas.verteileFuzzyGroessenGleichmaessig(-100.0,300.0);
        double vn  = 0.25;
        double vk  = 0.25;
        double vg  = 0.5;
        double vg2 = 0.5;

        System.out.println("u1="+fas.getSchwerpunkt(0,vn));
        System.out.println("u2="+fas.getSchwerpunkt(1,vk));
        System.out.println("u3="+fas.getSchwerpunkt(2,vg));
        System.out.println("u4="+fas.getSchwerpunkt(2,vg2));

        System.out.println(
                            (
                              fas.getFlaeche(0,vn)*fas.getSchwerpunkt(0,vn)
                             +fas.getFlaeche(1,vk)*fas.getSchwerpunkt(1,vk)
                             +fas.getFlaeche(2,vg)*fas.getSchwerpunkt(2,vg)
                             +fas.getFlaeche(2,vg2)*fas.getSchwerpunkt(2,vg2)
                            )
                            /
                            (
                              fas.getFlaeche(0,vn)
                             +fas.getFlaeche(1,vk)
                             +fas.getFlaeche(2,vg)
                             +fas.getFlaeche(2,vg2)                            
                            )
                          );


//Simpler Test:
        System.out.println(fas.getFlaeche(0,1.0)+" soll:"+100.0);
    }
}