//KRPER1
m1= 0.094;
r = 0.035;
J1= 0.0000576;

//KRPER2
m2 = 0.364;
d = 0.06;
b = 0.057;
h = 0.14;
J2=0.000693;

g=9.81;



function f = rechteSeite(t,y)
    phi1 = y(1,1);
    om1  = y(2,1);
    phi2 = y(3,1);
    om2  = y(4,1);

    M = 2.0*phi2 + 0.02*om2;

    KK = d*sin(phi2);
    LL = d*cos(phi2);

    AA = [  (-m1*r*r)/J1 - 1, 0,                  1,              0;
            0,               -1,                  0,              1;
            (-m2*r*r)/J1,     0, (-m2*LL*LL)/J2 - 1, (-m2*KK*LL)/J2;
            0,                0, (-m2*KK*LL)/J2,     (-m2*KK*KK)/J2 - 1
         ];

    bb = [m1*r*M/J1; 
         -m1*g; 
         (m2*r*M)/J1 - (m2*LL*M)/J2 - (m2*KK*om2*om2);
         (-m2*KK*M)/J2 + m2*LL*om2*om2 - m2*g 
         ];

    FZ = inv(AA)*bb;

    F1x = FZ(1);
    F1y = FZ(2);
    F2x = FZ(3);
    F2y = FZ(4);

    f(1,1) = om1;
    f(2,1) = (r*F1x + M)/J1;
    f(3,1) = om2;
    f(4,1) = (d*sin(phi2)*F2y + d*cos(phi2)*F2x - M)/J2;
endfunction

t = linspace(0,1,1000);
y0 = [0,0,0.02,0]';
t0 = 0;
y  = ode(y0,t0,t,rechteSeite);

plot(t,y(1,:)',t,y(3,:)');

