#include<avr/io.h>

//Definition von Taktfrequenz und Bausrate als Konstanten
#define TAKTFREQUENZ 9216000
#define BAUDRATE 115200

#define PUFFERGROESSE 100

unsigned char puffer[PUFFERGROESSE];

void sendeZeichen(unsigned char c)
{
        while( !(UCSRA & (1<<UDRE)) ); //Warten bis der Uebertragungspuffer leer ist
        UDR = c;                    //Daten in den Puffer schreiben und übertragen	  
}

void sendeText(unsigned char* text)
{
	 int i=0;
	 while(text[i]!='\0')
	 {
	    sendeZeichen(text[i]);
	    i++;
    }	    
}

unsigned char empfangeZeichen()
{
	     unsigned char c;
        while( !(UCSRA & (1<<RXC)) );  //Warten bis der Uebertragungspuffer ein Zeichen empfangen hat
        c = UDR;                    //Zeichen aus dem Puffer holen
        return c;
}

void empfangeText()
{
	  int i=0;
	  unsigned char c;
	  
     do	  
     {
     	 c = empfangeZeichen();
       puffer[i]=c;    	 
     	 i++;
     } while(c!='#');
     
     puffer[i-1]='\0';     
}


int main()
{
    unsigned char akku=0;

    DDRA = 0b00000000;
    DDRB = 0b00000000;
    DDRD = 0b00000000;

    DDRC = 0b11111111; //über RS232 gesendete Zahlen sollen auch an 
                       //zweiten Mikrocontroller geschickt
                       //und angezeigt werden.

    //Aktivieren der RS232-Schnittstelle des Mikrocontrollers:
    
    //Merken des in UBRR zu speichernden Wertes.
    unsigned int baudregister = TAKTFREQUENZ/8/BAUDRATE-1;

	//setzen der Baudrate
	UBRRH = (unsigned char) (baudregister>>8); //Setzen des HIGH-Bytes des Baudraten-Registers
	UBRRL = (unsigned char)  baudregister;     //Setzen des LOW -Bytes des Baudraten-Registers
	
	//Einschalten des Senders und des Empfängers
	UCSRB = (1<<TXEN) | (1<<RXEN);
		        
	//Setzen des Nachrichtenformats: 8 Datenbits, 1 Stopbits
	UCSRC = (1<<URSEL)|(1<<UCSZ0)|(1<<UCSZ1);
    UCSRA = (1<<U2X);

    //Es soll das zuletzt vom Hyperterminal empfangene ASCII-Zeichen 
    //dezimal angezeigt werden

    while(1)
    {
        //while( !(UCSRA & (1<<RXC)) );  //Warten bis der Uebertragungspuffer ein Zeichen empfangen hat
        //akku = UDR;                    //Zeichen aus dem Puffer holen

        //...und anzeigen
        //PORTC = empfangeZeichen();
        
        empfangeText();
        sendeText("Sie haben folgenden Text gesendet:\n\r");
        sendeText(puffer);
        sendeText("\n\r");
        
    }
}