#include<avr/io.h>

//Definition von Taktfrequenz und Bausrate als Konstanten
#define TAKTFREQUENZ 9216000
#define BAUDRATE 115200

void sendeZeichen(unsigned char c)
{
        while( !(UCSRA & (1<<UDRE)) ); //Warten bis der Uebertragungspuffer leer ist
        UDR = c;                    //Daten in den Puffer schreiben und übertragen	  
}

void sendeText(unsigned char* text)
{
	 int i=0;
	 while(text[i]!='\0')
	 {
	    sendeZeichen(text[i]);
	    i++;
    }	    
}

int main()
{
    unsigned char l,m,r;	//Variablen für Anzeige links, mitte, rechts
    unsigned char akku=0;
    unsigned long pause;

    DDRA = 0b00000000;
    DDRB = 0b00000000;
    DDRD = 0b00000000;

    DDRC = 0b11111111; //über RS232 gesendete Zahlen sollen auch an 
                       //zweiten Mikrocontroller geschickt
                       //und angezeigt werden.

    //Aktivieren der RS232-Schnittstelle des Mikrocontrollers:
    
    //Merken des in UBRR zu speichernden Wertes.
    unsigned int baudregister = TAKTFREQUENZ/8/BAUDRATE-1;

    //setzen der Baudrate
    UBRRH = (unsigned char) (baudregister>>8); //Setzen des HIGH-Bytes des Baudraten-Registers
    UBRRL = (unsigned char)  baudregister;     //Setzen des LOW -Bytes des Baudraten-Registers
	
    //Einschalten des Senders und des Empfängers
    UCSRB = (1<<TXEN) | (1<<RXEN);
		        
    //Setzen des Nachrichtenformats: 8 Datenbits, 1 Stopbits
    UCSRC = (1<<URSEL)|(1<<UCSZ0)|(1<<UCSZ1);
    UCSRA = (1<<U2X);

    //Es soll wiederholt von 0 bis 255 durchgezählt werden und
    //der aktuelle Wert im Hyperterminal zu sehen sein.

    while(1)
    {
        l= akku / 100;			//links = Inhalt von akku dividiert mit 100 
	m= (akku % 100) / 10;	        //mitte = Inhalt von akku modulo mit 100 , anschließend dividiert mit 10 
	r= akku % 10;			//rechts = Inhalt von akku modulo mit 10	
        
        //Die drei Ziffern der aktuellen Zahl werden in ASCII-Zeichen umgewandelt
        //und mit UDR = ... seriell gesendet.
        //Dann muß gewartet werden, bis das Senden beendet ist.
        //Es folgen ein Zeilenumbruch und ein Zurücksetzen des Cursers auf den 
        //Zeilenanfang:

//        while( !(UCSRA & (1<<UDRE)) ); //Warten bis der Uebertragungspuffer leer ist
//        UDR = l+48;                    //Daten in den Puffer schreiben und übertragen
 
 
        sendeText("Neue Zahl:\n"); 
        
        sendeZeichen(l+48);        
        
        
        while( !(UCSRA & (1<<UDRE)) ); 
        UDR = m+48;
        while( !(UCSRA & (1<<UDRE)) );
        UDR = r+48;
        while( !(UCSRA & (1<<UDRE)) );
	    UDR = '\n';
        while( !(UCSRA & (1<<UDRE)) );
	    UDR = '\r';

        //Zahl außerdem wie gewohnt nach Port C schicken:
        PORTC = akku;

        for(pause=0;pause<500000;pause++)
            DDRB|=0;

        //Weiterzählen:
        akku++;
    }
}