#include<avr/io.h>

//Definition von Taktfrequenz und Bausrate als Konstanten
#define TAKTFREQUENZ 9216000
#define BAUDRATE 115200


int main()
{
    unsigned char akku=0;

    DDRA = 0b00000000;
    DDRB = 0b00000000;
    DDRD = 0b00000000;

    DDRC = 0b11111111; //ber RS232 gesendete Zahlen sollen auch an 
                       //zweiten Mikrocontroller geschickt
                       //und angezeigt werden.

    //Aktivieren der RS232-Schnittstelle des Mikrocontrollers:
    
    //Merken des in UBRR zu speichernden Wertes.
    unsigned int baudregister = TAKTFREQUENZ/8/BAUDRATE-1;

	//setzen der Baudrate
	UBRRH = (unsigned char) (baudregister>>8); //Setzen des HIGH-Bytes des Baudraten-Registers
	UBRRL = (unsigned char)  baudregister;     //Setzen des LOW -Bytes des Baudraten-Registers
	
	//Einschalten des Senders und des Empfngers
	UCSRB = (1<<TXEN) | (1<<RXEN);
		        
	//Setzen des Nachrichtenformats: 8 Datenbits, 1 Stopbits
	UCSRC = (1<<URSEL)|(1<<UCSZ0)|(1<<UCSZ1);
    UCSRA = (1<<U2X);

    //Es soll das zuletzt vom Hyperterminal empfangene ASCII-Zeichen 
    //dezimal angezeigt werden

    while(1)
    {
        while( !(UCSRA & (1<<RXC)) );  //Warten bis der Uebertragungspuffer ein Zeichen empfangen hat
        akku = UDR;                    //Zeichen aus dem Puffer holen

        //...und anzeigen
        PORTC = akku;
    }
}
