//Definition von Taktfrequenz und Bausrate als Konstanten
#define TAKTFREQUENZ 9216000
#define BAUDRATE 115200

class RS232 : RS232BASIS
{
  public:	
	void start()
	{
    //Aktivieren der RS232-Schnittstelle des Mikrocontrollers:
    
    //Merken des in UBRR zu speichernden Wertes.
    unsigned int baudregister = TAKTFREQUENZ/8/BAUDRATE-1;

    //setzen der Baudrate
    UBRRH = (unsigned char) (baudregister>>8); //Setzen des HIGH-Bytes des Baudraten-Registers
    UBRRL = (unsigned char)  baudregister;     //Setzen des LOW -Bytes des Baudraten-Registers
	
    //Einschalten des Senders und des Empfängers
    UCSRB = (1<<TXEN) | (1<<RXEN);
		        
    //Setzen des Nachrichtenformats: 8 Datenbits, 1 Stopbits
    UCSRC = (1<<URSEL)|(1<<UCSZ0)|(1<<UCSZ1);
    UCSRA = (1<<U2X);		
	}
	void stop()
	{
       //Einschalten des Senders und des Empfängers
       UCSRB &= ~((1<<TXEN) | (1<<RXEN));
	}
	void sendeZeichen(unsigned char c)
	{
        while( !(UCSRA & (1<<UDRE)) ); 
        UDR = c;		
	}
};