#include <avr/io.h>
int main(void)
{
    uint8_t akku;
    uint16_t position = 108;


    DDRB = 0b00000000;
    DDRC = 0b11111111;
    PORTB |= 0b00000011;


    TCCR1A = (1<<COM1A1) | (0<<COM1A0) | (1<<COM1B1) | (0<<COM1B0) | (0<<FOC1A) | (0<<FOC1B) | (1<<WGM11) | (1<<WGM10);
    TCCR1B = (0<<ICNC1) | (0<<ICES1) | (0<<WGM13) | (0<<WGM12) | (0<<CS12) | (1<<CS11) | (1<<CS10);
    DDRD |= (1<<PB5) | (1<<PB4); //auf Ausgang setzen.            
    OCR1A = position; //PWM-Breite setzen (entspricht fr Servo auf 0 Grad).
    OCR1B = position; //PWM-Breite setzen (entspricht fr Servo auf 0 Grad).
    PORTC = position;

    while(true)
    {
        akku = PINB;
        if( position<144 && (akku & 0b00000011) == 1) //Taster PB0 gedrckt
        {
            position++;
            PORTC = position;
            OCR1A=position; 
            OCR1B=position; 
            while( (akku & 0b00000011) == 1)
                akku = PINB;
        }
        else if( position>72 && (akku & 0b00000011) == 2) //Taster PB1 gedrckt
        {
            position--;
            PORTC = position;
            OCR1A=position; 
            OCR1B=position; 
            while( (akku & 0b00000011) == 2)
                akku = PINB;
        }
    }
    return 0;
}
