class SERVO
{
    public:
        void start()
        {
            TCCR1A = (1<<COM1A1) | (0<<COM1A0) | (1<<COM1B1) | (0<<COM1B0) | (0<<FOC1A) | (0<<FOC1B) | (1<<WGM11) | (1<<WGM10);
            TCCR1B = (0<<ICNC1) | (0<<ICES1) | (0<<WGM13) | (0<<WGM12) | (0<<CS12) | (1<<CS11) | (1<<CS10);
            DDRD |= (1<<PD5) | (1<<PD4); //auf Ausgang setzen.            
            OCR1A = 108; //PWM-Breite setzen (entspricht fr Servo auf 0 Grad).
            OCR1B = 108; //PWM-Breite setzen (entspricht fr Servo auf 0 Grad).
        }
        void stop()
        {
            TCCR1A = 0;
            TCCR1B = 0;
            DDRD &= ~((1<<PD5) | (1<<PD4));
        }
        void setzeWinkel(int winkel)
        {
            if(winkel==0)
            {
                OCR1A = 0;  //wir mssen winkel/1.25 teilen, Offset 108 vergl. Kapitel 4.8
                OCR1B = 0;  
            }
            else
            {             
                OCR1A = 108+(winkel*4)/5;  //wir mssen winkel/1.25 teilen, Offset 108 vergl. Kapitel 4.8
                OCR1B = 108+(winkel*4)/5;  
            }
        }
};