class RS232
{
  public:
    RS232(uint32_t baudrate=115200, uint8_t datenbits=8, uint8_t stopbits=1)
    {
  	    //setzen der Baudrate:
        uint32_t baudregister = TAKTFREQUENZ/8/baudrate-1;
	    UBRRH = (uint8_t) (baudregister>>8); //Setzen des HIGH-Bytes des Baudraten-Registers
	    UBRRL = (uint8_t)  baudregister;     //Setzen des LOW -Bytes des Baudraten-Registers
        //einfache (nicht doppelte) bertragungsgeschwindigkeit:
        UCSRA = (1<<U2X);
	    //Setzen des Nachrichtenformats: 8 Datenbits, 1 Stopbits
        switch(datenbits)
        {
            case 5:
	            UCSRC = (1<<URSEL)|(0<<UCSZ1)|(0<<UCSZ0);
            break;
            case 6:
	            UCSRC = (1<<URSEL)|(0<<UCSZ1)|(1<<UCSZ0);
            break;
            case 7:
	            UCSRC = (1<<URSEL)|(1<<UCSZ1)|(0<<UCSZ0);
            break;
            case 8:
	            UCSRC = (1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0);
            break;
        }
        if(stopbits==2)
            UCSRC |= (1<<USBS);
    }

    void start(bool senden, bool empfangen)
    {
        if(senden==true)
            UCSRB |= 1<<TXEN;
        if(empfangen==true)
            UCSRB |= 1<<RXEN;
    }
    void stop()
    {
            UCSRB &= 255 - (1<<TXEN) - (1<<RXEN);
    }

    void sendeZeichen(uint8_t zeichen)
    {
        while( !(UCSRA & (1<<UDRE)) ); //Warten bis der Uebertragungspuffer leer ist
        UDR = zeichen;                    //Daten in den Puffer schreiben und bertragen
    }
    void sendeZahl(uint8_t zahl)
    {
        sendeZeichen( 48+zahl/100 );
        sendeZeichen( 48+(zahl % 100)/10 );
        sendeZeichen( 48+zahl%10 );
        sendeZeichen('\n');
        sendeZeichen('\r');
    }
};
