#include <avr/io.h>


void zeigeZahlDezimal(unsigned char akku)
{
    unsigned char l,m,r;	//Variablen fr Anzeige links, mitte, rechts
	        
    l= akku / 100;			//links = Inhalt von akku dividiert mit 100 
	m= (akku % 100) / 10;	//mitte = Inhalt von akku modulo mit 100 , anschlieend dividiert mit 10 
	r= akku % 10;			//rechts = Inhalt von akku modulo mit 10	
        
   	switch(m)				//Mehrseitige Alternative fr die Variable m
	{
		case 0: PORTD = (PORTD & 0b00000111) | 0b00001111; 
                PORTB = (PORTB & 0b01111111) | 0b01111111;
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                break;
		case 1: PORTD = (PORTD & 0b00000111) | 0b00111111;
		        PORTB = (PORTB & 0b01111111) | 0b11111111;
                PORTC = (PORTC & 0b01111111) | 0b11111111;
                break;
		case 2: PORTD = (PORTD & 0b00000111) | 0b10010111;
                PORTB = (PORTB & 0b01111111) | 0b01111111;
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                break;
		case 3: PORTD = (PORTD & 0b00000111) | 0b00010111; 
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                PORTB = (PORTB & 0b01111111) | 0b11111111;
                break;
		case 4: PORTD = (PORTD & 0b00000111) | 0b00100111;
                PORTB = (PORTB & 0b01111111) | 0b11111111;
                PORTC = (PORTC & 0b01111111) | 0b11111111; 
                break;
		case 5: PORTD = (PORTD & 0b00000111) | 0b01000111; 
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                PORTB = (PORTB & 0b01111111) | 0b11111111;
                break;
		case 6: PORTD = (PORTD & 0b00000111) | 0b01000111; 
                PORTB = (PORTB & 0b01111111) | 0b01111111;
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                break;
		case 7: PORTD = (PORTD & 0b00000111) | 0b00011111;
                PORTB = (PORTB & 0b01111111) | 0b11111111;
                PORTC = (PORTC & 0b01111111) | 0b11111111; 
                break;
		case 8: PORTD = (PORTD & 0b00000111) | 0b00000111;
                PORTB = (PORTB & 0b01111111) | 0b01111111;
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                break;
		case 9: PORTD = (PORTD & 0b00000111) | 0b00000111; 
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                PORTB = (PORTB & 0b01111111) | 0b11111111;
                break;
		default:PORTD = (PORTD & 0b00000111) | 0b00001111; 
                PORTB = (PORTB & 0b01111111) | 0b01111111; 
                PORTC = (PORTC & 0b01111111) | 0b01111111;
                PORTD=0;

                break;
	}
	
    switch(r)
	{
		case 0: PORTC= (PORTC & 0b10000000) | 0b01000000;  break;
		case 1: PORTC= (PORTC & 0b10000000) | 0b01110110;  break;
		case 2: PORTC= (PORTC & 0b10000000) | 0b00100001;  break;
		case 3: PORTC= (PORTC & 0b10000000) | 0b00100100;  break;
		case 4: PORTC= (PORTC & 0b10000000) | 0b00010110;  break;
		case 5: PORTC= (PORTC & 0b10000000) | 0b00001100;  break;
		case 6: PORTC= (PORTC & 0b10000000) | 0b00001000;  break;
		case 7: PORTC= (PORTC & 0b10000000) | 0b01100110;  break;
		case 8: PORTC= (PORTC & 0b10000000) | 0b00000000;  break;
		case 9: PORTC= (PORTC & 0b10000000) | 0b00000100;  break;
		default:PORTC= (PORTC & 0b10000000) | 0b01000000;  break;
	    
    }	
	    
	switch(l)
	{
		case 0: PORTB= (PORTB & 0b10000000) | 0b00001000; break;
		case 1: PORTB= (PORTB & 0b10000000) | 0b00111110; break;
		case 2: PORTB= (PORTB & 0b10000000) | 0b00010001; break;
		case 3: PORTB= (PORTB & 0b10000000) | 0b00010100; break;
		case 4: PORTB= (PORTB & 0b10000000) | 0b00100110; break;
		case 5: PORTB= (PORTB & 0b10000000) | 0b01000100; break;
		case 6: PORTB= (PORTB & 0b10000000) | 0b01000000; break;
		case 7: PORTB= (PORTB & 0b10000000) | 0b00011110; break;
		case 8: PORTB= (PORTB & 0b10000000) | 0b00000000; break;
		case 9: PORTB= (PORTB & 0b10000000) | 0b00000100; break;
		default:PORTB= (PORTB & 0b10000000) | 0b00001000; break;
	    
    }
	
}


int main(void)
{
    unsigned char zahl,zahl_alt;
    unsigned long pause;

	DDRA = 0x00; 			//PORT A als Eingang 
	DDRB = 0xFF;			//PORT B als Ausgang
	DDRC = 0xFF;			//PORT C als Ausgang
	DDRD = 0b11111100;			//PORT D als Ausgang, ausser RXD und TXD
	
	PORTA = 0;				//PORTs A-D auf definierten Pegel setzen (LOW)
	PORTB = 0;
	PORTC = 0;
	PORTD = 0;

    zahl = 0;
    zahl_alt = 0;

    zeigeZahlDezimal(zahl);		

    while(true)
	{
        zahl = PINA;
        if(zahl!=zahl_alt)
        {
            zeigeZahlDezimal(zahl);		
            zahl_alt = zahl;
        }
		//zahl++;	    

		//for(pause=0;pause<3000000;pause++);
	}
	return 0;
}
