/**
Messages to control smart home devices from WIZ:
https://seanmcnally.net/wiz-config.html
lamp connects to hotspotK, pw:12345678
*/

// import UDP library
import hypermedia.net.*;


UDP udp;  // define the UDP object

/**
 * init
 */
void setup() {

  // create a new datagram connection on port 6000
  // and wait for incomming message
  udp = new UDP( this, 38899 );
  //udp.log( true ); 		// <-- printout the connection activity
  udp.listen( true );
}

//process events
void draw() {;}

/** 
 * on key pressed event:
 * send the current key value over the network
 */
 
 boolean AN = true;
void keyPressed() {
    
  AN=!AN;
    String message  = str( key );	// the message to send
    if(AN)
      message = "{\"id\":1,\"method\":\"setState\",\"params\":{\"state\":true}}";
    else  
      message = "{\"id\":1,\"method\":\"setState\",\"params\":{\"state\":false}}";
    String ip       = "10.42.0.255";  // the remote IP address
//    String ip       = "192.168.178.255";  // the remote IP address
//    String ip       = "192.168.178.92";  // the remote IP address
    int port        = 38899;		// the destination port
    
    // formats the message for Pd
    message = message+";\n";
    // send the message
    udp.send( message, ip, port );
    
}

/**
 * To perform any action on datagram reception, you need to implement this 
 * handler in your code. This method will be automatically called by the UDP 
 * object each time he receive a nonnull message.
 * By default, this method have just one argument (the received message as 
 * byte[] array), but in addition, two arguments (representing in order the 
 * sender IP address and his port) can be set like below.
 */
// void receive( byte[] data ) { 			// <-- default handler
void receive( byte[] data, String ip, int port ) {	// <-- extended handler
  
  
  // get the "real" message =
  // forget the ";\n" at the end <-- !!! only for a communication with Pd !!!
  data = subset(data, 0, data.length-2);
  String message = new String( data );
  
  // print the result
  println( "receive: \""+message+"\" from "+ip+" on port "+port );
}
