#define LILYGO_WATCH_2020_V3  // To use T-Watch2020 V3, please uncomment this line

//für wav:

// Except T-Watch2020, other versions need to be selected according to the actual situation
#if  !defined(LILYGO_WATCH_2020_V1) && !defined(LILYGO_WATCH_2020_V3)

// T-Watch comes with the default backplane, it uses internal DAC
#define STANDARD_BACKPLANE

// Such as MAX98357A, PCM5102 external DAC backplane
// #define EXTERNAL_DAC_BACKPLANE

#else
// T-Watch2020 uses external DAC
#undef STANDARD_BACKPLANE
#define EXTERNAL_DAC_BACKPLANE

#endif


//ende für wav

#include <LilyGoWatch.h>

#pragma mark - Depend ESP8266Audio and ESP8266_Spiram libraries


//UDP:
#include "AsyncUDP.h"
#include <WiFi.h>

//RTC time
#include <soc/rtc.h>
#include <time.h>

//Tongenerator
#include <HTTPClient.h>         //Remove Audio Lib error
#include "AudioOutputI2S.h"
#include "AudioFileSourceFunction.h"
#include "AudioGeneratorWAV.h"
#include "AudioOutputI2S.h"

float sine_wave_alt(const float time) {
  float v = sin(TWO_PI * 440.f * time);  // C
  v *= fmod(time, 1.f);               // change linear
  v *= 0.5;                           // scale
  return v;
}

float sine_wave(const float time) {
  float tremolo = 110.f*sin(TWO_PI * 4.f * time);
  float v = sin(TWO_PI * (440.f + tremolo) * time);  // C
//  v=v*v*v;
  v *= fmod(time, 1.f);               // change linear
  v *= 0.5;                           // scale
  return v;
}


AudioFileSourceFunction* file_wav;
AudioOutputI2S *output_wav;
AudioGeneratorWAV* wav_generator;

AsyncUDP udp;

/*
                          Zeilen  Spalten
    tft->setTextFont(8);    3        4
    tft->setTextFont(6);    5        8
    tft->setTextFont(4);    9       16
    tft->setTextFont(2);   15       29

 */

TTGOClass *watch;
TFT_eSPI *tft;
BMA *sensor;
BackLight *hintergrundlicht; //Um es manipulieren zu können!!!
//Accel acc; //?

//Uhrzeit:
int _hh=0;
int _mm=0;
int _ss=0;
RTC_Date tnow;

void setupTWATCH()
{
    //Serial.begin(115200);  //weglassen, sonst ev. im Normalbetrieb Probleme

    watch = TTGOClass::getWatch();
    watch->begin();
    // Turn on the backlight .. aber nicht nur das!!!!
    watch->openBL();
    
    tft = watch->tft;
    sensor = watch->bma;
    hintergrundlicht = watch->bl; //Hintergrundlicht als Objekt verfügbar machen!
    
    // Accel parameter structure (siehe Kommentare in Originalbeispiel!)
    Acfg cfg;
    cfg.odr = BMA4_OUTPUT_DATA_RATE_100HZ;
    cfg.range = BMA4_ACCEL_RANGE_2G;
    cfg.bandwidth = BMA4_ACCEL_NORMAL_AVG4;
    cfg.perf_mode = BMA4_CONTINUOUS_MODE;

    // Configure the BMA423 accelerometer
    sensor->accelConfig(cfg);

    // Enable BMA423 accelerometer
    sensor->enableAccel();

    // You can also turn it off
    // sensor->disableAccel();

    // Some display settings
    //tft->setTextColor(random(0xFFFF));
    tft->setTextColor(TFT_GREEN, TFT_BLACK);
    //tft->drawString("BMA423 accel",  25, 50, 4);
    tft->setTextFont(4);
    //tft->setTextColor(TFT_WHITE, TFT_BLACK); 

    //Check if the RTC clock matches, if not, use compile time
    watch->rtc->check();

    //Synchronize time to system time
    watch->rtc->syncToSystem();
    // Get the current data
    
    tnow = watch->rtc->getDateTime();

    //wav Tongenerator
/*    
    watch->enableAudio();
    watch->enableLDO3();
    file_wav = new AudioFileSourceFunction(1.);
    file_wav->addAudioGenerators(sine_wave);
    #if defined(STANDARD_BACKPLANE)
        output_wav = new AudioOutputI2S(0, 1);
    #elif defined(EXTERNAL_DAC_BACKPLANE)
        output_wav = new AudioOutputI2S();
    //External DAC decoding
        output_wav->SetPinout(TWATCH_DAC_IIS_BCK, TWATCH_DAC_IIS_WS, TWATCH_DAC_IIS_DOUT);
    #endif
    wav_generator = new AudioGeneratorWAV();
    wav_generator->begin(file_wav, output_wav);
*/    
}
