#include "twatch.h"
#include "variables.h"
#include "functions.h"
//for microphone:
#include <driver/i2s.h>
#define BUFFER_SIZE (2*128)
// TWATCH 2020 V3 PDM microphone pin
#define MIC_DATA            2
#define MIC_CLOCK           0
uint8_t buffer[BUFFER_SIZE] = {0};

int x=0;

int micvalue=0;
int micvalue_old=0;
int minimum=0;
int maximum=0;
void setup() 
{
    setupTWATCH();
    //begin setup microphone
    i2s_config_t i2s_config = {
        .mode = (i2s_mode_t)(I2S_MODE_MASTER | I2S_MODE_RX | I2S_MODE_PDM),
        .sample_rate =  44100,
        .bits_per_sample = I2S_BITS_PER_SAMPLE_16BIT,
        .channel_format = I2S_CHANNEL_FMT_RIGHT_LEFT,
        .communication_format = (i2s_comm_format_t)(I2S_COMM_FORMAT_I2S | I2S_COMM_FORMAT_I2S_MSB),
        .intr_alloc_flags = ESP_INTR_FLAG_LEVEL1,
        .dma_buf_count = 2,
        .dma_buf_len = 128,
    };

    i2s_pin_config_t i2s_cfg;
    i2s_cfg.bck_io_num   = I2S_PIN_NO_CHANGE;
    i2s_cfg.ws_io_num    = MIC_CLOCK;
    i2s_cfg.data_out_num = I2S_PIN_NO_CHANGE;
    i2s_cfg.data_in_num  = MIC_DATA;

    i2s_driver_install(I2S_NUM_0, &i2s_config, 0, NULL);
    i2s_set_pin(I2S_NUM_0, &i2s_cfg);
    i2s_set_clk(I2S_NUM_0, 44100, I2S_BITS_PER_SAMPLE_16BIT, I2S_CHANNEL_MONO);  
    //end setup microphone
    setFont(1,255,255,255, 0,255,0);
    stroke(0,0,255);
    backlight(true); 
}

void loop() 
{
    size_t read_len = 0;
    i2s_read(I2S_NUM_0, (char *) buffer, BUFFER_SIZE, &read_len, portMAX_DELAY);    
    minimum = buffer[0*2]+buffer[0*2+1]*256;
    maximum = minimum;
    for (int i = 0; i < BUFFER_SIZE/2 ; i++) 
    {
        micvalue = buffer[i*2]+buffer[i*2+1]*256;
        if(micvalue>maximum) maximum = micvalue;
        if(micvalue<minimum) minimum = micvalue;
    }    
    clear();
    for (int i = 0; i < BUFFER_SIZE/2 ; i++) 
    {
        micvalue = buffer[i*2]+buffer[i*2+1]*256;
        micvalue-=minimum;
        micvalue*=height;
        micvalue/=(maximum-minimum);
        line(i+110,micvalue_old,i+111,micvalue);    

        micvalue_old = micvalue;
    }
    //micvalue = buffer[0*2]+buffer[0*2+1]*256;
    cursor(0,0);
    editor(minimum);
    editor("\n");
    editor(maximum);
    
    delay(100);  
}
